/*
 * Decompiled with CFR 0.152.
 */
package xtools.genesettools;

import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.TemplateMode;
import edu.mit.broad.genome.reports.pages.HtmlReportIndexPage;
import edu.mit.broad.xbench.heatmap.GramImager;
import java.awt.image.BufferedImage;
import java.util.Properties;
import org.apache.ecs.html.Div;
import org.apache.ecs.html.H4;
import org.apache.ecs.html.UL;
import xapps.api.vtools.viewers.VizFactory;
import xtools.api.AbstractTool;
import xtools.api.ToolCategory;
import xtools.api.param.ChipOptParam;
import xtools.api.param.DatasetReqdParam;
import xtools.api.param.GeneSetMatrixMultiChooserParam;
import xtools.api.param.GenesOfInterestParam;
import xtools.api.param.StringMultiInputParam;
import xtools.api.param.TemplateSingleChooserParam;

public class GeneSetHeatMap
extends AbstractTool {
    private final DatasetReqdParam fDatasetParam = new DatasetReqdParam();
    private final StringMultiInputParam fNamesParam = new StringMultiInputParam("names", "Extract these features", "Row or column names from dataset, whitespace or comma delimited", new String[0], false);
    private final GeneSetMatrixMultiChooserParam fGeneSetParam = new GeneSetMatrixMultiChooserParam("grp", "Gene set", "GeneSet (grp file; only 1 allowed)", false, true, false);
    private final ChipOptParam fChipParam = new ChipOptParam();
    private final TemplateSingleChooserParam fTemplateParam = new TemplateSingleChooserParam(false, TemplateMode.ALL);
    private final GenesOfInterestParam fGinParam = new GenesOfInterestParam();

    public GeneSetHeatMap(Properties properties) {
        super.init(properties);
    }

    public GeneSetHeatMap(String[] stringArray) {
        super.init(stringArray);
    }

    public GeneSetHeatMap() {
        this.declareParams();
    }

    @Override
    public final void execute() {
        GeneSet geneSet;
        this.startExec();
        Dataset dataset = this.fDatasetParam.getDataset();
        if (this.fNamesParam.isSpecified()) {
            geneSet = this.fNamesParam.getAsGeneSet();
        } else if (this.fGeneSetParam.isSpecified()) {
            geneSet = this.fGeneSetParam.getGeneSets(true)[0];
        } else {
            throw new IllegalArgumentException("At least one of " + this.fNamesParam.getName() + " or " + this.fGeneSetParam.getName() + " must be specified");
        }
        Dataset dataset2 = new DatasetGenerators().extractRows(dataset, geneSet);
        if (dataset2.getNumRow() == 0) {
            throw new IllegalArgumentException("No members of the specified gene set are in the dataset!");
        }
        HtmlReportIndexPage htmlReportIndexPage = this.fReport.getIndexPage();
        Div div = new Div();
        H4 h4 = new H4("Heat map of dataset " + dataset.getName() + " in the space of gene set: " + geneSet.getName(true));
        div.addElement(h4);
        UL uL = new UL();
        this.fReport.savePageInvisibly2Cache(dataset2.getName(), "Expression values in the space of the specified gene set", dataset2);
        div.addElement(uL);
        htmlReportIndexPage.addBlock(div, false);
        GramImager gramImager = VizFactory.createGramImager();
        GeneSetHeatMap.setChip(dataset, this.fChipParam, this.fGinParam);
        BufferedImage bufferedImage = this.fTemplateParam.isSpecified() ? gramImager.createBpogImage(dataset2, this.fTemplateParam.getTemplate()) : gramImager.createBpogImage(dataset2);
        htmlReportIndexPage.addImage("HeatMap", "Heat map in the space of the specified gene set", bufferedImage);
        this.doneExec();
    }

    @Override
    public final ToolCategory getCategory() {
        return ToolCategory.GENESET_TOOLS;
    }

    @Override
    public final String getDesc() {
        return "Draw a heat map for a gene set";
    }

    @Override
    public final void declareParams() {
        this.fParamSet.addParam(this.fDatasetParam);
        this.fParamSet.addParamPseudoReqd(this.fGeneSetParam);
        this.fParamSet.addParamPseudoReqd(this.fNamesParam);
        this.fParamSet.addParam(this.fChipParam);
        this.fParamSet.addParam(this.fTemplateParam);
        this.fParamSet.addParam(this.fGinParam);
    }

    public static final void main(String[] stringArray) {
        GeneSetHeatMap geneSetHeatMap = new GeneSetHeatMap(stringArray);
        GeneSetHeatMap.tool_main(geneSetHeatMap);
    }
}

