/*
 * Decompiled with CFR 0.152.
 */
package xtools.munge;

import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.alg.DatasetGenerators$CollapseStruc;
import edu.mit.broad.genome.alg.DatasetGenerators$CollapsedDataset;
import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.vdb.chip.Chip;
import java.util.Properties;
import xtools.api.AbstractTool;
import xtools.api.ToolCategory;
import xtools.api.param.BooleanParam;
import xtools.api.param.ChipChooserMultiParam;
import xtools.api.param.DatasetReqdParam;
import xtools.api.param.ModeReqdParam;

public class CollapseDataset
extends AbstractTool {
    private final ChipChooserMultiParam fChipParam = new ChipChooserMultiParam(true);
    private final DatasetReqdParam fDatasetParam = new DatasetReqdParam();
    private final ModeReqdParam fModeParm = new ModeReqdParam("mode", "Collapsing mode for probe sets => 1 gene", "Collapsing mode for probe sets => 1 gene", new String[]{"Max_probe", "Median_of_probes"});
    private final BooleanParam fIncludeOnlySymbols = new BooleanParam("include_only_symbols", "Omit features with no symbol match", "If there is no known gene symbol match for a probe set omit if from the collapsed dataset", true, false);

    public CollapseDataset(Properties properties) {
        super.init(properties);
    }

    public CollapseDataset(String[] stringArray) {
        super.init(stringArray);
    }

    public CollapseDataset() {
        this.declareParams();
    }

    @Override
    public final void execute() {
        this.startExec();
        Chip chip = this.fChipParam.getChipCombo();
        Dataset dataset = this.fDatasetParam.getDataset();
        DatasetGenerators$CollapsedDataset datasetGenerators$CollapsedDataset = new DatasetGenerators().collapse_core(dataset, chip, this.fIncludeOnlySymbols.isTrue(), this.fModeParm.getStringIndexChoosen());
        this.log.debug("# after collapsing: " + datasetGenerators$CollapsedDataset.symbolized.getNumRow());
        this.fReport.savePage(datasetGenerators$CollapsedDataset.symbolized);
        String[] stringArray = new String[]{"# MATCHING PROBE SETS", "MATCHING PROBE SET(S)"};
        String[] stringArray2 = new String[datasetGenerators$CollapsedDataset.symbolized.getNumRow()];
        StringMatrix stringMatrix = new StringMatrix(stringArray2.length, stringArray.length);
        for (int i2 = 0; i2 < datasetGenerators$CollapsedDataset.symbolized.getNumRow(); ++i2) {
            stringArray2[i2] = datasetGenerators$CollapsedDataset.symbolized.getRowName(i2);
            DatasetGenerators$CollapseStruc datasetGenerators$CollapseStruc = (DatasetGenerators$CollapseStruc)datasetGenerators$CollapsedDataset.symbolCollapseStrucMap.get(datasetGenerators$CollapsedDataset.symbolized.getRowName(i2));
            stringMatrix.setElement(i2, 0, datasetGenerators$CollapseStruc.getProbes().length);
            stringMatrix.setElement(i2, 1, datasetGenerators$CollapseStruc.getProbes());
        }
        this.fReport.savePageXls(new StringDataframe("Symbol_to_probe_set_mapping_details", stringMatrix, stringArray2, stringArray, true));
        this.doneExec();
    }

    @Override
    public final String getDesc() {
        return "Collapse expression values from multiple probe sets of a gene to a single value";
    }

    @Override
    public final ToolCategory getCategory() {
        return ToolCategory.DATASET;
    }

    @Override
    public final void declareParams() {
        this.fParamSet.addParam(this.fChipParam);
        this.fParamSet.addParam(this.fDatasetParam);
        this.fParamSet.addParam(this.fIncludeOnlySymbols);
        this.fParamSet.addParam(this.fModeParm);
    }

    public static final void main(String[] stringArray) {
        CollapseDataset collapseDataset = new CollapseDataset(stringArray);
        CollapseDataset.tool_main(collapseDataset);
    }
}

