/*
 * Decompiled with CFR 0.152.
 */
package Acme.JPM.Encoders;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

public abstract class ImageEncoder
implements ImageConsumer {
    protected OutputStream out;
    private ImageProducer producer;
    private int width = -1;
    private int height = -1;
    private int hintflags = 0;
    private boolean started = false;
    private boolean encoding;
    private IOException iox;
    private static final ColorModel rgbModel = ColorModel.getRGBdefault();
    private Hashtable props = null;
    private boolean accumulate = false;
    private int[] accumulator;

    public ImageEncoder(Image image, OutputStream outputStream) {
        this(image.getSource(), outputStream);
    }

    public ImageEncoder(ImageProducer imageProducer, OutputStream outputStream) {
        this.producer = imageProducer;
        this.out = outputStream;
    }

    abstract void encodeStart(int var1, int var2);

    abstract void encodePixels(int var1, int var2, int var3, int var4, int[] var5, int var6, int var7);

    abstract void encodeDone();

    public final synchronized void encode() {
        this.encoding = true;
        this.iox = null;
        this.producer.startProduction(this);
        while (this.encoding) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.iox != null) {
            throw this.iox;
        }
    }

    private void encodePixelsWrapper(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        if (!this.started) {
            this.started = true;
            this.encodeStart(this.width, this.height);
            if ((this.hintflags & 2) == 0) {
                this.accumulate = true;
                this.accumulator = new int[this.width * this.height];
            }
        }
        if (this.accumulate) {
            int n7 = 0;
            while (n7 < n4) {
                System.arraycopy(nArray, n7 * n6 + n5, this.accumulator, (n2 + n7) * this.width + n, n3);
                ++n7;
            }
        } else {
            this.encodePixels(n, n2, n3, n4, nArray, n5, n6);
        }
    }

    private void encodeFinish() {
        if (this.accumulate) {
            this.encodePixels(0, 0, this.width, this.height, this.accumulator, 0, this.width);
            this.accumulator = null;
            this.accumulate = false;
        }
    }

    private synchronized void stop() {
        this.encoding = false;
        this.notifyAll();
    }

    public final void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public final void setProperties(Hashtable hashtable) {
        this.props = hashtable;
    }

    public final void setColorModel(ColorModel colorModel) {
    }

    public final void setHints(int n) {
        this.hintflags = n;
    }

    public final void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int[] nArray = new int[n3];
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5 + n7 * n6;
            int n9 = 0;
            while (n9 < n3) {
                nArray[n9] = colorModel.getRGB(byArray[n8 + n9] & 0xFF);
                ++n9;
            }
            try {
                this.encodePixelsWrapper(n, n2 + n7, n3, 1, nArray, 0, n3);
            }
            catch (IOException iOException) {
                this.iox = iOException;
                this.stop();
                return;
            }
            ++n7;
        }
    }

    public final void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (colorModel == rgbModel) {
            try {
                this.encodePixelsWrapper(n, n2, n3, n4, nArray, n5, n6);
            }
            catch (IOException iOException) {
                this.iox = iOException;
                this.stop();
                return;
            }
        }
        int[] nArray2 = new int[n3];
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5 + n7 * n6;
            int n9 = 0;
            while (n9 < n3) {
                nArray2[n9] = colorModel.getRGB(nArray[n8 + n9]);
                ++n9;
            }
            try {
                this.encodePixelsWrapper(n, n2 + n7, n3, 1, nArray2, 0, n3);
            }
            catch (IOException iOException) {
                this.iox = iOException;
                this.stop();
                return;
            }
            ++n7;
        }
    }

    public final void imageComplete(int n) {
        this.producer.removeConsumer(this);
        if (n == 4) {
            this.iox = new IOException("image aborted");
        } else {
            try {
                this.encodeFinish();
                this.encodeDone();
            }
            catch (IOException iOException) {
                this.iox = iOException;
            }
        }
        this.stop();
    }
}

