/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.util.debug.Logger;

public class BandwidthThrottler {
    private static Logger log = Logger.getLogger("BandwidthThrottler");
    private long lastTime = 0L;
    private long lastBytes = 0L;
    private int thresholdBytesPerSec = -1;

    public BandwidthThrottler(int n) {
        this.thresholdBytesPerSec = n;
    }

    public final void setThreshold(int n) {
        this.thresholdBytesPerSec = n;
    }

    public final int getThreshold() {
        return this.thresholdBytesPerSec;
    }

    public final void throttleTransfer(long l2) {
        long l3 = System.currentTimeMillis();
        long l4 = l2 - this.lastBytes;
        long l5 = l3 - this.lastTime;
        if (l5 == 0L) {
            return;
        }
        double d2 = (double)l4 / (double)l5 * 1000.0;
        if (log.isDebugEnabled()) {
            log.debug("rate= " + d2);
        }
        while (d2 > (double)this.thresholdBytesPerSec) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Sleeping to decrease transfer rate (rate = " + d2 + " bytes/s");
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l5 = System.currentTimeMillis() - this.lastTime;
            d2 = (double)l4 / (double)l5 * 1000.0;
        }
        this.lastTime = l3;
        this.lastBytes = l2;
    }

    public final void reset() {
        this.lastTime = System.currentTimeMillis();
        this.lastBytes = 0L;
    }
}

