/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.AbstractFTPInputStream;
import com.enterprisedt.net.ftp.FTPASCIIInputStream;
import com.enterprisedt.net.ftp.FTPBinaryInputStream;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTransferInputStream;

public class FTPInputStream
extends FileTransferInputStream {
    private AbstractFTPInputStream stream;

    public FTPInputStream(FTPClient fTPClient, String string) {
        this(fTPClient, string, 0L);
    }

    public FTPInputStream(FTPClient fTPClient, String string, long l2) {
        this.remoteFile = string;
        boolean bl = fTPClient.getType().equals(FTPTransferType.ASCII);
        if (bl) {
            if (l2 > 0L) {
                throw new FTPException("Offset for ASCII transfers must be 0");
            }
            this.stream = new FTPASCIIInputStream(fTPClient, string, l2);
        } else {
            this.stream = new FTPBinaryInputStream(fTPClient, string, l2);
        }
    }

    public final int read() {
        return this.stream.read();
    }

    public final int read(byte[] byArray, int n, int n2) {
        return this.stream.read(byArray, n, n2);
    }

    public final void close() {
        this.stream.close();
    }

    public final long skip(long l2) {
        return this.stream.skip(l2);
    }

    public final synchronized void mark(int n) {
        this.stream.mark(n);
    }

    public final synchronized void reset() {
        this.stream.reset();
    }

    public final boolean markSupported() {
        return this.stream.markSupported();
    }
}

