/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

public class FileTypes {
    private Hashtable fileTypes = new Hashtable();
    public static final FileTypes ASCII = new FileTypes();
    public static final FileTypes BINARY = new FileTypes();

    private FileTypes() {
    }

    public final String[] extensions() {
        String[] stringArray = new String[this.fileTypes.size()];
        Enumeration enumeration = this.fileTypes.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public final void registerExtension(String string) {
        string = string.toUpperCase();
        this.fileTypes.put(string, string);
    }

    public final void unregisterExtension(String string) {
        string = string.toUpperCase();
        this.fileTypes.remove(string);
    }

    public final boolean matches(File file) {
        return this.matches(file.getName());
    }

    public final boolean matches(String string) {
        String string2;
        int n = string.lastIndexOf(".");
        return n > 0 && this.fileTypes.get(string2 = string.substring(n + 1).toUpperCase()) != null;
    }

    static {
        ASCII.registerExtension("ANS");
        ASCII.registerExtension("ASC");
        ASCII.registerExtension("ASM");
        ASCII.registerExtension("ASP");
        ASCII.registerExtension("ASPX");
        ASCII.registerExtension("ATOM");
        ASCII.registerExtension("AWK");
        ASCII.registerExtension("BAT");
        ASCII.registerExtension("BAS");
        ASCII.registerExtension("C");
        ASCII.registerExtension("CFM");
        ASCII.registerExtension("E");
        ASCII.registerExtension("CMD");
        ASCII.registerExtension("CGI");
        ASCII.registerExtension("COB");
        ASCII.registerExtension("CPP");
        ASCII.registerExtension("CS");
        ASCII.registerExtension("CSS");
        ASCII.registerExtension("CSV");
        ASCII.registerExtension("EPS");
        ASCII.registerExtension("F");
        ASCII.registerExtension("F77");
        ASCII.registerExtension("FOR");
        ASCII.registerExtension("FRM");
        ASCII.registerExtension("FTN");
        ASCII.registerExtension("H");
        ASCII.registerExtension("HPP");
        ASCII.registerExtension("HTM");
        ASCII.registerExtension("HTML");
        ASCII.registerExtension("HXX");
        ASCII.registerExtension("EML");
        ASCII.registerExtension("INC");
        ASCII.registerExtension("INF");
        ASCII.registerExtension("INFO");
        ASCII.registerExtension("INI");
        ASCII.registerExtension("JAVA");
        ASCII.registerExtension("JS");
        ASCII.registerExtension("JSP");
        ASCII.registerExtension("KSH");
        ASCII.registerExtension("LOG");
        ASCII.registerExtension("M");
        ASCII.registerExtension("PHP");
        ASCII.registerExtension("PHP1");
        ASCII.registerExtension("PHP2");
        ASCII.registerExtension("PHP3");
        ASCII.registerExtension("PHP4");
        ASCII.registerExtension("PHP5");
        ASCII.registerExtension("PHP6");
        ASCII.registerExtension("PHP7");
        ASCII.registerExtension("PHTML");
        ASCII.registerExtension("PL");
        ASCII.registerExtension("PS");
        ASCII.registerExtension("PY");
        ASCII.registerExtension("R");
        ASCII.registerExtension("RESX");
        ASCII.registerExtension("RSS");
        ASCII.registerExtension("SCPT");
        ASCII.registerExtension("SH");
        ASCII.registerExtension("SHP");
        ASCII.registerExtension("SHTML");
        ASCII.registerExtension("SQL");
        ASCII.registerExtension("SSI");
        ASCII.registerExtension("SVG");
        ASCII.registerExtension("TAB");
        ASCII.registerExtension("TCL");
        ASCII.registerExtension("TEX");
        ASCII.registerExtension("TXT");
        ASCII.registerExtension("UU");
        ASCII.registerExtension("UUE");
        ASCII.registerExtension("VB");
        ASCII.registerExtension("VBS");
        ASCII.registerExtension("XHTML");
        ASCII.registerExtension("XML");
        ASCII.registerExtension("XSL");
        BINARY.registerExtension("EXE");
        BINARY.registerExtension("PDF");
        BINARY.registerExtension("XLS");
        BINARY.registerExtension("DOC");
        BINARY.registerExtension("CHM");
        BINARY.registerExtension("PPT");
        BINARY.registerExtension("DOT");
        BINARY.registerExtension("DLL");
        BINARY.registerExtension("GIF");
        BINARY.registerExtension("JPG");
        BINARY.registerExtension("JPEG");
        BINARY.registerExtension("BMP");
        BINARY.registerExtension("TIF");
        BINARY.registerExtension("TIFF");
        BINARY.registerExtension("CLASS");
        BINARY.registerExtension("JAR");
        BINARY.registerExtension("SO");
        BINARY.registerExtension("AVI");
        BINARY.registerExtension("MP3");
        BINARY.registerExtension("MPG");
        BINARY.registerExtension("MPEG");
        BINARY.registerExtension("MSI");
        BINARY.registerExtension("OCX");
        BINARY.registerExtension("ZIP");
        BINARY.registerExtension("GZ");
        BINARY.registerExtension("RAM");
        BINARY.registerExtension("WAV");
        BINARY.registerExtension("WMA");
        BINARY.registerExtension("XLA");
        BINARY.registerExtension("XLL");
        BINARY.registerExtension("MDB");
        BINARY.registerExtension("MOV");
        BINARY.registerExtension("OBJ");
        BINARY.registerExtension("PUB");
        BINARY.registerExtension("PCX");
        BINARY.registerExtension("MID");
        BINARY.registerExtension("BIN");
        BINARY.registerExtension("WKS");
        BINARY.registerExtension("PNG");
        BINARY.registerExtension("WPS");
        BINARY.registerExtension("AAC");
        BINARY.registerExtension("AIFF");
        BINARY.registerExtension("PSP");
    }
}

