/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.util.debug.Logger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;

public class MVSFileParser
extends FTPFileParser {
    private static Logger log = Logger.getLogger("MVSFileParser");
    private static final String PARSER_KEY = "MVS";
    private static final String HEADER_VOLUME = "Volume";
    private static final String HEADER_NAME = "Name";
    private static final String LINE_TYPE_ARCIVE = "ARCIVE";
    private static final String ENTRY_FILE_TYPE = "PS";
    private static final String LINE_TYPE_MIGRATED = "Migrated";
    private static final int FOLDER_HEADER_TYPE_IDX = 0;
    private static final int FOLDER_LISTING_LENGTH_NORMAL = 10;
    private static final int FOLDER_LISTING_LENGTH_ARCIVE = 8;
    private String dateFormatString;
    private String alternateFormatString;
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat dateTimeFormat;
    private boolean partitionedDataset = false;

    public final boolean isValidFormat(String[] stringArray) {
        String[] stringArray2;
        log.debug("Checking MVS Parser for Valid Format...");
        if (stringArray.length > 0 && ((stringArray2 = this.splitMVSLine(stringArray[0])).length == 10 || stringArray2.length == 8)) {
            if (stringArray2[0].equals(HEADER_VOLUME)) {
                this.partitionedDataset = false;
                log.info("Detected MVS Directory Listing Format");
                return this.isValidDirectoryFormat(stringArray);
            }
            if (stringArray2[0].equals(HEADER_NAME)) {
                this.partitionedDataset = true;
                log.info("Detected MVS Partitioned Dataset Listing Format");
                return this.isValidPDSFormat(stringArray);
            }
        }
        return false;
    }

    public final FTPFile parse(String string) {
        String[] stringArray = this.splitMVSLine(string);
        FTPFile fTPFile = null;
        fTPFile = this.partitionedDataset ? this.parsePDSLine(stringArray, string) : this.parseFolder(stringArray, string);
        return fTPFile;
    }

    public final void setLocale(Locale locale) {
        log.debug("Ignoring the set locale.");
    }

    public final String toString() {
        return PARSER_KEY;
    }

    protected final FTPFile parsePDSLine(String[] stringArray, String string) {
        FTPFile fTPFile = null;
        if (stringArray[0].equals(HEADER_NAME)) {
            log.debug("Skipping header");
            return null;
        }
        fTPFile = new FTPFile(string);
        fTPFile.setName(stringArray[0]);
        if (this.dateTimeFormat == null) {
            this.dateTimeFormat = new SimpleDateFormat(this.dateFormatString + " HH:mm");
        }
        fTPFile.setCreated(this.dateFormat.parse(stringArray[2]));
        String string2 = stringArray[3] + ' ' + stringArray[4];
        fTPFile.setLastModified(this.dateTimeFormat.parse(string2));
        fTPFile.setDir(false);
        return fTPFile;
    }

    protected final FTPFile parseFolder(String[] stringArray, String string) {
        if (stringArray[0].equals(HEADER_VOLUME)) {
            log.debug("Skipping header");
            return null;
        }
        if (stringArray[0].equals(LINE_TYPE_ARCIVE)) {
            log.debug("Skipping ARCIVE file - not supported");
            return null;
        }
        if (stringArray[0].equals(LINE_TYPE_MIGRATED)) {
            log.debug("Skipping Migrated file - not supported");
            return null;
        }
        if (stringArray[5].charAt(0) != 'F' && stringArray[5].charAt(0) != 'V') {
            log.debug("Skipping unsupported recf - needs to start with F or V");
            return null;
        }
        if (stringArray[8].charAt(0) != 'P') {
            log.debug("Skipping unsupported organization - must be PS, PO, or PO-E");
            return null;
        }
        FTPFile fTPFile = new FTPFile(string);
        fTPFile.setName(stringArray[9]);
        fTPFile.setCreated(new Date());
        fTPFile.setLastModified(new Date());
        if (stringArray[8].equals(ENTRY_FILE_TYPE)) {
            log.debug("Found a file (PS) - " + stringArray[9]);
            fTPFile.setDir(false);
            long l2 = -1L;
            try {
                l2 = Long.parseLong(stringArray[4]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            fTPFile.setSize(l2);
        } else {
            log.debug("Found a folder (PO/PO-E) - " + stringArray[9]);
            fTPFile.setDir(true);
        }
        return fTPFile;
    }

    protected final String[] splitMVSLine(String string) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringArray[n] = string2.trim();
            ++n;
        }
        return stringArray;
    }

    protected final boolean isValidDirectoryFormat(String[] stringArray) {
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            String[] stringArray2 = this.splitMVSLine(stringArray[i2]);
            if (stringArray2.length == 2 && stringArray2[0].equals(LINE_TYPE_MIGRATED)) {
                log.debug("Detected a migrated entry");
            } else if (stringArray2.length != 10 && !stringArray2[0].equals(LINE_TYPE_ARCIVE)) {
                log.error("Invalid Directory Line: " + stringArray[i2]);
                return false;
            }
            if (this.dateFormatString != null) {
                if (this.checkDateFormat(stringArray2[2])) continue;
                return false;
            }
            if (stringArray2.length != 10) continue;
            this.guessDateFormat(stringArray2[2]);
        }
        return true;
    }

    protected final boolean isValidPDSFormat(String[] stringArray) {
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            String[] stringArray2 = this.splitMVSLine(stringArray[i2]);
            if (stringArray2.length != 9) {
                log.error("Invalid PDS Line: " + stringArray[i2]);
                return false;
            }
            if (this.dateFormatString != null) {
                if (this.checkDateFormat(stringArray2[3])) continue;
                return false;
            }
            this.guessDateFormat(stringArray2[2]);
        }
        return true;
    }

    protected final boolean checkDateFormat(String string) {
        try {
            this.dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            log.debug("Date parse exception - probably swapped day/month");
            if (this.alternateFormatString != null) {
                log.debug("Choosing alternate format");
                this.dateFormatString = this.alternateFormatString;
                this.dateFormat = new SimpleDateFormat(this.dateFormatString);
                this.alternateFormatString = null;
                try {
                    this.dateFormat.parse(string);
                }
                catch (ParseException parseException2) {
                    return false;
                }
            }
            log.error("FAIL - no alternate to fall back on. Date cannot be parsed - " + string);
            return false;
        }
        return true;
    }

    protected final void guessDateFormat(String string) {
        log.debug("Guessing the date format...");
        String[] stringArray = string.split("/");
        String string2 = null;
        int n = -1;
        int n2 = -1;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            int n3 = Integer.parseInt(stringArray[i2]);
            if (stringArray[i2].length() == 4) {
                string2 = "yyyy";
                n = i2;
                continue;
            }
            if (n3 > 31) {
                string2 = "yy";
                n = i2;
                continue;
            }
            if (n3 <= 12) continue;
            n2 = i2;
        }
        if (string2 != null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (n2 >= 0) {
                String[] stringArray2 = new String[3];
                stringArray2[n] = string2;
                stringArray2[n2] = "dd";
                for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                    stringBuffer.append(i3 > 0 ? "/" : "");
                    stringBuffer.append(stringArray2[i3] == null ? "MM" : stringArray2[i3]);
                }
                log.debug("Easy one - found obvious year, and obvious day");
            } else {
                StringBuffer stringBuffer2 = new StringBuffer();
                if (n == 0) {
                    stringBuffer.append(string2).append("/MM/dd");
                    stringBuffer2.append(string2).append("/dd/MM");
                } else {
                    stringBuffer.append("MM/dd/").append(string2);
                    stringBuffer2.append("dd/MM/").append(string2);
                }
                this.alternateFormatString = stringBuffer2.toString();
                log.debug("Ambiguous one - found obvious year, but day/month could be wrong so created alternate");
            }
            this.dateFormatString = stringBuffer.toString();
            this.dateFormat = new SimpleDateFormat(this.dateFormatString);
            log.debug("Decided on " + this.dateFormatString);
            try {
                this.dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                log.debug("Parse failed - Invalid Date: " + string);
            }
        } else {
            log.debug("Could not figure out year from this date format");
            return;
        }
    }

    public final boolean isPartitionedDataset() {
        return this.partitionedDataset;
    }

    public final String getDateFormatString() {
        return this.dateFormatString;
    }

    public final void setDateFormatString(String string) {
        this.dateFormatString = string;
    }
}

