/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.CodeSource;

public class VersionDetails {
    private static final String majorVersion = "2";
    private static final String middleVersion = "4";
    private static final String minorVersion = "0";
    private static int[] version;
    private static String versionString;
    private static final String buildTimestamp = "24-Dec-2012 12:36:06 EST";

    public static final int[] getVersion() {
        return version;
    }

    public static final String getVersionString() {
        return versionString;
    }

    public static final String getBuildTimestamp() {
        return buildTimestamp;
    }

    public static final String report(Object object) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        try {
            if (object != null) {
                printWriter.print("Class: ");
                printWriter.println(object.getClass().getName());
                printWriter.print("Location: ");
                CodeSource codeSource = object.getClass().getProtectionDomain().getCodeSource();
                if (codeSource != null) {
                    printWriter.println(codeSource.getLocation().toString());
                } else {
                    printWriter.println("unknown");
                }
            } else {
                printWriter.print("Null object supplied");
            }
            printWriter.print("Version: ");
            printWriter.println(versionString);
            printWriter.print("Build timestamp: ");
            printWriter.println(buildTimestamp);
            printWriter.print("Java version: ");
            printWriter.println(System.getProperty("java.version"));
            printWriter.print("CLASSPATH: ");
            printWriter.println(System.getProperty("java.class.path"));
            printWriter.print("OS name: ");
            printWriter.println(System.getProperty("os.name"));
            printWriter.print("OS arch: ");
            printWriter.println(System.getProperty("os.arch"));
            printWriter.print("OS version: ");
            printWriter.println(System.getProperty("os.version"));
        }
        catch (Throwable throwable) {
            printWriter.println("Could not obtain version details: " + throwable.getMessage());
        }
        return stringWriter.toString();
    }

    static {
        try {
            version = new int[3];
            VersionDetails.version[0] = Integer.parseInt(majorVersion);
            VersionDetails.version[1] = Integer.parseInt(middleVersion);
            VersionDetails.version[2] = Integer.parseInt(minorVersion);
            versionString = version[0] + "." + version[1] + "." + version[2];
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Failed to calculate version: " + numberFormatException.getMessage());
            versionString = "Unknown";
        }
    }
}

