/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.common;

import com.jgoodies.looks.LookUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.PrintGraphics;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.print.PrinterGraphics;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public final class RenderingUtils {
    private static final String PROP_DESKTOPHINTS = "awt.font.desktophints";
    private static final String SWING_UTILITIES2_NAME = LookUtils.IS_JAVA_6_OR_LATER ? "sun.swing.SwingUtilities2" : "com.sun.java.swing.SwingUtilities2";
    private static Method drawStringUnderlineCharAtMethod = null;
    static Class class$javax$swing$JComponent;
    static Class class$java$awt$Graphics;
    static Class class$java$lang$String;

    private RenderingUtils() {
    }

    public static final void drawStringUnderlineCharAt(JComponent jComponent, Graphics graphics, String string, int n, int n2, int n3) {
        if (LookUtils.IS_JAVA_5_OR_LATER) {
            if (drawStringUnderlineCharAtMethod != null) {
                try {
                    drawStringUnderlineCharAtMethod.invoke(null, jComponent, graphics, string, new Integer(n), new Integer(n2), new Integer(n3));
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            Map map = RenderingUtils.installDesktopHints(graphics2D);
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n, n2, n3);
            if (map != null) {
                graphics2D.addRenderingHints(map);
            }
            return;
        }
        BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n, n2, n3);
    }

    private static Method getMethodDrawStringUnderlineCharAt() {
        try {
            Class<?> clazz = Class.forName(SWING_UTILITIES2_NAME);
            return clazz.getMethod("drawStringUnderlineCharAt", class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = RenderingUtils.class$("javax.swing.JComponent")) : class$javax$swing$JComponent, class$java$awt$Graphics == null ? (class$java$awt$Graphics = RenderingUtils.class$("java.awt.Graphics")) : class$java$awt$Graphics, class$java$lang$String == null ? (class$java$lang$String = RenderingUtils.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static Map installDesktopHints(Graphics2D graphics2D) {
        Map map;
        HashMap<RenderingHints.Key, Object> hashMap = null;
        if (LookUtils.IS_JAVA_6_OR_LATER && (map = RenderingUtils.desktopHints(graphics2D)) != null && !map.isEmpty()) {
            hashMap = new HashMap<RenderingHints.Key, Object>(map.size());
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                RenderingHints.Key key = (RenderingHints.Key)iterator.next();
                hashMap.put(key, graphics2D.getRenderingHint(key));
            }
            graphics2D.addRenderingHints(map);
        }
        return hashMap;
    }

    private static Map desktopHints(Graphics2D graphics2D) {
        Object v;
        if (RenderingUtils.isPrinting(graphics2D)) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsDevice graphicsDevice = graphics2D.getDeviceConfiguration().getDevice();
        Map map = (Map)toolkit.getDesktopProperty("awt.font.desktophints." + graphicsDevice.getIDstring());
        if (map == null) {
            map = (Map)toolkit.getDesktopProperty(PROP_DESKTOPHINTS);
        }
        if (map != null && ((v = map.get(RenderingHints.KEY_TEXT_ANTIALIASING)) == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF || v == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT)) {
            map = null;
        }
        return map;
    }

    private static boolean isPrinting(Graphics graphics) {
        return graphics instanceof PrintGraphics || graphics instanceof PrinterGraphics;
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        if (LookUtils.IS_JAVA_5_OR_LATER) {
            drawStringUnderlineCharAtMethod = RenderingUtils.getMethodDrawStringUnderlineCharAt();
        }
    }
}

