/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.BumpBuffer;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;

final class PlasticBumps
implements Icon {
    protected int xBumps;
    protected int yBumps;
    protected Color topColor;
    protected Color shadowColor;
    protected Color backColor;
    protected static Vector buffers = new Vector();
    protected BumpBuffer buffer;

    public PlasticBumps(Dimension dimension) {
        this(dimension.width, dimension.height);
    }

    public PlasticBumps(int n, int n2) {
        this(n, n2, PlasticLookAndFeel.getPrimaryControlHighlight(), PlasticLookAndFeel.getPrimaryControlDarkShadow(), PlasticLookAndFeel.getPrimaryControlShadow());
    }

    public PlasticBumps(int n, int n2, Color color, Color color2, Color color3) {
        this.setBumpArea(n, n2);
        this.setBumpColors(color, color2, color3);
    }

    private BumpBuffer getBuffer(GraphicsConfiguration graphicsConfiguration, Color color, Color color2, Color color3) {
        if (this.buffer != null && this.buffer.hasSameConfiguration(graphicsConfiguration, color, color2, color3)) {
            return this.buffer;
        }
        BumpBuffer bumpBuffer = null;
        Enumeration enumeration = buffers.elements();
        while (enumeration.hasMoreElements()) {
            BumpBuffer bumpBuffer2 = (BumpBuffer)enumeration.nextElement();
            if (!bumpBuffer2.hasSameConfiguration(graphicsConfiguration, color, color2, color3)) continue;
            bumpBuffer = bumpBuffer2;
            break;
        }
        if (bumpBuffer == null) {
            bumpBuffer = new BumpBuffer(graphicsConfiguration, this.topColor, this.shadowColor, this.backColor);
            buffers.addElement(bumpBuffer);
        }
        return bumpBuffer;
    }

    public final void setBumpArea(Dimension dimension) {
        this.setBumpArea(dimension.width, dimension.height);
    }

    public final void setBumpArea(int n, int n2) {
        this.xBumps = n / 2;
        this.yBumps = n2 / 2;
    }

    public final void setBumpColors(Color color, Color color2, Color color3) {
        this.topColor = color;
        this.shadowColor = color2;
        this.backColor = color3;
    }

    public final void paintIcon(Component component, Graphics graphics, int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = graphics instanceof Graphics2D ? ((Graphics2D)graphics).getDeviceConfiguration() : null;
        this.buffer = this.getBuffer(graphicsConfiguration, this.topColor, this.shadowColor, this.backColor);
        int n3 = this.buffer.getImageSize().width;
        int n4 = this.buffer.getImageSize().height;
        int n5 = this.getIconWidth();
        int n6 = this.getIconHeight();
        int n7 = n + n5;
        int n8 = n2 + n6;
        int n9 = n;
        while (n2 < n8) {
            int n10 = Math.min(n8 - n2, n4);
            for (n = n9; n < n7; n += n3) {
                int n11 = Math.min(n7 - n, n3);
                graphics.drawImage(this.buffer.getImage(), n, n2, n + n11, n2 + n10, 0, 0, n11, n10, null);
            }
            n2 += n4;
        }
    }

    public final int getIconWidth() {
        return this.xBumps * 2;
    }

    public final int getIconHeight() {
        return this.yBumps * 2;
    }
}

