/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticComboBoxButton;
import com.jgoodies.looks.plastic.PlasticComboBoxEditor$UIResource;
import com.jgoodies.looks.plastic.PlasticComboBoxUI$PlasticComboBoxLayoutManager;
import com.jgoodies.looks.plastic.PlasticComboBoxUI$PlasticComboPopup;
import com.jgoodies.looks.plastic.PlasticComboBoxUI$PlasticPropertyChangeListener;
import com.jgoodies.looks.plastic.PlasticComboBoxUI$TableCellEditorPropertyChangeHandler;
import com.jgoodies.looks.plastic.PlasticIconFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import javax.swing.plaf.metal.MetalTextFieldUI;

public class PlasticComboBoxUI
extends MetalComboBoxUI {
    static final String CELL_EDITOR_KEY = "JComboBox.isTableCellEditor";
    private static final JTextField PHANTOM = new JTextField("Phantom");
    private static Class phantomLafClass;
    private boolean tableCellEditor;
    private PropertyChangeListener propertyChangeListener;

    public static final ComponentUI createUI(JComponent jComponent) {
        PlasticComboBoxUI.ensurePhantomHasPlasticUI();
        return new PlasticComboBoxUI();
    }

    private static void ensurePhantomHasPlasticUI() {
        TextUI textUI = PHANTOM.getUI();
        Class<?> clazz = UIManager.getLookAndFeel().getClass();
        if (phantomLafClass != clazz || !(textUI instanceof MetalTextFieldUI)) {
            phantomLafClass = clazz;
            PHANTOM.updateUI();
        }
    }

    public final void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.tableCellEditor = this.isTableCellEditor();
    }

    protected final void installListeners() {
        super.installListeners();
        this.propertyChangeListener = new PlasticComboBoxUI$TableCellEditorPropertyChangeHandler(this, null);
        this.comboBox.addPropertyChangeListener(CELL_EDITOR_KEY, this.propertyChangeListener);
    }

    protected final void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removePropertyChangeListener(CELL_EDITOR_KEY, this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected final JButton createArrowButton() {
        return new PlasticComboBoxButton(this.comboBox, PlasticIconFactory.getComboBoxButtonIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
    }

    protected final ComboBoxEditor createEditor() {
        return new PlasticComboBoxEditor$UIResource(this.tableCellEditor);
    }

    protected final LayoutManager createLayoutManager() {
        return new PlasticComboBoxUI$PlasticComboBoxLayoutManager(this, null);
    }

    protected final ComboPopup createPopup() {
        return new PlasticComboBoxUI$PlasticComboPopup(this.comboBox, null);
    }

    protected final ListCellRenderer createRenderer() {
        if (this.tableCellEditor) {
            return super.createRenderer();
        }
        BasicComboBoxRenderer.UIResource uIResource = new BasicComboBoxRenderer.UIResource();
        uIResource.setBorder(UIManager.getBorder("ComboBox.rendererBorder"));
        return uIResource;
    }

    public final Dimension getMinimumSize(JComponent jComponent) {
        Serializable serializable;
        Insets insets;
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = this.getDisplaySize();
        Insets insets2 = this.getInsets();
        dimension.height += insets2.top + insets2.bottom;
        if (this.comboBox.isEditable()) {
            insets = UIManager.getInsets("ComboBox.editorBorderInsets");
            dimension.width += insets.left + insets.right;
            ++dimension.width;
        } else if (this.arrowButton != null) {
            insets = this.arrowButton.getInsets();
            dimension.width += insets.left;
        }
        int n = PlasticComboBoxUI.getEditableButtonWidth();
        dimension.width += insets2.left + insets2.right + n;
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        if (listCellRenderer instanceof JComponent) {
            serializable = (JComponent)((Object)listCellRenderer);
            Insets insets3 = ((JComponent)serializable).getInsets();
            Insets insets4 = UIManager.getInsets("ComboBox.editorInsets");
            int n2 = Math.max(0, insets4.left - insets3.left);
            int n3 = Math.max(0, insets4.right - insets3.right);
            dimension.width += n2 + n3;
        }
        serializable = PHANTOM.getMinimumSize();
        dimension.height = Math.max(((Dimension)serializable).height, dimension.height);
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(dimension);
    }

    public final Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    protected final Rectangle rectangleForCurrentValue() {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int n3 = PlasticComboBoxUI.getEditableButtonWidth();
        if (this.arrowButton != null) {
            n3 = this.arrowButton.getWidth();
        }
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left, insets.top, n - (insets.left + insets.right + n3), n2 - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + n3, insets.top, n - (insets.left + insets.right + n3), n2 - (insets.top + insets.bottom));
    }

    public final void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            if (this.isToolBarComboBox(jComponent)) {
                jComponent.setOpaque(false);
            }
        }
        this.paint(graphics, jComponent);
    }

    protected final boolean isToolBarComboBox(JComponent jComponent) {
        Container container = jComponent.getParent();
        return container != null && (container instanceof JToolBar || container.getParent() instanceof JToolBar);
    }

    static final int getEditableButtonWidth() {
        return UIManager.getInt("ScrollBar.width") - 1;
    }

    private boolean isTableCellEditor() {
        return Boolean.TRUE.equals(this.comboBox.getClientProperty(CELL_EDITOR_KEY));
    }

    public final PropertyChangeListener createPropertyChangeListener() {
        return new PlasticComboBoxUI$PlasticPropertyChangeListener(this, null);
    }

    static final Insets access$300(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.getInsets();
    }

    static final JButton access$400(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.arrowButton;
    }

    static final JButton access$500(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.arrowButton;
    }

    static final JButton access$600(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.arrowButton;
    }

    static final Component access$700(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.editor;
    }

    static final Component access$800(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.editor;
    }

    static final JButton access$1000(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.arrowButton;
    }

    static final JComboBox access$1100(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.comboBox;
    }

    static final JComboBox access$1200(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.comboBox;
    }

    static final JButton access$1300(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.arrowButton;
    }

    static final JList access$1400(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.listBox;
    }

    static final JButton access$1500(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.arrowButton;
    }

    static final JList access$1600(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.listBox;
    }

    static final boolean access$1702(PlasticComboBoxUI plasticComboBoxUI, boolean bl) {
        plasticComboBoxUI.tableCellEditor = bl;
        return plasticComboBoxUI.tableCellEditor;
    }

    static final boolean access$1800(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.isTableCellEditor();
    }

    static final JComboBox access$1900(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.comboBox;
    }

    static final JComboBox access$2000(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.comboBox;
    }

    static final JComboBox access$2100(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.comboBox;
    }

    static final JComboBox access$2200(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.comboBox;
    }

    static final JComboBox access$2300(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.comboBox;
    }

    static final JComboBox access$2400(PlasticComboBoxUI plasticComboBoxUI) {
        return plasticComboBoxUI.comboBox;
    }
}

