/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticBumps;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;

public final class PlasticInternalFrameTitlePane
extends MetalInternalFrameTitlePane {
    private PlasticBumps paletteBumps;
    private final PlasticBumps activeBumps = new PlasticBumps(0, 0, PlasticLookAndFeel.getPrimaryControlHighlight(), PlasticLookAndFeel.getPrimaryControlDarkShadow(), PlasticLookAndFeel.getPrimaryControl());
    private final PlasticBumps inactiveBumps = new PlasticBumps(0, 0, PlasticLookAndFeel.getControlHighlight(), PlasticLookAndFeel.getControlDarkShadow(), PlasticLookAndFeel.getControl());

    public PlasticInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    public final void paintPalette(Graphics graphics) {
        boolean bl = PlasticUtils.isLeftToRight(this.frame);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.paletteBumps == null) {
            this.paletteBumps = new PlasticBumps(0, 0, PlasticLookAndFeel.getPrimaryControlHighlight(), PlasticLookAndFeel.getPrimaryControlInfo(), PlasticLookAndFeel.getPrimaryControlShadow());
        }
        ColorUIResource colorUIResource = PlasticLookAndFeel.getPrimaryControlShadow();
        ColorUIResource colorUIResource2 = PlasticLookAndFeel.getControlDarkShadow();
        graphics.setColor(colorUIResource);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(colorUIResource2);
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
        int n3 = this.getButtonsWidth();
        int n4 = bl ? 4 : n3 + 4;
        int n5 = n - n3 - 8;
        int n6 = this.getHeight() - 4;
        this.paletteBumps.setBumpArea(n5, n6);
        this.paletteBumps.paintIcon(this, graphics, n4, 2);
    }

    public final void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        PlasticBumps plasticBumps;
        if (this.isPalette) {
            this.paintPalette(graphics);
            return;
        }
        boolean bl = PlasticUtils.isLeftToRight(this.frame);
        boolean bl2 = this.frame.isSelected();
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        ColorUIResource colorUIResource = null;
        ColorUIResource colorUIResource2 = null;
        ColorUIResource colorUIResource3 = null;
        if (bl2) {
            colorUIResource = PlasticLookAndFeel.getWindowTitleBackground();
            colorUIResource2 = PlasticLookAndFeel.getWindowTitleForeground();
            plasticBumps = this.activeBumps;
        } else {
            colorUIResource = PlasticLookAndFeel.getWindowTitleInactiveBackground();
            colorUIResource2 = PlasticLookAndFeel.getWindowTitleInactiveForeground();
            plasticBumps = this.inactiveBumps;
        }
        colorUIResource3 = PlasticLookAndFeel.getControlDarkShadow();
        graphics.setColor(colorUIResource);
        graphics.fillRect(0, 0, n5, n6);
        graphics.setColor(colorUIResource3);
        graphics.drawLine(0, n6 - 1, n5, n6 - 1);
        graphics.drawLine(0, 0, 0, 0);
        graphics.drawLine(n5 - 1, 0, n5 - 1, 0);
        int n7 = 0;
        int n8 = bl ? 5 : n5 - 5;
        String string = this.frame.getTitle();
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            if (!bl) {
                n8 -= icon.getIconWidth();
            }
            n4 = n6 / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, graphics, n8, n4);
            n8 += bl ? icon.getIconWidth() + 5 : -5;
        }
        if (string != null) {
            Font font = this.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.setColor(colorUIResource2);
            n3 = (n6 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                rectangle = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                rectangle = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                rectangle = this.closeButton.getBounds();
            }
            if (bl) {
                if (rectangle.x == 0) {
                    rectangle.x = this.frame.getWidth() - this.frame.getInsets().right - 2;
                }
                n2 = rectangle.x - n8 - 4;
                string = this.getTitle(string, fontMetrics, n2);
            } else {
                n2 = n8 - rectangle.x - rectangle.width - 4;
                string = this.getTitle(string, fontMetrics, n2);
                n8 -= SwingUtilities.computeStringWidth(fontMetrics, string);
            }
            n7 = SwingUtilities.computeStringWidth(fontMetrics, string);
            graphics.drawString(string, n8, n3);
            n8 += bl ? n7 + 5 : -5;
        }
        n3 = this.getButtonsWidth();
        if (bl) {
            n = n5 - n3 - n8 - 5;
            n4 = n8;
        } else {
            n = n8 - n3 - 5;
            n4 = n3 + 5;
        }
        int n9 = 3;
        n2 = this.getHeight() - 2 * n9;
        plasticBumps.setBumpArea(n, n2);
        plasticBumps.paintIcon(this, graphics, n4, n9);
    }

    protected final String getTitle(String string, FontMetrics fontMetrics, int n) {
        if (string == null || string.equals("")) {
            return "";
        }
        int n2 = SwingUtilities.computeStringWidth(fontMetrics, string);
        String string2 = "...";
        if (n2 > n) {
            int n3;
            int n4 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            for (n3 = 0; n3 < string.length() && (n4 += fontMetrics.charWidth(string.charAt(n3))) <= n; ++n3) {
            }
            string = string.substring(0, n3) + string2;
        }
        return string;
    }

    private int getButtonsWidth() {
        int n;
        boolean bl = PlasticUtils.isLeftToRight(this.frame);
        int n2 = this.getWidth();
        int n3 = bl ? n2 : 0;
        int n4 = this.closeButton.getIcon().getIconWidth();
        if (this.frame.isClosable()) {
            if (this.isPalette) {
                n = 3;
                n3 += bl ? -n - (n4 + 2) : n;
                if (!bl) {
                    n3 += n4 + 2;
                }
            } else {
                n = 4;
                n3 += bl ? -n - n4 : n;
                if (!bl) {
                    n3 += n4;
                }
            }
        }
        if (this.frame.isMaximizable() && !this.isPalette) {
            n = this.frame.isClosable() ? 10 : 4;
            n3 += bl ? -n - n4 : n;
            if (!bl) {
                n3 += n4;
            }
        }
        if (this.frame.isIconifiable() && !this.isPalette) {
            n = this.frame.isMaximizable() ? 2 : (this.frame.isClosable() ? 10 : 4);
            n3 += bl ? -n - n4 : n;
            if (!bl) {
                n3 += n4;
            }
        }
        return bl ? n2 - n3 : n3;
    }
}

