/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;

public abstract class ArrayConverter
implements ObjectConverter {
    private String _separator;
    private int _size;
    private Class _elementClass;
    private Class[] _elementClasses;

    public ArrayConverter(String string, int n, Class clazz) {
        this._separator = string;
        this._size = n;
        this._elementClass = clazz;
    }

    public ArrayConverter(String string, int n, Class[] classArray) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("separator cannot be empty.");
        }
        if (classArray == null) {
            throw new IllegalArgumentException("elementClasses cannot be null.");
        }
        if (n != classArray.length) {
            throw new IllegalArgumentException("size must be equal to the length of elementClasses.");
        }
        this._separator = string;
        this._size = n;
        this._elementClasses = classArray;
    }

    public final String arrayToString(Object[] objectArray, ConverterContext converterContext) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            stringBuffer.append(this.toString(i2, object, converterContext));
            if (i2 == objectArray.length - 1) continue;
            stringBuffer.append(this._separator);
        }
        return new String(stringBuffer);
    }

    protected final String toString(int n, Object object, ConverterContext converterContext) {
        return this._elementClass != null ? ObjectConverterManager.toString(object, this._elementClass, converterContext) : ObjectConverterManager.toString(object, this._elementClasses[n], converterContext);
    }

    public final Object[] arrayFromString(String string, ConverterContext converterContext) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        String[] stringArray = string.split(this._separator);
        Object[] objectArray = new Object[this._size != -1 ? this._size : stringArray.length];
        for (int i2 = 0; i2 < objectArray.length && i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2].trim();
            objectArray[i2] = this.fromString(i2, string2, converterContext);
        }
        return objectArray;
    }

    protected final Object fromString(int n, String string, ConverterContext converterContext) {
        return this._elementClass != null ? ObjectConverterManager.fromString(string, this._elementClass, converterContext) : ObjectConverterManager.fromString(string, this._elementClasses[n], converterContext);
    }

    public final Class getElementClass() {
        return this._elementClass;
    }
}

