/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grouper;

import com.jidesoft.grouper.GrouperContext;
import com.jidesoft.grouper.ObjectGrouper;
import com.jidesoft.grouper.date.DateMonthGrouper;
import com.jidesoft.grouper.date.DateYearGrouper;
import com.jidesoft.utils.CacheMap;
import com.jidesoft.utils.RegistrationListener;
import java.util.Calendar;
import java.util.Date;

public class ObjectGrouperManager {
    private static CacheMap _cache = new CacheMap(GrouperContext.DEFAULT_CONTEXT);
    private static ObjectGrouper _defaultGrouper = null;
    private static boolean _inited = false;
    private static boolean _initing = false;
    private static boolean _autoInit = true;

    public static final void registerGrouper(Class clazz, ObjectGrouper objectGrouper, GrouperContext grouperContext) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter class cannot be null");
        }
        if (grouperContext == null) {
            grouperContext = GrouperContext.DEFAULT_CONTEXT;
        }
        if (ObjectGrouperManager.isAutoInit() && !_inited && !_initing) {
            ObjectGrouperManager.initDefaultGrouper();
        }
        _cache.register(clazz, objectGrouper, grouperContext);
    }

    public static final void registerGrouper(Class clazz, ObjectGrouper objectGrouper) {
        ObjectGrouperManager.registerGrouper(clazz, objectGrouper, GrouperContext.DEFAULT_CONTEXT);
    }

    public static final void unregisterGrouper(Class clazz, GrouperContext grouperContext) {
        if (grouperContext == null) {
            grouperContext = GrouperContext.DEFAULT_CONTEXT;
        }
        if (ObjectGrouperManager.isAutoInit() && !_inited && !_initing) {
            ObjectGrouperManager.initDefaultGrouper();
        }
        _cache.unregister(clazz, grouperContext);
    }

    public static final void unregisterGrouper(Class clazz) {
        ObjectGrouperManager.unregisterGrouper(clazz, GrouperContext.DEFAULT_CONTEXT);
    }

    public static final void unregisterAllGroupers(Class clazz) {
        _cache.remove(clazz);
    }

    public static final void unregisterAllGroupers() {
        _cache.clear();
    }

    public static final ObjectGrouper getGrouper(Class clazz, GrouperContext grouperContext) {
        ObjectGrouper objectGrouper;
        if (ObjectGrouperManager.isAutoInit() && !_inited && !_initing) {
            ObjectGrouperManager.initDefaultGrouper();
        }
        if (grouperContext == null) {
            grouperContext = GrouperContext.DEFAULT_CONTEXT;
        }
        if ((objectGrouper = (ObjectGrouper)_cache.getRegisteredObject(clazz, grouperContext)) != null) {
            return objectGrouper;
        }
        return _defaultGrouper;
    }

    public static final ObjectGrouper getGrouper(Class clazz) {
        return ObjectGrouperManager.getGrouper(clazz, GrouperContext.DEFAULT_CONTEXT);
    }

    public static final Object getGroupValue(Object object) {
        if (object != null) {
            return ObjectGrouperManager.getGroupValue(object, object.getClass(), GrouperContext.DEFAULT_CONTEXT);
        }
        return null;
    }

    public static final Object getGroupValue(Object object, Class clazz) {
        return ObjectGrouperManager.getGroupValue(object, clazz, GrouperContext.DEFAULT_CONTEXT);
    }

    public static final Object getGroupValue(Object object, Class clazz, GrouperContext grouperContext) {
        ObjectGrouper objectGrouper = ObjectGrouperManager.getGrouper(clazz, grouperContext);
        if (objectGrouper != null) {
            return objectGrouper.getValue(object);
        }
        return null;
    }

    public static final boolean isAutoInit() {
        return _autoInit;
    }

    public static final void setAutoInit(boolean bl) {
        _autoInit = bl;
    }

    public static final void addRegistrationListener(RegistrationListener registrationListener) {
        _cache.addRegistrationListener(registrationListener);
    }

    public static final void removeRegistrationListener(RegistrationListener registrationListener) {
        _cache.removeRegistrationListener(registrationListener);
    }

    public static final RegistrationListener[] getRegistrationListeners() {
        return _cache.getRegistrationListeners();
    }

    public static final GrouperContext[] getGrouperContexts(Class clazz) {
        return (GrouperContext[])_cache.getKeys(clazz, new GrouperContext[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void initDefaultGrouper() {
        if (_inited) {
            return;
        }
        _initing = true;
        try {
            DateYearGrouper dateYearGrouper = new DateYearGrouper();
            ObjectGrouperManager.registerGrouper(Date.class, dateYearGrouper, DateYearGrouper.CONTEXT);
            ObjectGrouperManager.registerGrouper(Calendar.class, dateYearGrouper, DateYearGrouper.CONTEXT);
            ObjectGrouperManager.registerGrouper(Long.class, dateYearGrouper, DateYearGrouper.CONTEXT);
            DateMonthGrouper dateMonthGrouper = new DateMonthGrouper();
            ObjectGrouperManager.registerGrouper(Date.class, dateMonthGrouper, DateMonthGrouper.CONTEXT);
            ObjectGrouperManager.registerGrouper(Calendar.class, dateMonthGrouper, DateMonthGrouper.CONTEXT);
            ObjectGrouperManager.registerGrouper(Long.class, dateMonthGrouper, DateMonthGrouper.CONTEXT);
        }
        finally {
            _initing = false;
            _inited = true;
        }
    }

    public static final void resetInit() {
        _inited = false;
    }

    public static final void clear() {
        ObjectGrouperManager.resetInit();
        _cache.clear();
    }
}

