/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.hints.FileIntelliHints;
import com.jidesoft.plaf.FolderChooserUI;
import com.jidesoft.plaf.basic.BasicFileSystemTree;
import com.jidesoft.plaf.basic.BasicFileSystemTreeNode;
import com.jidesoft.plaf.basic.BasicFolderChooserUI$1;
import com.jidesoft.plaf.basic.BasicFolderChooserUI$2;
import com.jidesoft.plaf.basic.BasicFolderChooserUI$3;
import com.jidesoft.plaf.basic.BasicFolderChooserUI$4;
import com.jidesoft.plaf.basic.BasicFolderChooserUI$5;
import com.jidesoft.plaf.basic.BasicFolderChooserUI$ApproveSelectionAction;
import com.jidesoft.plaf.basic.BasicFolderChooserUI$FolderChooserPropertyChangeListener;
import com.jidesoft.plaf.basic.BasicFolderChooserUI$FolderChooserSelectionListener;
import com.jidesoft.plaf.basic.BasicFolderChooserUI$NavigationTextFieldListener;
import com.jidesoft.plaf.basic.FolderToolBar;
import com.jidesoft.plaf.basic.FolderToolBarListener;
import com.jidesoft.swing.FolderChooser;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.SelectAllUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.tree.TreePath;
import sun.awt.shell.ShellFolder;

public class BasicFolderChooserUI
extends BasicFileChooserUI
implements FolderChooserUI {
    private FolderChooser _folderChooser;
    protected FolderToolBar _toolbar;
    protected JTree _fileSystemTree;
    protected JScrollPane _treeScrollPane;
    protected JButton _approveButton;
    protected JButton _cancelButton;
    protected JTextField _navigationTextField;
    protected JPanel _buttonPanel;
    protected JPanel _navigationPanel;
    private Action _approveSelectionAction = new BasicFolderChooserUI$ApproveSelectionAction(this);
    public BasicFolderChooserUI$FolderChooserSelectionListener _selectionListener;
    private FolderToolBarListener _folderToolbarListener;

    public BasicFolderChooserUI(FolderChooser folderChooser) {
        super(folderChooser);
        BasicFileSystemTreeNode.clearCache();
    }

    public static final ComponentUI createUI(JComponent jComponent) {
        return new BasicFolderChooserUI((FolderChooser)jComponent);
    }

    public final void installComponents(JFileChooser jFileChooser) {
        this._folderChooser = (FolderChooser)jFileChooser;
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        jPanel.add((Component)this.createToolbar(), "First");
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JPanel jPanel2 = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(7);
        jPanel2.setLayout(borderLayout);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 6, 6, 6));
        this._navigationPanel = this.createNavigationPanel();
        jPanel2.add((Component)this._navigationPanel, "North");
        jPanel2.add((Component)this.createFileSystemTreePanel(), "Center");
        this._buttonPanel = this.createButtonPanel();
        jPanel2.add((Component)this._buttonPanel, "South");
        JComponent jComponent = jFileChooser.getAccessory();
        if (jComponent != null) {
            jFileChooser.add((Component)jFileChooser.getAccessory(), "First");
        }
        jFileChooser.setLayout(new JideBoxLayout(jFileChooser, 1));
        jFileChooser.add((Component)jPanel, "fix");
        jFileChooser.add((Component)jPanel2, "vary");
        jFileChooser.setFileSelectionMode(1);
        if (this._folderChooser.isNavigationFieldVisible()) {
            this.setNavigationFieldVisible(true);
        } else {
            this.setNavigationFieldVisible(false);
        }
        this.updateView(jFileChooser);
        BasicFolderChooserUI$1 basicFolderChooserUI$1 = new BasicFolderChooserUI$1(this);
        SwingUtilities.invokeLater(basicFolderChooserUI$1);
        this._folderChooser.addHierarchyListener(new BasicFolderChooserUI$2(this));
    }

    public final Component getDefaultFocusComponent() {
        return this._fileSystemTree;
    }

    protected final JPanel createButtonPanel() {
        this._approveButton = new JButton();
        this._approveButton.setAction(this.getApproveSelectionAction());
        this._cancelButton = new JButton();
        this._cancelButton.addActionListener(this.getCancelSelectionAction());
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 0, 0));
        buttonPanel.addButton((AbstractButton)this._approveButton, "AFFIRMATIVE");
        buttonPanel.addButton((AbstractButton)this._cancelButton, "CANCEL");
        return buttonPanel;
    }

    protected final JPanel createNavigationPanel() {
        BasicFolderChooserUI$NavigationTextFieldListener basicFolderChooserUI$NavigationTextFieldListener = new BasicFolderChooserUI$NavigationTextFieldListener(this);
        this._navigationTextField = new JTextField(24);
        SelectAllUtils.install(this._navigationTextField);
        FileIntelliHints fileIntelliHints = new FileIntelliHints(this._navigationTextField);
        fileIntelliHints.setFolderOnly(true);
        fileIntelliHints.setShowFullPath(false);
        fileIntelliHints.setFollowCaret(true);
        this._navigationTextField.addActionListener(basicFolderChooserUI$NavigationTextFieldListener);
        JPanel jPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        jPanel.setLayout(borderLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        jPanel.add((Component)this._navigationTextField, "Center");
        return jPanel;
    }

    public final void setNavigationFieldVisible(boolean bl) {
        this._navigationPanel.setVisible(bl);
    }

    public final void rescanCurrentDirectory(JFileChooser jFileChooser) {
        super.rescanCurrentDirectory(jFileChooser);
    }

    public final void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        super.ensureFileIsVisible(jFileChooser, file);
        this.ensureFileIsVisible(file, true);
    }

    protected final JComponent createToolbar() {
        this._toolbar = new FolderToolBar(true, this._folderChooser.getRecentList());
        this._folderToolbarListener = new BasicFolderChooserUI$3(this);
        this._toolbar.addListener(this._folderToolbarListener);
        this.updateToolbarButtons();
        return this._toolbar;
    }

    protected final void updateToolbarButtons() {
        TreePath[] treePathArray;
        TreePath[] treePathArray2 = treePathArray = this._fileSystemTree == null ? new TreePath[]{} : this._fileSystemTree.getSelectionPaths();
        if (treePathArray != null && treePathArray.length > 0) {
            this._toolbar.enableDelete();
        } else {
            this._toolbar.disableDelete();
        }
        if (treePathArray != null && treePathArray.length == 1) {
            this._toolbar.enableNewFolder();
        } else {
            this._toolbar.disableNewFolder();
        }
    }

    private JComponent createFileSystemTreePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this._fileSystemTree = new BasicFileSystemTree(this._folderChooser);
        this.updateMultiSelectionEnabled();
        this._treeScrollPane = new JScrollPane(this._fileSystemTree);
        jPanel.add(this._treeScrollPane);
        return jPanel;
    }

    private void updateMultiSelectionEnabled() {
        if (this._folderChooser.isMultiSelectionEnabled()) {
            this._fileSystemTree.getSelectionModel().setSelectionMode(4);
        } else {
            this._fileSystemTree.getSelectionModel().setSelectionMode(1);
        }
    }

    public final void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.remove(this._treeScrollPane);
        jFileChooser.remove(this._buttonPanel);
    }

    protected final void installListeners(JFileChooser jFileChooser) {
        super.installListeners(jFileChooser);
        this._selectionListener = new BasicFolderChooserUI$FolderChooserSelectionListener(this, null);
        this._fileSystemTree.addTreeSelectionListener(this._selectionListener);
        this._fileSystemTree.registerKeyboardAction(new BasicFolderChooserUI$4(this), KeyStroke.getKeyStroke(116, 0), 0);
    }

    protected final void uninstallListeners(JFileChooser jFileChooser) {
        super.uninstallListeners(jFileChooser);
        this._fileSystemTree.removeTreeSelectionListener(this._selectionListener);
    }

    public final PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new BasicFolderChooserUI$FolderChooserPropertyChangeListener(this, null);
    }

    private void updateView(JFileChooser jFileChooser) {
        if (jFileChooser.getApproveButtonText() != null) {
            this._approveButton.setText(jFileChooser.getApproveButtonText());
            this._approveButton.setMnemonic(jFileChooser.getApproveButtonMnemonic());
        } else if (0 == jFileChooser.getDialogType()) {
            this._approveButton.setText(this.openButtonText);
            this._approveButton.setToolTipText(this.openButtonToolTipText);
            this._approveButton.setMnemonic(this.openButtonMnemonic);
        } else {
            this._approveButton.setText(this.saveButtonText);
            this._approveButton.setToolTipText(this.saveButtonToolTipText);
            this._approveButton.setMnemonic(this.saveButtonMnemonic);
        }
        this._cancelButton.setText(this.cancelButtonText);
        this._cancelButton.setMnemonic(this.cancelButtonMnemonic);
        this._buttonPanel.setVisible(jFileChooser.getControlButtonsAreShown());
        if (this._toolbar != null) {
            Component[] componentArray;
            for (Component component : componentArray = this._toolbar.getComponents()) {
                if (component instanceof JButton) {
                    String string = component.getName();
                    int n = this._folderChooser.getAvailableButtons();
                    boolean bl = this._toolbar.isButtonVisible(string, n);
                    component.setVisible(bl);
                    continue;
                }
                if (!(component instanceof JComboBox) && !(component instanceof JLabel)) continue;
                component.setVisible(this._folderChooser.isRecentListVisible());
            }
        }
    }

    public static final boolean isFileSystem(File file) {
        if (file instanceof ShellFolder) {
            ShellFolder shellFolder = (ShellFolder)file;
            return shellFolder.isFileSystem() && (!shellFolder.isLink() || !shellFolder.isDirectory());
        }
        return true;
    }

    private TreePath getTreePathForFile(File fileArray) {
        Object object;
        if (!fileArray.isDirectory()) {
            return null;
        }
        Stack<Object> stack = new Stack<Object>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this._fileSystemTree.getModel().getRoot());
        FileSystemView fileSystemView = this._folderChooser.getFileSystemView();
        File[] fileArray2 = null;
        File file = null;
        if (SystemInfo.isWindows() && BasicFolderChooserUI.isFileSystem(file = (object = fileSystemView.getRoots())[0]) && file.isDirectory()) {
            fileArray2 = file.listFiles();
        }
        object = fileArray;
        block0: do {
            stack.push(object);
            if (fileArray2 == null) continue;
            for (File file2 : fileArray2) {
                if (!file2.equals(object)) continue;
                stack.push(file);
                break block0;
            }
        } while ((object = this._folderChooser.getFileSystemView().getParentDirectory((File)object)) != null);
        while (!stack.empty()) {
            arrayList.add(BasicFileSystemTreeNode.createFileSystemTreeNode((File)stack.pop(), this._folderChooser));
        }
        return new TreePath(arrayList.toArray());
    }

    private void ensureFileIsVisible(File file, boolean bl) {
        TreePath treePath;
        TreePath treePath2 = treePath = file == null ? new TreePath(this._fileSystemTree.getModel().getRoot()) : this.getTreePathForFile(file);
        if (treePath != null) {
            this._fileSystemTree.setSelectionPath(treePath);
            this._fileSystemTree.expandPath(treePath);
            if (bl) {
                BasicFolderChooserUI$5 basicFolderChooserUI$5 = new BasicFolderChooserUI$5(this, treePath);
                SwingUtilities.invokeLater(basicFolderChooserUI$5);
            }
        }
    }

    private void setSelectedFiles() {
        TreePath[] treePathArray = this._fileSystemTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            this._folderChooser.setSelectedFile(null);
            return;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = treePathArray.length;
        for (int i2 = 0; i2 < n; ++i2) {
            File file = ((BasicFileSystemTreeNode)treePathArray[i2].getLastPathComponent()).getFile();
            arrayList.add(file);
        }
        this._folderChooser.setSelectedFiles(arrayList.toArray(new File[arrayList.size()]));
    }

    public final Action getApproveSelectionAction() {
        return this._approveSelectionAction;
    }

    static final /* synthetic */ FolderChooser access$000(BasicFolderChooserUI basicFolderChooserUI) {
        return basicFolderChooserUI._folderChooser;
    }

    static final /* synthetic */ void access$100(BasicFolderChooserUI basicFolderChooserUI, File file, boolean bl) {
        basicFolderChooserUI.ensureFileIsVisible(file, bl);
    }

    static final /* synthetic */ FolderToolBarListener access$400(BasicFolderChooserUI basicFolderChooserUI) {
        return basicFolderChooserUI._folderToolbarListener;
    }

    static final /* synthetic */ void access$600(BasicFolderChooserUI basicFolderChooserUI, JFileChooser jFileChooser) {
        basicFolderChooserUI.updateView(jFileChooser);
    }

    static final /* synthetic */ void access$700(BasicFolderChooserUI basicFolderChooserUI) {
        basicFolderChooserUI.updateMultiSelectionEnabled();
    }

    static final /* synthetic */ void access$800(BasicFolderChooserUI basicFolderChooserUI) {
        basicFolderChooserUI.setSelectedFiles();
    }
}

