/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.GripperUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicGripperUI$GripperMouseListener;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.Gripper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class BasicGripperUI
extends GripperUI {
    private int _size;
    protected ThemePainter _painter;
    protected Painter _gripperPainter;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicGripperUI();
    }

    public final void installUI(JComponent jComponent) {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._gripperPainter = (Painter)UIDefaultsLookup.get("Gripper.painter");
        this.installDefaults((Gripper)jComponent);
        this.installListeners((Gripper)jComponent);
    }

    public final void uninstallUI(JComponent jComponent) {
        this._painter = null;
        this._gripperPainter = null;
        this.uninstallDefaults((Gripper)jComponent);
        this.uninstallListeners((Gripper)jComponent);
    }

    protected void installDefaults(Gripper gripper) {
        this._size = UIDefaultsLookup.getInt("Gripper.size");
    }

    protected void uninstallDefaults(Gripper gripper) {
    }

    protected final MouseListener createMouseListener() {
        return new BasicGripperUI$GripperMouseListener(this);
    }

    protected final void installListeners(Gripper gripper) {
        MouseListener mouseListener = this.createMouseListener();
        if (mouseListener != null) {
            gripper.putClientProperty(this, mouseListener);
            gripper.addMouseListener(mouseListener);
        }
    }

    protected final void uninstallListeners(Gripper gripper) {
        MouseListener mouseListener = (MouseListener)gripper.getClientProperty(this);
        gripper.putClientProperty(this, null);
        if (mouseListener != null) {
            gripper.removeMouseListener(mouseListener);
        }
    }

    protected final void paintBackground(Graphics graphics, Gripper gripper) {
        Rectangle rectangle = new Rectangle(0, 0, gripper.getWidth(), gripper.getHeight());
        if (gripper.isRollover()) {
            this.getPainter().paintButtonBackground(gripper, graphics, rectangle, 0, 2);
        } else if (gripper.isOpaque()) {
            this.getPainter().paintButtonBackground(gripper, graphics, rectangle, 0, gripper.isSelected() ? 3 : 0, false);
            if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                JideSwingUtilities.fillGradient(graphics, rectangle, 0);
            }
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        Gripper gripper = (Gripper)jComponent;
        this.paintBackground(graphics, gripper);
        int n2 = n = gripper.isSelected() ? 3 : 0;
        if (this._gripperPainter == null) {
            this.getPainter().paintGripper(jComponent, graphics, new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight()), gripper.getOrientation(), n);
        } else {
            this._gripperPainter.paint(jComponent, graphics, new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight()), gripper.getOrientation(), n);
        }
    }

    public final Dimension getPreferredSize(JComponent jComponent) {
        return new Dimension(this._size, this._size);
    }

    public final Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public final Dimension getMaximumSize(JComponent jComponent) {
        Gripper gripper = (Gripper)jComponent;
        if (gripper.getOrientation() == 0) {
            return new Dimension(this._size, jComponent.getParent().getHeight());
        }
        return new Dimension(jComponent.getParent().getWidth(), this._size);
    }

    public final ThemePainter getPainter() {
        return this._painter;
    }
}

