/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.MeterProgressBarUI$PropertyChangeHandler;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.MeterProgressBar;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class MeterProgressBarUI
extends BasicProgressBarUI {
    protected Color _cellBackground;
    protected Color _cellForeground;
    protected int _cellLength;
    protected int _cellSpacing;
    private PropertyChangeListener _propertyChangeListener;

    public static final ComponentUI createUI(JComponent jComponent) {
        return new MeterProgressBarUI();
    }

    protected final void installDefaults() {
        super.installDefaults();
        LookAndFeel.installBorder(this.progressBar, "MeterProgressBar.border");
        LookAndFeel.installColors(this.progressBar, "MeterProgressBar.background", "MeterProgressBar.foreground");
        this._cellForeground = UIDefaultsLookup.getColor("MeterProgressBar.cellForeground");
        this._cellBackground = UIDefaultsLookup.getColor("MeterProgressBar.cellBackground");
        this._cellLength = UIDefaultsLookup.getInt("MeterProgressBar.cellLength");
        this._cellSpacing = UIDefaultsLookup.getInt("MeterProgressBar.cellSpacing");
    }

    protected final void uninstallDefaults() {
        super.uninstallDefaults();
        this._cellBackground = null;
        this._cellForeground = null;
    }

    protected final void installListeners() {
        super.installListeners();
        this._propertyChangeListener = new MeterProgressBarUI$PropertyChangeHandler(this, null);
        this.progressBar.addPropertyChangeListener(this._propertyChangeListener);
    }

    protected final void uninstallListeners() {
        this.progressBar.removePropertyChangeListener(this._propertyChangeListener);
        super.uninstallListeners();
    }

    public final void paint(Graphics graphics, JComponent jComponent) {
        Insets insets = this.progressBar.getInsets();
        int n = this.progressBar.getWidth() - (insets.right + insets.left);
        int n2 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        int n3 = this.getAmountFull(insets, n, n2);
        int n4 = this.progressBar.getOrientation();
        float f2 = n4 == 0 ? (float)n2 : (float)n;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(this._cellBackground);
        graphics2D.setStroke(new BasicStroke(f2, 0, 2));
        if (n4 == 0) {
            graphics2D.drawLine(insets.left, n2 / 2 + insets.top, insets.left + n, n2 / 2 + insets.top);
        } else {
            graphics2D.drawLine(n / 2 + insets.left, insets.top + n2, n / 2 + insets.left, insets.top);
        }
        if (((MeterProgressBar)jComponent).getStyle() == 0) {
            graphics2D.setColor(this._cellForeground);
            if (n4 == 0) {
                if (jComponent.getComponentOrientation().isLeftToRight()) {
                    graphics2D.drawLine(insets.left, n2 / 2 + insets.top, n3 + insets.left, n2 / 2 + insets.top);
                } else {
                    graphics2D.drawLine(n + insets.left, n2 / 2 + insets.top, n + insets.left - n3, n2 / 2 + insets.top);
                }
            } else {
                graphics2D.drawLine(n / 2 + insets.left, insets.top + n2, n / 2 + insets.left, insets.top + n2 - n3);
            }
        } else {
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 2));
            if (n4 == 0) {
                Rectangle rectangle = new Rectangle(insets.left, insets.top, n3, n2 / 2);
                if (!jComponent.getComponentOrientation().isLeftToRight()) {
                    rectangle.x += n - n3;
                }
                JideSwingUtilities.fillGradient(graphics2D, rectangle, this._cellForeground, this._cellBackground, true);
                rectangle.y += n2 / 2;
                JideSwingUtilities.fillGradient(graphics2D, rectangle, this._cellBackground, this._cellForeground, true);
            } else {
                Rectangle rectangle = new Rectangle(insets.left, insets.top + n2 - n3, n / 2, n3);
                JideSwingUtilities.fillGradient(graphics2D, rectangle, this._cellForeground, this._cellBackground, false);
                rectangle.x += n / 2;
                JideSwingUtilities.fillGradient(graphics2D, rectangle, this._cellBackground, this._cellForeground, false);
            }
        }
        graphics2D.setColor(this.progressBar.getBackground());
        graphics2D.setStroke(new BasicStroke(f2, 0, 2, 0.0f, new float[]{this._cellLength, this._cellSpacing}, 0.0f));
        if (n4 == 0) {
            graphics2D.drawLine(insets.left - this._cellSpacing, n2 / 2 + insets.top, insets.left + n, n2 / 2 + insets.top);
        } else {
            graphics2D.drawLine(n / 2 + insets.left, insets.top + n2 + this._cellSpacing, n / 2 + insets.left, insets.top);
        }
        graphics2D.dispose();
    }

    static final /* synthetic */ JProgressBar access$100(MeterProgressBarUI meterProgressBarUI) {
        return meterProgressBarUI.progressBar;
    }
}

