/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.swing.CheckBoxListSelectionModel;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CheckBoxList$Handler
implements MouseListener,
KeyListener,
ListSelectionListener,
PropertyChangeListener,
ListDataListener {
    protected CheckBoxList _list;
    int hotspot;

    public CheckBoxList$Handler(CheckBoxList checkBoxList) {
        this.hotspot = new JCheckBox().getPreferredSize().width;
        this._list = checkBoxList;
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getOldValue() instanceof ListModel) {
            ((ListModel)propertyChangeEvent.getOldValue()).removeListDataListener(this);
        }
        if (propertyChangeEvent.getNewValue() instanceof ListModel) {
            this._list.getCheckBoxListSelectionModel().setModel((ListModel)propertyChangeEvent.getNewValue());
            ((ListModel)propertyChangeEvent.getNewValue()).addListDataListener(this);
        }
    }

    protected final boolean clicksInCheckBox(MouseEvent mouseEvent) {
        int n = this._list.locationToIndex(mouseEvent.getPoint());
        Rectangle rectangle = this._list.getCellBounds(n, n);
        if (rectangle != null) {
            if (this._list.getComponentOrientation().isLeftToRight()) {
                return mouseEvent.getX() < rectangle.x + this.hotspot;
            }
            return mouseEvent.getX() > rectangle.x + rectangle.width - this.hotspot;
        }
        return false;
    }

    public final void mouseClicked(MouseEvent mouseEvent) {
    }

    public final void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (!this._list.isCheckBoxEnabled()) {
            return;
        }
        boolean bl = this.clicksInCheckBox(mouseEvent);
        if (!this._list.isClickInCheckBoxOnly() || bl) {
            int n = this._list.locationToIndex(mouseEvent.getPoint());
            this.toggleSelection(n);
            if (bl) {
                mouseEvent.consume();
            }
        }
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (!this._list.isCheckBoxEnabled()) {
            return;
        }
        if (this.clicksInCheckBox(mouseEvent)) {
            mouseEvent.consume();
        }
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
    }

    public final void mouseExited(MouseEvent mouseEvent) {
    }

    public final void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (!this._list.isCheckBoxEnabled()) {
            return;
        }
        if (keyEvent.getModifiers() == 0 && keyEvent.getKeyChar() == ' ') {
            this.toggleSelections();
        }
    }

    public final void keyTyped(KeyEvent keyEvent) {
    }

    public final void keyReleased(KeyEvent keyEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void toggleSelections() {
        int[] nArray = this._list.getSelectedIndices();
        CheckBoxListSelectionModel checkBoxListSelectionModel = this._list.getCheckBoxListSelectionModel();
        checkBoxListSelectionModel.removeListSelectionListener(this);
        checkBoxListSelectionModel.setValueIsAdjusting(true);
        try {
            if (nArray.length > 0) {
                boolean bl = checkBoxListSelectionModel.isSelectedIndex(nArray[0]);
                for (int n : nArray) {
                    if (!this._list.isCheckBoxEnabled(n)) continue;
                    if (bl && checkBoxListSelectionModel.isSelectedIndex(n)) {
                        checkBoxListSelectionModel.removeSelectionInterval(n, n);
                        continue;
                    }
                    if (bl || checkBoxListSelectionModel.isSelectedIndex(n)) continue;
                    checkBoxListSelectionModel.addSelectionInterval(n, n);
                }
            }
        }
        finally {
            checkBoxListSelectionModel.setValueIsAdjusting(false);
            checkBoxListSelectionModel.addListSelectionListener(this);
            this._list.repaint();
        }
    }

    public final void valueChanged(ListSelectionEvent listSelectionEvent) {
        this._list.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void toggleSelection(int n) {
        if (!this._list.isEnabled() || !this._list.isCheckBoxEnabled(n)) {
            return;
        }
        CheckBoxListSelectionModel checkBoxListSelectionModel = this._list.getCheckBoxListSelectionModel();
        boolean bl = checkBoxListSelectionModel.isSelectedIndex(n);
        checkBoxListSelectionModel.removeListSelectionListener(this);
        try {
            if (bl) {
                checkBoxListSelectionModel.removeSelectionInterval(n, n);
            } else {
                checkBoxListSelectionModel.addSelectionInterval(n, n);
            }
        }
        finally {
            checkBoxListSelectionModel.addListSelectionListener(this);
            this._list.repaint();
        }
    }

    protected final void toggleSelection() {
        int n = this._list.getSelectedIndex();
        this.toggleSelection(n);
    }

    public final void intervalAdded(ListDataEvent listDataEvent) {
        int n = Math.min(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        int n2 = Math.max(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        CheckBoxListSelectionModel checkBoxListSelectionModel = this._list.getCheckBoxListSelectionModel();
        if (checkBoxListSelectionModel != null) {
            checkBoxListSelectionModel.insertIndexInterval(n, n2 - n + 1, true);
        }
    }

    public final void intervalRemoved(ListDataEvent listDataEvent) {
        CheckBoxListSelectionModel checkBoxListSelectionModel = this._list.getCheckBoxListSelectionModel();
        if (checkBoxListSelectionModel != null) {
            checkBoxListSelectionModel.removeIndexInterval(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }
    }

    public final void contentsChanged(ListDataEvent listDataEvent) {
    }
}

