/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxList$AllEntry;
import com.jidesoft.swing.CheckBoxList$Handler;
import com.jidesoft.swing.CheckBoxListCellRenderer;
import com.jidesoft.swing.CheckBoxListSelectionModel;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.text.Position;

public class CheckBoxList
extends JList {
    protected CheckBoxListCellRenderer _listCellRenderer;
    public static final String PROPERTY_CHECKBOX_ENABLED = "checkBoxEnabled";
    public static final String PROPERTY_CLICK_IN_CHECKBOX_ONLY = "clickInCheckBoxOnly";
    private boolean _checkBoxEnabled = true;
    private boolean _clickInCheckBoxOnly = true;
    private CheckBoxListSelectionModel _checkBoxListSelectionModel;
    protected CheckBoxList$Handler _handler;
    public static final String ALL = "(All)";
    public static final Object ALL_ENTRY = new CheckBoxList$AllEntry();

    public CheckBoxList() {
        this.init();
    }

    public CheckBoxList(Vector vector) {
        super(vector);
        this.init();
    }

    public CheckBoxList(Object[] objectArray) {
        super(objectArray);
        this.init();
    }

    public CheckBoxList(ListModel listModel) {
        super(listModel);
        this.init();
    }

    public final void setModel(ListModel listModel) {
        super.setModel(listModel);
        if (this.getCheckBoxListSelectionModel() != null) {
            this.getCheckBoxListSelectionModel().clearSelection();
        }
    }

    public final void updateUI() {
        super.updateUI();
    }

    protected final void init() {
        this._checkBoxListSelectionModel = this.createCheckBoxListSelectionModel(this.getModel());
        this.setSelectionMode(2);
        this._listCellRenderer = this.createCellRenderer();
        this._handler = this.createHandler();
        this._checkBoxListSelectionModel.addListSelectionListener(this._handler);
        JideSwingUtilities.insertMouseListener(this, this._handler, 0);
        this.addKeyListener(this._handler);
        this.addPropertyChangeListener("model", this._handler);
        ListModel listModel = this.getModel();
        if (listModel != null) {
            listModel.addListDataListener(this._handler);
        }
    }

    public final int getLastVisibleIndex() {
        int n = super.getLastVisibleIndex();
        if (n < 0) {
            return this.getModel().getSize() - 1;
        }
        return n;
    }

    protected final CheckBoxListSelectionModel createCheckBoxListSelectionModel(ListModel listModel) {
        return new CheckBoxListSelectionModel(listModel);
    }

    protected final CheckBoxListCellRenderer createCellRenderer() {
        return new CheckBoxListCellRenderer();
    }

    protected final CheckBoxList$Handler createHandler() {
        return new CheckBoxList$Handler(this);
    }

    public final ListCellRenderer getCellRenderer() {
        if (this._listCellRenderer != null) {
            this._listCellRenderer.setActualListRenderer(this.getActualCellRenderer());
            return this._listCellRenderer;
        }
        return super.getCellRenderer();
    }

    public final ListCellRenderer getActualCellRenderer() {
        return super.getCellRenderer();
    }

    public int getNextMatch(String string, int n, Position.Bias bias) {
        return -1;
    }

    public boolean isCheckBoxEnabled(int n) {
        return true;
    }

    public final boolean isCheckBoxVisible(int n) {
        return true;
    }

    public final boolean isCheckBoxEnabled() {
        return this._checkBoxEnabled;
    }

    public final void setCheckBoxEnabled(boolean bl) {
        if (bl != this._checkBoxEnabled) {
            boolean bl2 = this._checkBoxEnabled;
            this._checkBoxEnabled = bl;
            this.firePropertyChange(PROPERTY_CHECKBOX_ENABLED, bl2, this._checkBoxEnabled);
            this.repaint();
        }
    }

    public final boolean isClickInCheckBoxOnly() {
        return this._clickInCheckBoxOnly;
    }

    public final void setClickInCheckBoxOnly(boolean bl) {
        if (bl != this._clickInCheckBoxOnly) {
            boolean bl2 = this._clickInCheckBoxOnly;
            this._clickInCheckBoxOnly = bl;
            this.firePropertyChange(PROPERTY_CLICK_IN_CHECKBOX_ONLY, bl2, this._clickInCheckBoxOnly);
        }
    }

    public final CheckBoxListSelectionModel getCheckBoxListSelectionModel() {
        return this._checkBoxListSelectionModel;
    }

    public final void setCheckBoxListSelectionModel(CheckBoxListSelectionModel checkBoxListSelectionModel) {
        if (this._checkBoxListSelectionModel != checkBoxListSelectionModel) {
            if (this._checkBoxListSelectionModel != null) {
                this.getModel().removeListDataListener(this._checkBoxListSelectionModel);
            }
            this._checkBoxListSelectionModel = checkBoxListSelectionModel;
            if (this._checkBoxListSelectionModel != null) {
                this._checkBoxListSelectionModel.setModel(this.getModel());
            }
        }
    }

    public final int[] getCheckBoxListSelectedIndices() {
        CheckBoxListSelectionModel checkBoxListSelectionModel = this.getCheckBoxListSelectionModel();
        int n = checkBoxListSelectionModel.getMinSelectionIndex();
        int n2 = checkBoxListSelectionModel.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return new int[0];
        }
        int[] nArray = new int[1 + (n2 - n)];
        int n3 = 0;
        for (int i2 = n; i2 <= n2; ++i2) {
            if (checkBoxListSelectionModel.isAllEntryConsidered() && i2 == checkBoxListSelectionModel.getAllEntryIndex() || !checkBoxListSelectionModel.isSelectedIndex(i2)) continue;
            nArray[n3] = i2;
            ++n3;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    public final void setCheckBoxListSelectedIndex(int n) {
        if (n >= 0 && n < this.getModel().getSize()) {
            this.getCheckBoxListSelectionModel().setSelectionInterval(n, n);
        }
    }

    public final void addCheckBoxListSelectedIndex(int n) {
        if (n >= 0 && n < this.getModel().getSize()) {
            this.getCheckBoxListSelectionModel().addSelectionInterval(n, n);
        }
    }

    public final void removeCheckBoxListSelectedIndex(int n) {
        if (n >= 0 && n < this.getModel().getSize()) {
            this.getCheckBoxListSelectionModel().removeSelectionInterval(n, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCheckBoxListSelectedIndices(int[] nArray) {
        CheckBoxListSelectionModel checkBoxListSelectionModel = this.getCheckBoxListSelectionModel();
        try {
            checkBoxListSelectionModel.setValueIsAdjusting(true);
            checkBoxListSelectionModel.clearSelection();
            int n = this.getModel().getSize();
            for (int n2 : nArray) {
                if (n2 < 0 || n2 >= n) continue;
                checkBoxListSelectionModel.addSelectionInterval(n2, n2);
            }
        }
        finally {
            checkBoxListSelectionModel.setValueIsAdjusting(false);
        }
    }

    public final void setSelectedObjects(Object[] objectArray) {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        for (Object object : objectArray) {
            hashMap.put(object, "");
        }
        this.setSelectedObjects(hashMap);
    }

    public final void setSelectedObjects(Vector vector) {
        HashMap hashMap = new HashMap();
        for (Object e2 : vector) {
            hashMap.put(e2, "");
        }
        this.setSelectedObjects(hashMap);
    }

    private void setSelectedObjects(Map map) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.getModel().getSize(); ++i2) {
            Object e2 = this.getModel().getElementAt(i2);
            if (map.get(e2) == null) continue;
            arrayList.add(i2);
        }
        int[] nArray = new int[arrayList.size()];
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            Integer n = (Integer)arrayList.get(i3);
            nArray[i3] = n;
        }
        this.setCheckBoxListSelectedIndices(nArray);
    }

    public final Object[] getCheckBoxListSelectedValues() {
        CheckBoxListSelectionModel checkBoxListSelectionModel = this.getCheckBoxListSelectionModel();
        ListModel listModel = this.getModel();
        int n = checkBoxListSelectionModel.getMinSelectionIndex();
        int n2 = checkBoxListSelectionModel.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return new Object[0];
        }
        Object[] objectArray = new Object[1 + (n2 - n)];
        int n3 = 0;
        for (int i2 = n; i2 <= n2; ++i2) {
            if (checkBoxListSelectionModel.isAllEntryConsidered() && i2 == checkBoxListSelectionModel.getAllEntryIndex() || !checkBoxListSelectionModel.isSelectedIndex(i2)) continue;
            objectArray[n3] = listModel.getElementAt(i2);
            ++n3;
        }
        Object[] objectArray2 = new Object[n3];
        System.arraycopy(objectArray, 0, objectArray2, 0, n3);
        return objectArray2;
    }

    public final int getCheckBoxListSelectedIndex() {
        return this.getCheckBoxListSelectionModel().getMinSelectionIndex();
    }

    public final Object getCheckBoxListSelectedValue() {
        int n = this.getCheckBoxListSelectionModel().getMinSelectionIndex();
        return n == -1 ? null : this.getModel().getElementAt(n);
    }

    public final void setCheckBoxListSelectedValue(Object object, boolean bl) {
        if (object == null) {
            this.setSelectedIndex(-1);
        } else {
            ListModel listModel = this.getModel();
            int n = listModel.getSize();
            for (int i2 = 0; i2 < n; ++i2) {
                if (!object.equals(listModel.getElementAt(i2))) continue;
                this.setCheckBoxListSelectedIndex(i2);
                if (bl) {
                    this.ensureIndexIsVisible(i2);
                }
                this.repaint();
                return;
            }
            this.setCheckBoxListSelectedIndex(-1);
        }
        this.repaint();
    }

    public final void addCheckBoxListSelectedValue(Object object, boolean bl) {
        ListModel listModel = this.getModel();
        if (object != null) {
            int n = listModel.getSize();
            for (int i2 = 0; i2 < n; ++i2) {
                if (!object.equals(listModel.getElementAt(i2))) continue;
                this.addCheckBoxListSelectedIndex(i2);
                if (bl) {
                    this.ensureIndexIsVisible(i2);
                }
                this.repaint();
                return;
            }
        } else {
            int n = listModel.getSize();
            for (int i3 = 0; i3 < n; ++i3) {
                if (listModel.getElementAt(i3) != null) continue;
                this.addCheckBoxListSelectedIndex(i3);
                if (bl) {
                    this.ensureIndexIsVisible(i3);
                }
                this.repaint();
                return;
            }
        }
    }

    public final void addCheckBoxListSelectedValues(Object[] objectArray) {
        if (objectArray != null) {
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            for (Object object : objectArray) {
                hashMap.put(object, "");
            }
            ListModel listModel = this.getModel();
            boolean bl = false;
            int n = listModel.getSize();
            for (int i2 = 0; i2 < n; ++i2) {
                if (hashMap.get(listModel.getElementAt(i2)) == null) continue;
                this.addCheckBoxListSelectedIndex(i2);
                bl = true;
            }
            if (bl) {
                this.repaint();
            }
            hashMap.clear();
        }
    }

    public final void removeCheckBoxListSelectedValues(Object[] objectArray) {
        if (objectArray != null) {
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            for (Object object : objectArray) {
                hashMap.put(object, "");
            }
            ListModel listModel = this.getModel();
            boolean bl = false;
            int n = listModel.getSize();
            for (int i2 = 0; i2 < n; ++i2) {
                if (hashMap.get(listModel.getElementAt(i2)) == null) continue;
                this.removeCheckBoxListSelectedIndex(i2);
                bl = true;
            }
            if (bl) {
                this.repaint();
            }
            hashMap.clear();
        }
    }

    public final void removeCheckBoxListSelectedValue(Object object, boolean bl) {
        if (object != null) {
            ListModel listModel = this.getModel();
            int n = listModel.getSize();
            for (int i2 = 0; i2 < n; ++i2) {
                if (!object.equals(listModel.getElementAt(i2))) continue;
                this.removeCheckBoxListSelectedIndex(i2);
                if (bl) {
                    this.ensureIndexIsVisible(i2);
                }
                this.repaint();
                return;
            }
        }
    }

    public final void clearCheckBoxListSelection() {
        this.getCheckBoxListSelectionModel().clearSelection();
    }

    public final void selectAll() {
        if (this.getModel().getSize() > 0) {
            this.getCheckBoxListSelectionModel().setSelectionInterval(0, this.getModel().getSize() - 1);
        }
    }

    public final void selectNone() {
        if (this.getModel().getSize() > 0) {
            this.getCheckBoxListSelectionModel().removeIndexInterval(0, this.getModel().getSize() - 1);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = super.getPreferredScrollableViewportSize();
        return dimension != null && dimension.width > 0 && dimension.height > 0 ? JideSwingUtilities.adjustPreferredScrollableViewportSize(this, dimension) : dimension;
    }
}

