/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxListWithSelectable;
import com.jidesoft.swing.Selectable;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.ListModel;

public class CheckBoxListWithSelectable$Handler
implements MouseListener,
KeyListener {
    protected CheckBoxListWithSelectable _list;
    int _hotspot;

    public CheckBoxListWithSelectable$Handler(CheckBoxListWithSelectable checkBoxListWithSelectable) {
        this._hotspot = new JCheckBox().getPreferredSize().width;
        this._list = checkBoxListWithSelectable;
    }

    protected final boolean clicksInCheckBox(MouseEvent mouseEvent) {
        int n = this._list.locationToIndex(mouseEvent.getPoint());
        Rectangle rectangle = this._list.getCellBounds(n, n);
        if (rectangle != null) {
            if (this._list.getComponentOrientation().isLeftToRight()) {
                return mouseEvent.getX() < rectangle.x + this._hotspot;
            }
            return mouseEvent.getX() > rectangle.x + rectangle.width - this._hotspot;
        }
        return false;
    }

    public final void mouseClicked(MouseEvent mouseEvent) {
    }

    public final void mousePressed(MouseEvent mouseEvent) {
        if (!this._list.isCheckBoxEnabled() || !this._list.isEnabled()) {
            return;
        }
        if (!this._list.isClickInCheckBoxOnly() || this.clicksInCheckBox(mouseEvent)) {
            int n = this._list.locationToIndex(mouseEvent.getPoint());
            this.toggleSelection(n);
        }
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
    }

    public final void mouseExited(MouseEvent mouseEvent) {
    }

    public final void keyPressed(KeyEvent keyEvent) {
        if (!this._list.isCheckBoxEnabled() || !this._list.isEnabled()) {
            return;
        }
        if (keyEvent.getModifiers() == 0 && keyEvent.getKeyChar() == ' ') {
            this.toggleSelections();
        }
    }

    public final void keyTyped(KeyEvent keyEvent) {
    }

    public final void keyReleased(KeyEvent keyEvent) {
    }

    protected final void toggleSelections() {
        int[] nArray = this._list.getSelectedIndices();
        ListModel listModel = this._list.getModel();
        for (int n : nArray) {
            Object e2 = listModel.getElementAt(n);
            if (!(e2 instanceof Selectable) || !((Selectable)e2).isEnabled()) continue;
            ((Selectable)e2).invertSelected();
            boolean bl = ((Selectable)e2).isSelected();
            this._list.fireItemStateChanged(new ItemEvent(this._list, 701, e2, bl ? 1 : 2));
        }
        this._list.repaint();
    }

    protected final void toggleSelection(int n) {
        ListModel listModel = this._list.getModel();
        if (n >= 0) {
            Object e2 = listModel.getElementAt(n);
            if (e2 instanceof Selectable && ((Selectable)e2).isEnabled()) {
                ((Selectable)e2).invertSelected();
                boolean bl = ((Selectable)e2).isSelected();
                this._list.fireItemStateChanged(new ItemEvent(this._list, 701, e2, bl ? 1 : 2));
            }
            this._list.repaint();
        }
    }

    protected final void toggleSelection() {
        int n = this._list.getSelectedIndex();
        this.toggleSelection(n);
    }
}

