/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxListCellRenderer;
import com.jidesoft.swing.CheckBoxListWithSelectable$Handler;
import com.jidesoft.swing.DefaultSelectable;
import com.jidesoft.swing.Selectable;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.text.Position;

public class CheckBoxListWithSelectable
extends JList
implements ItemSelectable {
    protected CheckBoxListCellRenderer _listCellRenderer;
    public static final String PROPERTY_CHECKBOX_ENABLED = "checkBoxEnabled";
    public static final String PROPERTY_CLICK_IN_CHECKBOX_ONLY = "clickInCheckBoxOnly";
    private boolean _checkBoxEnabled = true;
    private boolean _clickInCheckBoxOnly = true;

    public CheckBoxListWithSelectable() {
        this.init();
    }

    public CheckBoxListWithSelectable(Vector vector) {
        super(CheckBoxListWithSelectable.wrap(vector));
        this.init();
    }

    public CheckBoxListWithSelectable(Object[] objectArray) {
        super(CheckBoxListWithSelectable.wrap(objectArray));
        this.init();
    }

    public CheckBoxListWithSelectable(ListModel listModel) {
        super(CheckBoxListWithSelectable.wrap(listModel));
        this.init();
    }

    protected final void init() {
        this.setSelectionMode(2);
        this._listCellRenderer = this.createCellRenderer();
        CheckBoxListWithSelectable$Handler checkBoxListWithSelectable$Handler = this.createHandler();
        this.addMouseListener(checkBoxListWithSelectable$Handler);
        this.addKeyListener(checkBoxListWithSelectable$Handler);
    }

    protected final CheckBoxListCellRenderer createCellRenderer() {
        return new CheckBoxListCellRenderer();
    }

    protected final CheckBoxListWithSelectable$Handler createHandler() {
        return new CheckBoxListWithSelectable$Handler(this);
    }

    public final void setSelectedObjects(Object[] objectArray) {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        for (Object object : objectArray) {
            hashMap.put(object, "");
        }
        this.setSelectedObjects(hashMap);
    }

    public final void setSelectedObjects(Vector vector) {
        HashMap hashMap = new HashMap();
        for (Object e2 : vector) {
            hashMap.put(e2, "");
        }
        this.setSelectedObjects(hashMap);
    }

    public final ListCellRenderer getCellRenderer() {
        if (this._listCellRenderer != null) {
            this._listCellRenderer.setActualListRenderer(super.getCellRenderer());
            return this._listCellRenderer;
        }
        return super.getCellRenderer();
    }

    public final ListCellRenderer getActualCellRenderer() {
        if (this._listCellRenderer != null) {
            return this._listCellRenderer.getActualListRenderer();
        }
        return super.getCellRenderer();
    }

    private void setSelectedObjects(Map map) {
        for (int i2 = 0; i2 < this.getModel().getSize(); ++i2) {
            Object object = this.getModel().getElementAt(i2);
            if (!(object instanceof Selectable)) continue;
            Selectable selectable = (Selectable)object;
            if (selectable instanceof DefaultSelectable) {
                object = ((DefaultSelectable)selectable).getObject();
            }
            if (map.get(object) != null) {
                selectable.setSelected(true);
                this.fireItemStateChanged(new ItemEvent(this, 701, selectable, 1));
                map.remove(object);
                if (map.size() != 0) continue;
                break;
            }
            if (!selectable.isSelected()) continue;
            selectable.setSelected(false);
            this.fireItemStateChanged(new ItemEvent(this, 701, selectable, 2));
        }
        this.repaint();
    }

    private static ListModel wrap(ListModel listModel) {
        for (int i2 = 0; i2 < listModel.getSize(); ++i2) {
            if (listModel.getElementAt(i2) instanceof Selectable) continue;
            throw new IllegalArgumentException("The ListModel contains an element which is not an instance of Selectable at index " + i2 + ".");
        }
        return listModel;
    }

    private static Selectable[] wrap(Object[] objectArray) {
        if (objectArray instanceof Selectable[]) {
            return (Selectable[])objectArray;
        }
        Selectable[] selectableArray = new Selectable[objectArray.length];
        for (int i2 = 0; i2 < selectableArray.length; ++i2) {
            selectableArray[i2] = new DefaultSelectable(objectArray[i2]);
        }
        return selectableArray;
    }

    private static Vector wrap(Vector vector) {
        Vector<Selectable> vector2 = new Vector<Selectable>();
        for (Object e2 : vector) {
            if (e2 instanceof Selectable) {
                vector2.add((Selectable)e2);
                continue;
            }
            vector2.add(new DefaultSelectable(e2));
        }
        return vector2;
    }

    public final boolean isClickInCheckBoxOnly() {
        return this._clickInCheckBoxOnly;
    }

    public final void setClickInCheckBoxOnly(boolean bl) {
        if (bl != this._clickInCheckBoxOnly) {
            boolean bl2 = this._clickInCheckBoxOnly;
            this._clickInCheckBoxOnly = bl;
            this.firePropertyChange(PROPERTY_CLICK_IN_CHECKBOX_ONLY, bl2, this._clickInCheckBoxOnly);
        }
    }

    public final void addItemListener(ItemListener itemListener) {
        this.listenerList.add(ItemListener.class, itemListener);
    }

    public final void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(ItemListener.class, itemListener);
    }

    public final ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(ItemListener.class);
    }

    protected final void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        ItemEvent itemEvent2 = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != ItemListener.class) continue;
            if (itemEvent2 == null) {
                itemEvent2 = new ItemEvent(this, 701, itemEvent.getItem(), itemEvent.getStateChange());
            }
            ((ItemListener)objectArray[i2 + 1]).itemStateChanged(itemEvent2);
        }
    }

    public final Object[] getSelectedObjects() {
        Vector<Object> vector = new Vector<Object>();
        for (int i2 = 0; i2 < this.getModel().getSize(); ++i2) {
            Selectable selectable;
            Object e2 = this.getModel().getElementAt(i2);
            if (!(e2 instanceof Selectable) || !(selectable = (Selectable)e2).isSelected()) continue;
            if (selectable instanceof DefaultSelectable) {
                vector.add(((DefaultSelectable)selectable).getObject());
                continue;
            }
            vector.add(selectable);
        }
        return vector.toArray();
    }

    public final void selectAll() {
        for (int i2 = 0; i2 < this.getModel().getSize(); ++i2) {
            Selectable selectable;
            Object e2 = this.getModel().getElementAt(i2);
            if (!(e2 instanceof Selectable) || !(selectable = (Selectable)e2).isEnabled() || selectable.isSelected()) continue;
            selectable.setSelected(true);
            this.fireItemStateChanged(new ItemEvent(this, 701, selectable, 1));
        }
        this.repaint();
    }

    public final void selectNone() {
        for (int i2 = 0; i2 < this.getModel().getSize(); ++i2) {
            Selectable selectable;
            Object e2 = this.getModel().getElementAt(i2);
            if (!(e2 instanceof Selectable) || !(selectable = (Selectable)e2).isEnabled() || !selectable.isSelected()) continue;
            selectable.setSelected(false);
            this.fireItemStateChanged(new ItemEvent(this, 701, selectable, 2));
        }
        this.repaint();
    }

    public final void setListData(Vector vector) {
        super.setListData(CheckBoxListWithSelectable.wrap(vector));
    }

    public final void setListData(Object[] objectArray) {
        super.setListData(CheckBoxListWithSelectable.wrap(objectArray));
    }

    public final int getNextMatch(String string, int n, Position.Bias bias) {
        return -1;
    }

    public final boolean isCheckBoxEnabled() {
        return this._checkBoxEnabled;
    }

    public final boolean isCheckBoxVisible(int n) {
        return true;
    }

    public final void setCheckBoxEnabled(boolean bl) {
        if (bl != this._checkBoxEnabled) {
            Boolean bl2 = this._checkBoxEnabled ? Boolean.TRUE : Boolean.FALSE;
            Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
            this._checkBoxEnabled = bl;
            this.firePropertyChange(PROPERTY_CHECKBOX_ENABLED, bl2, bl3);
            this.repaint();
        }
    }
}

