/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxTree;
import com.jidesoft.swing.CheckBoxTreeSelectionModel;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class CheckBoxTree$Handler
implements MouseListener,
KeyListener,
TreeSelectionListener {
    protected CheckBoxTree _tree;
    int _hotspot;
    private int _toggleCount;

    public CheckBoxTree$Handler(CheckBoxTree checkBoxTree) {
        this._hotspot = new JCheckBox().getPreferredSize().width;
        this._toggleCount = -1;
        this._tree = checkBoxTree;
    }

    protected final TreePath getTreePathForMouseEvent(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return null;
        }
        if (!this._tree.isCheckBoxEnabled()) {
            return null;
        }
        TreePath treePath = this._tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return null;
        }
        if (this.clicksInCheckBox(mouseEvent, treePath) || !this._tree.isClickInCheckBoxOnly()) {
            return treePath;
        }
        return null;
    }

    protected final boolean clicksInCheckBox(MouseEvent mouseEvent, TreePath treePath) {
        if (!this._tree.isCheckBoxVisible(treePath)) {
            return false;
        }
        Rectangle rectangle = this._tree.getPathBounds(treePath);
        if (this._tree.getComponentOrientation().isLeftToRight()) {
            return mouseEvent.getX() < rectangle.x + this._hotspot;
        }
        return mouseEvent.getX() > rectangle.x + rectangle.width - this._hotspot;
    }

    private TreePath preventToggleEvent(MouseEvent mouseEvent) {
        int n;
        TreePath treePath = this.getTreePathForMouseEvent(mouseEvent);
        if (treePath != null && (n = this._tree.getToggleClickCount()) != -1) {
            this._toggleCount = n;
            this._tree.setToggleClickCount(-1);
        }
        return treePath;
    }

    public final void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        this.preventToggleEvent(mouseEvent);
    }

    public final void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        TreePath treePath = this.preventToggleEvent(mouseEvent);
        if (treePath != null) {
            this.toggleSelections(new TreePath[]{treePath});
            mouseEvent.consume();
        }
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        TreePath treePath = this.preventToggleEvent(mouseEvent);
        if (treePath != null) {
            mouseEvent.consume();
        }
        if (this._toggleCount != -1) {
            this._tree.setToggleClickCount(this._toggleCount);
        }
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
    }

    public final void mouseExited(MouseEvent mouseEvent) {
    }

    public final void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (!this._tree.isCheckBoxEnabled()) {
            return;
        }
        if (keyEvent.getModifiers() == 0 && keyEvent.getKeyChar() == ' ') {
            this.toggleSelections();
        }
    }

    public final void keyTyped(KeyEvent keyEvent) {
    }

    public final void keyReleased(KeyEvent keyEvent) {
    }

    public final void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this._tree.treeDidChange();
    }

    protected final void toggleSelections() {
        TreePath[] treePathArray = this._tree.getSelectionPaths();
        this.toggleSelections(treePathArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toggleSelections(TreePath[] treePathArray) {
        if (treePathArray == null || treePathArray.length == 0 || !this._tree.isEnabled()) {
            return;
        }
        if (treePathArray.length == 1 && !this._tree.isCheckBoxEnabled(treePathArray[0])) {
            return;
        }
        CheckBoxTreeSelectionModel checkBoxTreeSelectionModel = this._tree.getCheckBoxTreeSelectionModel();
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        ArrayList<TreePath> arrayList2 = new ArrayList<TreePath>();
        for (TreePath treePath : treePathArray) {
            boolean bl = checkBoxTreeSelectionModel.isPathSelected(treePath, checkBoxTreeSelectionModel.isDigIn());
            if (bl) {
                arrayList2.add(treePath);
                continue;
            }
            if (!this._tree.isSelectPartialOnToggling() && checkBoxTreeSelectionModel.isPartiallySelected(treePath)) {
                TreePath[] treePathArray2 = checkBoxTreeSelectionModel.getSelectionPaths();
                if (treePathArray2 == null) continue;
                for (TreePath treePath2 : treePathArray2) {
                    if (!checkBoxTreeSelectionModel.isDescendant(treePath2, treePath)) continue;
                    arrayList2.add(treePath2);
                }
                continue;
            }
            arrayList.add(treePath);
        }
        checkBoxTreeSelectionModel.removeTreeSelectionListener(this);
        try {
            if (arrayList.size() > 0) {
                checkBoxTreeSelectionModel.addSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
            }
            if (arrayList2.size() > 0) {
                checkBoxTreeSelectionModel.removeSelectionPaths(arrayList2.toArray(new TreePath[arrayList2.size()]));
            }
        }
        finally {
            checkBoxTreeSelectionModel.addTreeSelectionListener(this);
            this._tree.treeDidChange();
        }
    }
}

