/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.ComboBoxSearchable$1;
import com.jidesoft.swing.ComboBoxSearchable$2;
import com.jidesoft.swing.ComboBoxSearchable$3;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ComboBoxSearchable
extends Searchable
implements ListDataListener,
PropertyChangeListener,
PopupMenuListener {
    private boolean _refreshPopupDuringSearching = false;
    private boolean _showPopupDuringSearching = true;

    public ComboBoxSearchable(JComboBox jComboBox) {
        super(jComboBox);
        jComboBox.setKeySelectionManager(new ComboBoxSearchable$1(this));
        jComboBox.getModel().addListDataListener(this);
        jComboBox.addPropertyChangeListener("model", this);
        jComboBox.addPopupMenuListener(this);
        if (jComboBox.isEditable()) {
            Component component = jComboBox.getEditor().getEditorComponent();
            JTextField jTextField = (JTextField)component;
            jTextField.addKeyListener(new ComboBoxSearchable$2(this, jTextField, jComboBox));
            this.setSearchableProvider(new ComboBoxSearchable$3(this, jTextField));
        }
    }

    public final void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JComboBox) {
            ((JComboBox)this._component).getModel().removeListDataListener(this);
            ((JComboBox)this._component).removePopupMenuListener(this);
        }
        this._component.removePropertyChangeListener("model", this);
    }

    public final boolean isShowPopupDuringSearching() {
        return this._showPopupDuringSearching;
    }

    public final void setShowPopupDuringSearching(boolean bl) {
        this._showPopupDuringSearching = bl;
    }

    public final boolean isRefreshPopupDuringSearching() {
        return this._refreshPopupDuringSearching;
    }

    public final void setRefreshPopupDuringSearching(boolean bl) {
        this._refreshPopupDuringSearching = bl;
    }

    protected void setSelectedIndex(int n, boolean bl) {
        if (((JComboBox)this._component).getSelectedIndex() != n) {
            ((JComboBox)this._component).setSelectedIndex(n);
        }
        if (this.isShowPopupDuringSearching() || this.isRefreshPopupDuringSearching()) {
            boolean bl2 = this.isHideSearchPopupOnEvent();
            this.setHideSearchPopupOnEvent(false);
            ((JComboBox)this._component).hidePopup();
            this.setHideSearchPopupOnEvent(bl2);
            if (this._component.isVisible() && this._component.isShowing()) {
                ((JComboBox)this._component).showPopup();
            }
        }
    }

    protected final int getSelectedIndex() {
        return ((JComboBox)this._component).getSelectedIndex();
    }

    protected final Object getElementAt(int n) {
        ComboBoxModel comboBoxModel = ((JComboBox)this._component).getModel();
        return comboBoxModel.getElementAt(n);
    }

    protected final int getElementCount() {
        ComboBoxModel comboBoxModel = ((JComboBox)this._component).getModel();
        return comboBoxModel.getSize();
    }

    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public final void contentsChanged(ListDataEvent listDataEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        if (listDataEvent.getIndex0() != -1 || listDataEvent.getIndex1() != -1) {
            this.hidePopup();
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    public final void intervalAdded(ListDataEvent listDataEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public final void intervalRemoved(ListDataEvent listDataEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName())) {
            this.hidePopup();
            if (propertyChangeEvent.getOldValue() instanceof ComboBoxModel) {
                ((ComboBoxModel)propertyChangeEvent.getOldValue()).removeListDataListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof ComboBoxModel) {
                ((ComboBoxModel)propertyChangeEvent.getNewValue()).addListDataListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    public final void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        if (this.isHideSearchPopupOnEvent()) {
            this.hidePopup();
        }
    }

    public final void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }
}

