/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.DelegateAction$PassthroughDelegateAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public abstract class DelegateAction
extends AbstractAction {
    private static final long serialVersionUID = -3867985431184738600L;
    private Action _action;
    private JComponent _target;

    public DelegateAction() {
    }

    public DelegateAction(Action action) {
        this._action = action;
    }

    public DelegateAction(Action action, JComponent jComponent) {
        this._action = action;
        this._target = jComponent;
    }

    public boolean isEnabled() {
        return this.isDelegateEnabled() || this._action != null && this._action.isEnabled();
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        if (!this.delegateActionPerformed(actionEvent) && this._action != null) {
            if (this._target == null) {
                this._action.actionPerformed(actionEvent);
            } else {
                this._action.actionPerformed(new ActionEvent(this.getTarget(), actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
            }
        }
    }

    protected final Action getAction() {
        return this._action;
    }

    protected final void setAction(Action action) {
        this._action = action;
    }

    protected final JComponent getTarget() {
        return this._target;
    }

    protected final void setTarget(JComponent jComponent) {
        this._target = jComponent;
    }

    public boolean isDelegateEnabled() {
        return super.isEnabled();
    }

    public abstract boolean delegateActionPerformed(ActionEvent var1);

    public static final void replaceAction(JComponent jComponent, int n, KeyStroke keyStroke, DelegateAction delegateAction) {
        DelegateAction.replaceAction(jComponent, n, jComponent, n, keyStroke, delegateAction);
    }

    public static final void replaceAction(JComponent jComponent, int n, KeyStroke keyStroke, DelegateAction delegateAction, boolean bl) {
        DelegateAction.replaceAction(jComponent, n, jComponent, n, keyStroke, delegateAction, bl);
    }

    public static final void replaceAction(JComponent jComponent, int n, JComponent jComponent2, int n2, KeyStroke keyStroke) {
        DelegateAction.replaceAction(jComponent, n, jComponent2, n2, keyStroke, new DelegateAction$PassthroughDelegateAction(), false);
    }

    public static final void replaceAction(JComponent jComponent, int n, JComponent jComponent2, int n2, KeyStroke keyStroke, DelegateAction delegateAction) {
        DelegateAction.replaceAction(jComponent, n, jComponent2, n2, keyStroke, delegateAction, false);
    }

    public static final void replaceAction(JComponent jComponent, int n, JComponent jComponent2, int n2, KeyStroke keyStroke, DelegateAction delegateAction, boolean bl) {
        Object object;
        ActionListener actionListener = jComponent.getActionForKeyStroke(keyStroke);
        if (actionListener != delegateAction && actionListener instanceof Action) {
            if (!bl && actionListener instanceof DelegateAction) {
                object = ((DelegateAction)actionListener).getAction();
                while (object != null) {
                    if (object == delegateAction) {
                        return;
                    }
                    if (object instanceof DelegateAction) {
                        object = ((DelegateAction)object).getAction();
                        continue;
                    }
                    object = null;
                }
                delegateAction.setAction(((DelegateAction)actionListener).getAction());
                ((DelegateAction)actionListener).setAction(delegateAction);
                delegateAction = (DelegateAction)actionListener;
            } else {
                delegateAction.setAction((Action)actionListener);
            }
        }
        if (jComponent2 != jComponent) {
            delegateAction.setTarget(jComponent2);
            DelegateAction.replaceAction(jComponent, n, keyStroke, delegateAction);
        } else {
            object = jComponent2.getInputMap(n2).get(keyStroke);
            if (object == null) {
                jComponent.registerKeyboardAction(delegateAction, keyStroke, n);
            } else {
                jComponent.getActionMap().put(object, delegateAction);
            }
        }
    }

    public static final void restoreAction(JComponent jComponent, int n, KeyStroke keyStroke) {
        if (jComponent == null) {
            return;
        }
        ActionListener actionListener = jComponent.getActionForKeyStroke(keyStroke);
        if (actionListener instanceof DelegateAction) {
            Action action = ((DelegateAction)actionListener).getAction();
            if (action != null) {
                jComponent.registerKeyboardAction(action, keyStroke, n);
            } else {
                jComponent.unregisterKeyboardAction(keyStroke);
            }
        }
    }

    public static final void restoreAction(JComponent jComponent, int n, KeyStroke keyStroke, Class clazz) {
        ActionListener actionListener;
        ActionListener actionListener2 = actionListener = jComponent.getActionForKeyStroke(keyStroke);
        ActionListener actionListener3 = actionListener;
        while (actionListener instanceof DelegateAction) {
            if (clazz.isAssignableFrom(actionListener.getClass())) {
                if (actionListener3 == actionListener) {
                    Action action = ((DelegateAction)actionListener).getAction();
                    if (action == null) {
                        jComponent.unregisterKeyboardAction(keyStroke);
                        break;
                    }
                    jComponent.registerKeyboardAction(action, keyStroke, n);
                    break;
                }
                ((DelegateAction)actionListener2).setAction(((DelegateAction)actionListener).getAction());
                break;
            }
            actionListener2 = actionListener;
            actionListener = ((DelegateAction)actionListener).getAction();
        }
    }

    public static final void restoreAction(JComponent jComponent, int n, KeyStroke keyStroke, Action action) {
        ActionListener actionListener;
        ActionListener actionListener2 = actionListener = jComponent.getActionForKeyStroke(keyStroke);
        ActionListener actionListener3 = actionListener;
        while (actionListener instanceof DelegateAction) {
            if (action == actionListener) {
                if (actionListener3 == actionListener) {
                    jComponent.registerKeyboardAction(((DelegateAction)actionListener).getAction(), keyStroke, n);
                    break;
                }
                ((DelegateAction)actionListener2).setAction(((DelegateAction)actionListener).getAction());
                break;
            }
            actionListener2 = actionListener;
            actionListener = ((DelegateAction)actionListener).getAction();
        }
    }
}

