/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.JideMenu$1;
import com.jidesoft.swing.JideMenu$HideTimer;
import com.jidesoft.swing.JideMenu$MenuCreator;
import com.jidesoft.swing.JideMenu$PopupMenuCustomizer;
import com.jidesoft.swing.JideMenu$PopupMenuOriginCalculator;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SystemInfo;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;

public class JideMenu
extends JMenu
implements Alignable {
    private int _preferredPopupHorizontalAlignment = 2;
    private int _preferredPopupVerticalAlignment = 3;
    private JideMenu$MenuCreator _menuCreator;
    private JideMenu$PopupMenuCustomizer _customizer;
    private JideMenu$PopupMenuOriginCalculator _originCalculator;
    public static int DELAY = 400;
    private int _orientation;
    private static JideMenu _pendingMenu;
    private static JideMenu$HideTimer _timer;
    private static final boolean DISABLE_TIMER = true;

    public JideMenu() {
        this.initMenu();
    }

    public JideMenu(String string) {
        super(string);
        this.initMenu();
    }

    public JideMenu(Action action) {
        super(action);
        this.initMenu();
    }

    public JideMenu(String string, boolean bl) {
        super(string, bl);
        this.initMenu();
    }

    protected final void initMenu() {
        this.addMenuListener(new JideMenu$1(this));
    }

    public final boolean isTopLevelMenu() {
        return this.getParent() == null || !(this.getParent() instanceof JPopupMenu);
    }

    public final JideMenu$PopupMenuOriginCalculator getOriginCalculator() {
        return this._originCalculator;
    }

    public final void setOriginCalculator(JideMenu$PopupMenuOriginCalculator jideMenu$PopupMenuOriginCalculator) {
        this._originCalculator = jideMenu$PopupMenuOriginCalculator;
    }

    public final JideMenu$MenuCreator getMenuCreator() {
        return this._menuCreator;
    }

    public final void setMenuCreator(JideMenu$MenuCreator jideMenu$MenuCreator) {
        this._menuCreator = jideMenu$MenuCreator;
    }

    public final JideMenu$PopupMenuCustomizer getPopupMenuCustomizer() {
        return this._customizer;
    }

    public final void setPopupMenuCustomizer(JideMenu$PopupMenuCustomizer jideMenu$PopupMenuCustomizer) {
        this._customizer = jideMenu$PopupMenuCustomizer;
    }

    protected final Point getPopupMenuOrigin() {
        int n;
        int n2;
        int n3;
        GraphicsDevice[] graphicsDeviceArray;
        if (this._originCalculator != null) {
            return this._originCalculator.getPopupMenuOrigin(this);
        }
        JPopupMenu jPopupMenu = this.getPopupMenu();
        Dimension dimension = this.getSize();
        Dimension dimension2 = jPopupMenu.getPreferredSize();
        Point point = this.getLocationOnScreen();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        Rectangle rectangle = new Rectangle(toolkit.getScreenSize());
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Object object = graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n4 = ((GraphicsDevice[])object).length;
        for (n3 = 0; n3 < n4; ++n3) {
            GraphicsConfiguration graphicsConfiguration2;
            GraphicsDevice graphicsDevice = object[n3];
            if (graphicsDevice.getType() != 0 || !(graphicsConfiguration2 = graphicsDevice.getDefaultConfiguration()).getBounds().contains(point)) continue;
            graphicsConfiguration = graphicsConfiguration2;
            break;
        }
        if (graphicsConfiguration != null) {
            rectangle = graphicsConfiguration.getBounds();
            object = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle.width -= Math.abs(object.left + object.right);
            rectangle.height -= Math.abs(object.top + object.bottom);
            point.x -= Math.abs(object.left);
            point.y -= Math.abs(object.top);
        }
        if ((object = this.getParent()) instanceof JPopupMenu) {
            n4 = UIDefaultsLookup.getInt("Menu.submenuPopupOffsetX");
            n3 = UIDefaultsLookup.getInt("Menu.submenuPopupOffsetY");
            if (this.getComponentOrientation().isLeftToRight()) {
                if (JideSwingUtilities.getOrientationOf(this) == 0) {
                    n2 = dimension.width + n4;
                    if (point.x + n2 + dimension2.width >= rectangle.width + rectangle.x && rectangle.width - dimension.width < 2 * (point.x - rectangle.x)) {
                        n2 = 0 - n4 - dimension2.width;
                    }
                } else {
                    n2 = dimension.width + n4;
                    if (point.x + n2 + dimension2.width >= rectangle.width + rectangle.x && rectangle.width - dimension.width < 2 * (point.x - rectangle.x)) {
                        n2 = 0 - n4 - dimension2.width;
                    }
                }
            } else {
                n2 = 0 - n4 - dimension2.width;
                if (point.x + n2 < rectangle.x && rectangle.width - dimension.width > 2 * (point.x - rectangle.x)) {
                    n2 = dimension.width + n4;
                }
            }
            if (point.y + (n = n3) + dimension2.height >= rectangle.height + rectangle.y && rectangle.height - dimension.height < 2 * (point.y - rectangle.y)) {
                n = dimension.height - n3 - dimension2.height;
            }
        } else {
            n4 = UIDefaultsLookup.getInt("Menu.menuPopupOffsetX");
            n3 = UIDefaultsLookup.getInt("Menu.menuPopupOffsetY");
            if (this.getComponentOrientation().isLeftToRight()) {
                if (JideSwingUtilities.getOrientationOf(this) == 0) {
                    if (this.getPreferredPopupHorizontalAlignment() == 2) {
                        n2 = n4;
                        if (point.x + n2 + dimension2.width >= rectangle.width + rectangle.x && rectangle.width - dimension.width < 2 * (point.x - rectangle.x)) {
                            n2 = dimension.width - n4 - dimension2.width;
                        }
                    } else {
                        n2 = -dimension2.width + n4 + dimension.width;
                        if (point.x + n2 < rectangle.x) {
                            n2 = rectangle.x - point.x;
                        }
                    }
                } else {
                    n2 = 1 - n4 - dimension2.width;
                    if (point.x + n2 < rectangle.x && rectangle.width - dimension.width > 2 * (point.x - rectangle.x)) {
                        n2 = dimension.width + n4 - 1;
                    }
                }
            } else if (this.getPreferredPopupHorizontalAlignment() == 2) {
                n2 = dimension.width - n4 - dimension2.width;
                if (point.x + n2 < rectangle.x && rectangle.width - dimension.width > 2 * (point.x - rectangle.x)) {
                    n2 = n4;
                }
            } else {
                n2 = n4;
            }
            if (JideSwingUtilities.getOrientationOf(this) == 0) {
                n = dimension.height + n3 - 1;
                if (this.getPreferredPopupVerticalAlignment() == 1 || point.y + n + dimension2.height >= rectangle.height && rectangle.height - dimension.height < 2 * (point.y - rectangle.y)) {
                    n = 1 - n3 - dimension2.height;
                }
            } else {
                n = -n3;
                if (point.y + n + dimension2.height >= rectangle.height && rectangle.height - dimension.height < 2 * (point.y - rectangle.y)) {
                    n = 0 - n3 - dimension2.height;
                }
            }
        }
        return new Point(n2, n);
    }

    public final boolean isOpaque() {
        return SystemInfo.isMacOSX() && this.isSelected() ? super.isOpaque() : !this.isTopLevelMenu() && super.isOpaque();
    }

    public final boolean originalIsOpaque() {
        return super.isOpaque();
    }

    protected final void hideMenu() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        menuSelectionManager.clearSelectedPath();
    }

    public final int getPreferredPopupHorizontalAlignment() {
        return this._preferredPopupHorizontalAlignment;
    }

    public final void setPreferredPopupHorizontalAlignment(int n) {
        this._preferredPopupHorizontalAlignment = n;
    }

    public final int getPreferredPopupVerticalAlignment() {
        return this._preferredPopupVerticalAlignment;
    }

    public final void setPreferredPopupVerticalAlignment(int n) {
        this._preferredPopupVerticalAlignment = n;
    }

    public boolean supportVerticalOrientation() {
        return true;
    }

    public boolean supportHorizontalOrientation() {
        return true;
    }

    public void setOrientation(int n) {
        int n2 = this._orientation;
        if (n2 != n) {
            this._orientation = n;
            this.firePropertyChange("orientation", n2, n);
        }
    }

    public int getOrientation() {
        return this._orientation;
    }

    public final void setPopupMenuVisible(boolean bl) {
        JideMenu$PopupMenuCustomizer jideMenu$PopupMenuCustomizer;
        JideMenu$MenuCreator jideMenu$MenuCreator;
        if (bl && (jideMenu$MenuCreator = this.getMenuCreator()) != null) {
            jideMenu$MenuCreator.createMenu();
        }
        if (bl && (jideMenu$PopupMenuCustomizer = this.getPopupMenuCustomizer()) != null) {
            jideMenu$PopupMenuCustomizer.customize(this.getPopupMenu());
            if (this.shouldHidePopupMenu()) {
                return;
            }
        } else if (bl && this.shouldHidePopupMenu()) {
            return;
        }
        this.setPopupMenuVisibleImmediately(bl);
    }

    protected final boolean shouldHidePopupMenu() {
        return this.getPopupMenu().getComponentCount() == 0;
    }

    private final void setPopupMenuVisibleImmediately(boolean bl) {
        super.setPopupMenuVisible(bl);
    }

    private void startTimer() {
        if (_timer != null) {
            this.stopTimer();
        }
        _pendingMenu = this;
        _timer = new JideMenu$HideTimer(this);
        _timer.start();
    }

    private void stopTimer() {
        if (_timer != null) {
            if (_pendingMenu != null) {
                _pendingMenu.setPopupMenuVisibleImmediately(false);
                _pendingMenu = null;
            }
            _timer.stop();
            _timer = null;
        }
    }

    static final /* synthetic */ void access$000(JideMenu jideMenu) {
        jideMenu.stopTimer();
    }
}

