/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class JideTitledBorder
extends AbstractBorder {
    private static final long serialVersionUID = 5409659168893849250L;
    protected String title;
    protected Border border;
    protected int titlePosition;
    protected int titleJustification;
    protected Font titleFont;
    protected Color titleColor;
    private Point textLoc = new Point();
    public static final int DEFAULT_POSITION = 0;
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    public static final int DEFAULT_JUSTIFICATION = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int LEADING = 4;
    public static final int TRAILING = 5;
    protected static final int EDGE_SPACING = 2;
    protected static final int TITLE_MARGIN = 5;
    protected static final int TEXT_SPACING = 2;
    protected static final int TEXT_INSET_H = 0;

    public JideTitledBorder(String string) {
        this(null, string, 4, 2, null, null);
    }

    public JideTitledBorder(Border border) {
        this(border, "", 4, 2, null, null);
    }

    public JideTitledBorder(Border border, String string) {
        this(border, string, 4, 2, null, null);
    }

    public JideTitledBorder(Border border, String string, int n, int n2) {
        this(border, string, n, n2, null, null);
    }

    public JideTitledBorder(Border border, String string, int n, int n2, Font font) {
        this(border, string, n, n2, font, null);
    }

    public JideTitledBorder(Border border, String string, int n, int n2, Font font, Color color) {
        this.title = string;
        this.border = border;
        this.titleFont = font;
        this.titleColor = color;
        this.setTitleJustification(n);
        this.setTitlePosition(n2);
    }

    public final void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Border border = this.getBorder();
        if (this.getTitle() == null || this.getTitle().equals("")) {
            if (border != null) {
                border.paintBorder(component, graphics, n, n2, n3, n4);
            }
            return;
        }
        Rectangle rectangle = new Rectangle(n + 2, n2 + 2, n3 - 4, n4 - 4);
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        graphics.setFont(this.getFont(component));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = fontMetrics.getHeight();
        int n6 = fontMetrics.getDescent();
        int n7 = fontMetrics.getAscent();
        int n8 = fontMetrics.stringWidth(this.getTitle());
        Insets insets = border != null ? border.getBorderInsets(component) : new Insets(0, 0, 0, 0);
        int n9 = this.getTitlePosition();
        switch (n9) {
            case 1: {
                int n10 = n7 + n6 + (Math.max(2, 4) - 2);
                rectangle.y += n10;
                rectangle.height -= n10;
                this.textLoc.y = rectangle.y - (n6 + 2);
                break;
            }
            case 0: 
            case 2: {
                int n11 = Math.max(0, (n7 >> 1) + 2 - 2);
                rectangle.y += n11;
                rectangle.height -= n11;
                this.textLoc.y = rectangle.y - n6 + (insets.top + n7 + n6 >> 1);
                break;
            }
            case 3: {
                this.textLoc.y = rectangle.y + insets.top + n7 + 2;
                break;
            }
            case 4: {
                this.textLoc.y = rectangle.y + rectangle.height - (insets.bottom + n6 + 2);
                break;
            }
            case 5: {
                rectangle.height -= n5 >> 1;
                this.textLoc.y = rectangle.y + rectangle.height - n6 + (n7 + n6 - insets.bottom >> 1);
                break;
            }
            case 6: {
                rectangle.height -= n5;
                this.textLoc.y = rectangle.y + rectangle.height + n7 + 2;
            }
        }
        int n12 = this.getTitleJustification();
        if (component.getComponentOrientation().isLeftToRight()) {
            if (n12 == 4 || n12 == 0) {
                n12 = 1;
            } else if (n12 == 5) {
                n12 = 3;
            }
        } else if (n12 == 4 || n12 == 0) {
            n12 = 3;
        } else if (n12 == 5) {
            n12 = 1;
        }
        switch (n12) {
            case 1: {
                this.textLoc.x = rectangle.x + 0 + insets.left;
                break;
            }
            case 3: {
                this.textLoc.x = rectangle.x + rectangle.width - (n8 + 0 + insets.right);
                break;
            }
            case 2: {
                this.textLoc.x = rectangle.x + (rectangle.width - n8 >> 1);
            }
        }
        if (border != null) {
            if ((n9 == 2 || n9 == 0) && rectangle.y > this.textLoc.y - n7 || n9 == 5 && rectangle.y + rectangle.height < this.textLoc.y + n6) {
                Rectangle rectangle2 = new Rectangle();
                Rectangle rectangle3 = graphics.getClipBounds();
                rectangle2.setBounds(rectangle3);
                if (JideTitledBorder.computeIntersection(rectangle2, n, n2, this.textLoc.x - 5 - n, n4)) {
                    graphics.setClip(rectangle2);
                    border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                rectangle2.setBounds(rectangle3);
                if (JideTitledBorder.computeIntersection(rectangle2, this.textLoc.x + n8 + 5, n2, n + n3 - (this.textLoc.x + n8 + 5), n4)) {
                    graphics.setClip(rectangle2);
                    border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                if (n9 == 2 || n9 == 0) {
                    rectangle2.setBounds(rectangle3);
                    if (JideTitledBorder.computeIntersection(rectangle2, this.textLoc.x - 5, this.textLoc.y + n6, n8 + 10, n2 + n4 - this.textLoc.y - n6)) {
                        graphics.setClip(rectangle2);
                        border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                } else {
                    rectangle2.setBounds(rectangle3);
                    if (JideTitledBorder.computeIntersection(rectangle2, this.textLoc.x - 5, n2, n8 + 10, this.textLoc.y - n7 - n2)) {
                        graphics.setClip(rectangle2);
                        border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                }
                graphics.setClip(rectangle3);
            } else {
                border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        graphics.setColor(this.getTitleColor());
        JideSwingUtilities.drawString((JComponent)component, graphics, this.getTitle(), this.textLoc.x, this.textLoc.y);
        graphics.setFont(font);
        graphics.setColor(color);
    }

    public final Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
    }

    public final Insets getBorderInsets(Component component, Insets insets) {
        Serializable serializable;
        int n = 0;
        int n2 = 16;
        int n3 = 16;
        Border border = this.getBorder();
        if (border != null) {
            if (border instanceof AbstractBorder) {
                ((AbstractBorder)border).getBorderInsets(component, insets);
            } else {
                serializable = border.getBorderInsets(component);
                insets.top = serializable.top;
                insets.right = serializable.right;
                insets.bottom = serializable.bottom;
                insets.left = serializable.left;
            }
        } else {
            insets.bottom = 0;
            insets.right = 0;
            insets.top = 0;
            insets.left = 0;
        }
        insets.left = insets.left + (2 + (insets.left > 0 ? 2 : 0));
        insets.right = insets.right + (2 + (insets.right > 0 ? 2 : 0));
        insets.top = insets.top + (2 + (insets.top > 0 ? 2 : 0));
        insets.bottom = insets.bottom + (2 + (insets.bottom > 0 ? 2 : 0));
        if (component == null || this.getTitle() == null || this.getTitle().equals("")) {
            return insets;
        }
        serializable = this.getFont(component);
        FontMetrics fontMetrics = component.getFontMetrics((Font)serializable);
        if (fontMetrics != null) {
            n = fontMetrics.getDescent();
            n2 = fontMetrics.getAscent();
            n3 = fontMetrics.getHeight();
        }
        switch (this.getTitlePosition()) {
            case 1: {
                insets.top += n2 + n + (Math.max(2, 4) - 2);
                break;
            }
            case 0: 
            case 2: {
                insets.top += n2 + n;
                break;
            }
            case 3: {
                insets.top += n2 + n + 2;
                break;
            }
            case 4: {
                insets.bottom += n2 + n + 2;
                break;
            }
            case 5: {
                insets.bottom += n2 + n;
                break;
            }
            case 6: {
                insets.bottom += n3;
            }
        }
        return insets;
    }

    public final boolean isBorderOpaque() {
        return false;
    }

    public final String getTitle() {
        return this.title;
    }

    public final Border getBorder() {
        Border border = this.border;
        if (border == null) {
            border = UIDefaultsLookup.getBorder("TitledBorder.border");
        }
        return border;
    }

    public final int getTitlePosition() {
        return this.titlePosition;
    }

    public final int getTitleJustification() {
        return this.titleJustification;
    }

    public final Font getTitleFont() {
        Font font = this.titleFont;
        if (font == null) {
            font = UIDefaultsLookup.getFont("TitledBorder.font");
        }
        return font;
    }

    public final Color getTitleColor() {
        Color color = this.titleColor;
        if (color == null) {
            color = UIDefaultsLookup.getColor("TitledBorder.titleColor");
        }
        return color;
    }

    public final void setTitle(String string) {
        this.title = string;
    }

    public final void setBorder(Border border) {
        this.border = border;
    }

    public final void setTitlePosition(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.titlePosition = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(n + " is not a valid title position.");
            }
        }
    }

    public final void setTitleJustification(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.titleJustification = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(n + " is not a valid title justification.");
            }
        }
    }

    public final void setTitleFont(Font font) {
        this.titleFont = font;
    }

    public final void setTitleColor(Color color) {
        this.titleColor = color;
    }

    public final Dimension getMinimumSize(Component component) {
        Insets insets = this.getBorderInsets(component);
        Dimension dimension = new Dimension(insets.right + insets.left, insets.top + insets.bottom);
        Font font = this.getFont(component);
        FontMetrics fontMetrics = component.getFontMetrics(font);
        switch (this.titlePosition) {
            case 1: 
            case 6: {
                dimension.width = Math.max(fontMetrics.stringWidth(this.getTitle()), dimension.width);
                break;
            }
            default: {
                dimension.width += fontMetrics.stringWidth(this.getTitle());
            }
        }
        return dimension;
    }

    protected final Font getFont(Component component) {
        Font font = this.getTitleFont();
        if (font != null) {
            return font;
        }
        if (component != null && (font = component.getFont()) != null) {
            return font;
        }
        return new Font("Dialog", 0, 12);
    }

    private static boolean computeIntersection(Rectangle rectangle, int n, int n2, int n3, int n4) {
        int n5 = Math.max(n, rectangle.x);
        int n6 = Math.min(n + n3, rectangle.x + rectangle.width);
        int n7 = Math.max(n2, rectangle.y);
        int n8 = Math.min(n2 + n4, rectangle.y + rectangle.height);
        rectangle.x = n5;
        rectangle.y = n7;
        rectangle.width = n6 - n5;
        rectangle.height = n8 - n7;
        return rectangle.width > 0 && rectangle.height > 0;
    }
}

