/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.ResizableMouseInputAdapter;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;

public class Resizable {
    public static final int NONE = 0;
    public static final int UPPER_LEFT = 1;
    public static final int UPPER = 2;
    public static final int UPPER_RIGHT = 4;
    public static final int RIGHT = 8;
    public static final int LOWER_RIGHT = 16;
    public static final int LOWER = 32;
    public static final int LOWER_LEFT = 64;
    public static final int LEFT = 128;
    public static final int ALL = 255;
    private int _resizableCorners = 255;
    private int _resizeCornerSize = 16;
    public static final String PROPERTY_RESIZABLE_CORNERS = "resizableCorner";
    public static final String PROPERTY_RESIZE_CORNER_SIZE = "resizeCornerSize";
    protected final JComponent _component;
    private Insets _resizeInsets;
    private MouseInputListener _mouseInputAdapter;
    private int _snapGridSize = 1;
    private boolean _topLevel;

    public Resizable(JComponent jComponent) {
        this._component = jComponent;
        this.installListeners();
    }

    public final int getResizableCorners() {
        return this._resizableCorners;
    }

    public final void setResizableCorners(int n) {
        if (this._resizableCorners != n) {
            int n2 = this._resizableCorners;
            this._resizableCorners = n;
            this._component.firePropertyChange(PROPERTY_RESIZABLE_CORNERS, n2, this._resizableCorners);
        }
    }

    public final int getResizeCornerSize() {
        return this._resizeCornerSize;
    }

    public final void setResizeCornerSize(int n) {
        if (this._resizeCornerSize != n) {
            int n2 = this._resizeCornerSize;
            this._resizeCornerSize = n;
            this._component.firePropertyChange(PROPERTY_RESIZE_CORNER_SIZE, n2, this._resizeCornerSize);
        }
    }

    protected final void installListeners() {
        this._mouseInputAdapter = this.createMouseInputListener();
        this._component.addMouseListener(this._mouseInputAdapter);
        this._component.addMouseMotionListener(this._mouseInputAdapter);
    }

    public final void uninstallListeners() {
        this._component.removeMouseListener(this._mouseInputAdapter);
        this._component.removeMouseMotionListener(this._mouseInputAdapter);
        this._mouseInputAdapter = null;
    }

    protected final MouseInputListener createMouseInputListener() {
        return new ResizableMouseInputAdapter(this);
    }

    public final MouseInputListener getMouseInputAdapter() {
        return this._mouseInputAdapter;
    }

    public void beginResizing(int n) {
    }

    public void resizing(int n, int n2, int n3, int n4, int n5) {
        Dimension dimension = this._component.getMinimumSize();
        Dimension dimension2 = this._component.getMaximumSize();
        if (n4 < dimension.width) {
            n4 = dimension.width;
        }
        if (n5 < dimension.height) {
            n4 = dimension.height;
        }
        if (n4 > dimension2.width) {
            n4 = dimension2.width;
        }
        if (n5 > dimension2.height) {
            n5 = dimension2.height;
        }
        this._component.setPreferredSize(new Dimension(n4, n5));
        this._component.getParent().doLayout();
    }

    public void endResizing(int n) {
    }

    public boolean isTopLevel() {
        return this._topLevel;
    }

    public final void setTopLevel(boolean bl) {
        this._topLevel = bl;
    }

    public final JComponent getComponent() {
        return this._component;
    }

    public final Insets getResizeInsets() {
        if (this._resizeInsets != null) {
            return this._resizeInsets;
        }
        return this.getComponent().getInsets();
    }

    public final void setResizeInsets(Insets insets) {
        this._resizeInsets = insets;
    }

    public final int getSnapGridSize() {
        return this._snapGridSize;
    }

    public final void setSnapGridSize(int n) {
        this._snapGridSize = n;
    }
}

