/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.SimpleScrollPane;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.UIResource;

public class SimpleScrollPane$ScrollButton
extends JideButton
implements MouseListener,
ActionListener,
UIResource {
    private int _type;
    private Timer _timer;
    final /* synthetic */ SimpleScrollPane this$0;

    public SimpleScrollPane$ScrollButton(SimpleScrollPane simpleScrollPane, int n) {
        this.this$0 = simpleScrollPane;
        this._type = n;
        switch (n) {
            case 1: {
                this.setIcon(JideIconsFactory.getImageIcon("jide/direction_up.gif"));
                break;
            }
            case 5: {
                this.setIcon(JideIconsFactory.getImageIcon("jide/direction_down.gif"));
                break;
            }
            case 7: {
                this.setIcon(JideIconsFactory.getImageIcon("jide/direction_left.gif"));
                break;
            }
            case 3: {
                this.setIcon(JideIconsFactory.getImageIcon("jide/direction_right.gif"));
            }
        }
        this.addActionListener(this);
        this.addMouseListener(this);
        this.setPreferredSize(new Dimension(10, 10));
        this.setMinimumSize(new Dimension(10, 10));
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        this.this$0.scroll(this.this$0.getViewport(), this._type);
        this.this$0.updateButtonState();
    }

    public final void mouseClicked(MouseEvent mouseEvent) {
    }

    public final void mousePressed(MouseEvent mouseEvent) {
        if (!this.this$0.isScrollOnRollover()) {
            this.startTimer(mouseEvent, 500);
        } else {
            this.updateTimer(mouseEvent);
        }
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
        if (!this.this$0.isScrollOnRollover()) {
            this.stopTimer();
        } else {
            this.updateTimer(mouseEvent);
        }
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
        if (this.this$0.isScrollOnRollover()) {
            this.startTimer(mouseEvent, 500);
        }
    }

    private void updateTimer(MouseEvent mouseEvent) {
        if (this._timer != null) {
            this._timer.setDelay(this.getDelay(mouseEvent));
        }
    }

    private void startTimer(MouseEvent mouseEvent, int n) {
        this.stopTimer();
        this._timer = new Timer(this.getDelay(mouseEvent), this);
        this._timer.setInitialDelay(n);
        this._timer.start();
    }

    private void stopTimer() {
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
    }

    private int getDelay(MouseEvent mouseEvent) {
        if (this.this$0.isScrollOnRollover()) {
            return SwingUtilities.isLeftMouseButton(mouseEvent) ? this.this$0.getRepeatDelay() : this.this$0.getRepeatDelay() * 2;
        }
        return this.this$0.getRepeatDelay();
    }

    public final void mouseExited(MouseEvent mouseEvent) {
        if (this.this$0.isScrollOnRollover()) {
            this.stopTimer();
        }
    }
}

