/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.SimpleScrollPane$ScrollButton;
import com.jidesoft.swing.SimpleScrollPaneLayout$UIResource;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractButton;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimpleScrollPane
extends JScrollPane
implements ChangeListener,
MouseWheelListener {
    private AbstractButton _scrollUpButton;
    private AbstractButton _scrollDownButton;
    private AbstractButton _scrollLeftButton;
    private AbstractButton _scrollRightButton;
    private int _horizontalUnitIncrement = 10;
    private boolean _horizontalUnitIncrementSet = false;
    private int _verticalUnitIncrement = 10;
    private boolean _verticalUnitIncrementSet = false;
    private int _repeatDelay = 50;
    private boolean _scrollOnRollover = true;
    public static final String SCROLL_UP_BUTTON = "SCROLL_UP_BUTTON";
    public static final String SCROLL_DOWN_BUTTON = "SCROLL_DOWN_BUTTON";
    public static final String SCROLL_LEFT_BUTTON = "SCROLL_LEFT_BUTTON";
    public static final String SCROLL_RIGHT_BUTTON = "SCROLL_RIGHT_BUTTON";

    public SimpleScrollPane(Component component, int n, int n2) {
        this.setLayout(new SimpleScrollPaneLayout$UIResource());
        this.setVerticalScrollBarPolicy(n);
        this.setHorizontalScrollBarPolicy(n2);
        this.setViewport(this.createViewport());
        this.setScrollUpButton(this.createScrollButton(1));
        this.setScrollDownButton(this.createScrollButton(5));
        this.setScrollLeftButton(this.createScrollButton(7));
        this.setScrollRightButton(this.createScrollButton(3));
        if (null != component) {
            this.setViewportView(component);
        }
        this.updateButtonState();
        this.setOpaque(true);
        this.setFocusable(false);
        if (this.getHorizontalScrollBar() != null) {
            this.getHorizontalScrollBar().setVisible(false);
            this.getHorizontalScrollBar().setFocusable(false);
        }
        if (this.getVerticalScrollBar() != null) {
            this.getVerticalScrollBar().setVisible(false);
            this.getVerticalScrollBar().setFocusable(false);
        }
        this.updateUI();
        if (!this.getComponentOrientation().isLeftToRight()) {
            this.viewport.setViewPosition(new Point(Integer.MAX_VALUE, 0));
        }
        if (this.isWheelScrollingEnabled()) {
            this.addMouseWheelListener(this);
        }
    }

    public SimpleScrollPane(Component component) {
        this(component, 20, 30);
    }

    public SimpleScrollPane(int n, int n2) {
        this(null, n, n2);
    }

    public SimpleScrollPane() {
        this(null, 20, 30);
    }

    public final void updateUI() {
        super.updateUI();
        this.setLayout(new SimpleScrollPaneLayout$UIResource());
        LookAndFeel.installBorder(this, "JideScrollPane.border");
        this.getViewport().addChangeListener(this);
    }

    public final void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.getViewport()) {
            this.updateButtonState();
        }
    }

    public final AbstractButton getScrollUpButton() {
        return this._scrollUpButton;
    }

    public final void setScrollUpButton(AbstractButton abstractButton) {
        AbstractButton abstractButton2 = this.getScrollUpButton();
        this._scrollUpButton = abstractButton;
        this.add((Component)this._scrollUpButton, SCROLL_UP_BUTTON);
        this.firePropertyChange("scrollUpButton", abstractButton2, this._scrollUpButton);
        this.revalidate();
        this.repaint();
    }

    public final AbstractButton getScrollDownButton() {
        return this._scrollDownButton;
    }

    public final void setScrollDownButton(AbstractButton abstractButton) {
        AbstractButton abstractButton2 = this.getScrollDownButton();
        this._scrollDownButton = abstractButton;
        this.add((Component)this._scrollDownButton, SCROLL_DOWN_BUTTON);
        this.firePropertyChange("scrollDownButton", abstractButton2, this._scrollDownButton);
        this.revalidate();
        this.repaint();
    }

    public final AbstractButton getScrollLeftButton() {
        return this._scrollLeftButton;
    }

    public final void setScrollLeftButton(AbstractButton abstractButton) {
        AbstractButton abstractButton2 = this.getScrollLeftButton();
        this._scrollLeftButton = abstractButton;
        this.add((Component)this._scrollLeftButton, SCROLL_LEFT_BUTTON);
        this.firePropertyChange("scrollLeftButton", abstractButton2, this._scrollLeftButton);
        this.revalidate();
        this.repaint();
    }

    public final AbstractButton getScrollRightButton() {
        return this._scrollRightButton;
    }

    public final void setScrollRightButton(AbstractButton abstractButton) {
        AbstractButton abstractButton2 = this.getScrollRightButton();
        this._scrollRightButton = abstractButton;
        this.add((Component)this._scrollRightButton, SCROLL_RIGHT_BUTTON);
        this.firePropertyChange("scrollRightButton", abstractButton2, this._scrollRightButton);
        this.revalidate();
        this.repaint();
    }

    protected final AbstractButton createScrollButton(int n) {
        return new SimpleScrollPane$ScrollButton(this, n);
    }

    protected final void updateButtonState() {
        Point point = this.viewport.getViewPosition();
        this._scrollUpButton.setEnabled(point.y != 0);
        this._scrollDownButton.setEnabled(point.y != this.viewport.getViewSize().height - this.viewport.getViewRect().height);
        this._scrollLeftButton.setEnabled(point.x != 0);
        this._scrollRightButton.setEnabled(point.x != this.viewport.getViewSize().width - this.viewport.getViewRect().width);
        this.revalidate();
        this.repaint();
    }

    public final void scroll(JViewport jViewport, int n) {
        Point point = jViewport.getViewPosition();
        JViewport jViewport2 = this.getViewport();
        switch (n) {
            case 1: {
                if (!this._verticalUnitIncrementSet && jViewport2 != null && jViewport2.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)jViewport2.getView());
                    Rectangle rectangle = jViewport2.getViewRect();
                    point.y -= scrollable.getScrollableUnitIncrement(rectangle, 1, -1);
                } else {
                    point.y -= this.getVerticalUnitIncrement();
                }
                if (point.y >= 0) break;
                point.y = 0;
                break;
            }
            case 5: {
                if (!this._verticalUnitIncrementSet && jViewport2 != null && jViewport2.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)jViewport2.getView());
                    Rectangle rectangle = jViewport2.getViewRect();
                    point.y += scrollable.getScrollableUnitIncrement(rectangle, 1, 1);
                } else {
                    point.y += this.getVerticalUnitIncrement();
                }
                if (point.y + jViewport.getViewRect().height <= jViewport.getViewSize().height) break;
                point.y = jViewport.getViewSize().height - jViewport.getViewRect().height;
                break;
            }
            case 7: {
                if (!this._horizontalUnitIncrementSet && jViewport2 != null && jViewport2.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)jViewport2.getView());
                    Rectangle rectangle = jViewport2.getViewRect();
                    point.x -= scrollable.getScrollableUnitIncrement(rectangle, 0, -1);
                } else {
                    point.x -= this.getHorizontalUnitIncrement();
                }
                if (point.x >= 0) break;
                point.x = 0;
                break;
            }
            case 3: {
                if (!this._horizontalUnitIncrementSet && jViewport2 != null && jViewport2.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)jViewport2.getView());
                    Rectangle rectangle = jViewport2.getViewRect();
                    point.x += scrollable.getScrollableUnitIncrement(rectangle, 0, 1);
                } else {
                    point.x += this.getHorizontalUnitIncrement();
                }
                if (point.x + jViewport.getViewRect().width <= jViewport.getViewSize().width) break;
                point.x = jViewport.getViewSize().width - jViewport.getViewRect().width;
            }
        }
        jViewport.setViewPosition(point);
    }

    public final Rectangle getViewportBorderBounds() {
        Rectangle rectangle = new Rectangle(this.getSize());
        Insets insets = this.getInsets();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        if (this._scrollUpButton != null && this._scrollUpButton.isVisible()) {
            rectangle.y += this._scrollUpButton.getHeight();
            rectangle.height -= this._scrollUpButton.getHeight();
        }
        if (this._scrollLeftButton != null && this._scrollLeftButton.isVisible()) {
            rectangle.x += this._scrollLeftButton.getWidth();
            rectangle.width -= this._scrollLeftButton.getWidth();
        }
        if (this._scrollDownButton != null && this._scrollDownButton.isVisible()) {
            rectangle.height -= this._scrollDownButton.getHeight();
        }
        if (this._scrollRightButton != null && this._scrollRightButton.isVisible()) {
            rectangle.width -= this._scrollRightButton.getWidth();
        }
        return rectangle;
    }

    public final int getHorizontalUnitIncrement() {
        return this._horizontalUnitIncrement;
    }

    public final void setHorizontalUnitIncrement(int n) {
        this._horizontalUnitIncrementSet = true;
        if (n != this._horizontalUnitIncrement) {
            int n2 = this._horizontalUnitIncrement;
            this._horizontalUnitIncrement = n;
            this.firePropertyChange("horizontalUnitIncrement", n2, this._horizontalUnitIncrement);
        }
    }

    public final int getVerticalUnitIncrement() {
        return this._verticalUnitIncrement;
    }

    public final void setVerticalUnitIncrement(int n) {
        this._verticalUnitIncrementSet = true;
        if (n != this._verticalUnitIncrement) {
            int n2 = this._verticalUnitIncrement;
            this._verticalUnitIncrement = n;
            this.firePropertyChange("verticalUnitIncrement", n2, this._verticalUnitIncrement);
        }
    }

    public final boolean isScrollOnRollover() {
        return this._scrollOnRollover;
    }

    public final void setScrollOnRollover(boolean bl) {
        if (this._scrollOnRollover != bl) {
            boolean bl2 = this._scrollOnRollover;
            this._scrollOnRollover = bl;
            this.firePropertyChange("scrollOnRollover", bl2, this._scrollOnRollover);
        }
    }

    public final int getRepeatDelay() {
        return this._repeatDelay;
    }

    public final void setRepeatDelay(int n) {
        if (n != this._repeatDelay) {
            int n2 = this._repeatDelay;
            this._repeatDelay = n;
            this.firePropertyChange("repeatDelay", n2, this._repeatDelay);
        }
    }

    public final void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.isWheelScrollingEnabled() && mouseWheelEvent.getScrollAmount() != 0) {
            boolean bl = mouseWheelEvent.getWheelRotation() >= 0;
            int n = 0;
            if (!this.isButtonVisible(bl)) {
                return;
            }
            n = this.getScrollDirection(bl);
            if (n != 0) {
                this.scroll(this.getViewport(), n);
            }
        }
    }

    private boolean isButtonVisible(boolean bl) {
        if (bl) {
            return this._scrollUpButton != null && this._scrollUpButton.isVisible() || this._scrollLeftButton != null && this._scrollLeftButton.isVisible();
        }
        return this._scrollDownButton != null && this._scrollDownButton.isVisible() || this._scrollRightButton != null && this._scrollRightButton.isVisible();
    }

    private int getScrollDirection(boolean bl) {
        if (bl) {
            if (this._scrollUpButton != null && this._scrollUpButton.isVisible()) {
                return 5;
            }
            if (this._scrollLeftButton != null && this._scrollLeftButton.isVisible()) {
                return 3;
            }
        } else {
            if (this._scrollDownButton != null && this._scrollDownButton.isVisible()) {
                return 1;
            }
            if (this._scrollRightButton != null && this._scrollRightButton.isVisible()) {
                return 7;
            }
        }
        return 0;
    }

    public final void setWheelScrollingEnabled(boolean bl) {
        if (bl && !this.isWheelScrollingEnabled()) {
            this.addMouseWheelListener(this);
        }
        if (!bl && this.isWheelScrollingEnabled()) {
            this.removeMouseWheelListener(this);
        }
        super.setWheelScrollingEnabled(bl);
    }
}

