/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.StyleRange;
import java.awt.Dimension;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class StyledLabel
extends JLabel {
    private static final String uiClassID = "StyledLabelUI";
    private List _styleRanges;
    private boolean _lineWrap;
    private int _rows;
    private int _maxRows;
    private int _minRows;
    private int _preferredWidth;
    private int _rowGap;
    private boolean _truncated = false;
    private boolean _ignoreColorSettings;
    public static final String PROPERTY_STYLE_RANGE = "styleRange";
    public static final String PROPERTY_IGNORE_COLOR_SETTINGS = "ignoreColorSettings";

    public StyledLabel() {
        this.setMaximumSize(null);
    }

    public StyledLabel(Icon icon) {
        super(icon);
        this.setMaximumSize(null);
    }

    public StyledLabel(Icon icon, int n) {
        super(icon, n);
        this.setMaximumSize(null);
    }

    public StyledLabel(String string) {
        super(string);
        this.setMaximumSize(null);
    }

    public StyledLabel(String string, int n) {
        super(string, n);
        this.setMaximumSize(null);
    }

    public StyledLabel(String string, Icon icon, int n) {
        super(string, icon, n);
        this.setMaximumSize(null);
    }

    public final void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
    }

    public final String getUIClassID() {
        return uiClassID;
    }

    public final synchronized void addStyleRange(StyleRange styleRange) {
        if (styleRange == null) {
            throw new IllegalArgumentException("StyleRange cannot be null.");
        }
        List list = this.internalGetStyleRanges();
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            StyleRange styleRange2 = (StyleRange)list.get(i2);
            if (styleRange2.getStart() != styleRange.getStart() || styleRange2.getLength() != styleRange.getLength()) continue;
            list.remove(i2);
        }
        this.internalGetStyleRanges().add(styleRange);
        this.firePropertyChange(PROPERTY_STYLE_RANGE, null, styleRange);
    }

    public final synchronized void setStyleRanges(StyleRange[] styleRangeArray) {
        this.internalGetStyleRanges().clear();
        this.addStyleRanges(styleRangeArray);
    }

    public final synchronized void addStyleRanges(StyleRange[] styleRangeArray) {
        if (styleRangeArray != null) {
            for (StyleRange styleRange : styleRangeArray) {
                this.internalGetStyleRanges().add(styleRange);
            }
            this.firePropertyChange(PROPERTY_STYLE_RANGE, null, styleRangeArray);
        } else {
            this.firePropertyChange(PROPERTY_STYLE_RANGE, null, null);
        }
    }

    public final synchronized StyleRange[] getStyleRanges() {
        List list = this.internalGetStyleRanges();
        return list.toArray(new StyleRange[list.size()]);
    }

    private List internalGetStyleRanges() {
        if (this._styleRanges == null) {
            this._styleRanges = new Vector();
        }
        return this._styleRanges;
    }

    public final synchronized void clearStyleRange(StyleRange styleRange) {
        if (this.internalGetStyleRanges().remove(styleRange)) {
            this.firePropertyChange(PROPERTY_STYLE_RANGE, styleRange, null);
        }
    }

    public final synchronized void clearStyleRanges() {
        this.internalGetStyleRanges().clear();
        this.firePropertyChange(PROPERTY_STYLE_RANGE, null, null);
    }

    public final boolean isIgnoreColorSettings() {
        return this._ignoreColorSettings;
    }

    public final void setIgnoreColorSettings(boolean bl) {
        boolean bl2 = this._ignoreColorSettings;
        if (bl2 != bl) {
            this._ignoreColorSettings = bl;
            this.firePropertyChange(PROPERTY_IGNORE_COLOR_SETTINGS, bl2, bl);
        }
    }

    public final Dimension getMinimumSize() {
        return this.isLineWrap() ? new Dimension(1, 1) : super.getMinimumSize();
    }

    public final Dimension getMaximumSize() {
        return this.isLineWrap() ? new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE) : super.getMaximumSize();
    }

    public final void setPreferredWidth(int n) {
        this._preferredWidth = n;
    }

    public final int getPreferredWidth() {
        return this._preferredWidth;
    }

    public final boolean isLineWrap() {
        return this._lineWrap;
    }

    public final void setLineWrap(boolean bl) {
        this._lineWrap = bl;
    }

    public final int getRows() {
        return this._rows;
    }

    public final void setRows(int n) {
        this._rows = n;
    }

    public final int getRowGap() {
        return this._rowGap;
    }

    public final void setRowGap(int n) {
        this._rowGap = n;
    }

    public final int getMaxRows() {
        return this._maxRows;
    }

    public final void setMaxRows(int n) {
        this._maxRows = n;
    }

    public final int getMinRows() {
        return this._minRows;
    }

    public final void setMinRows(int n) {
        this._minRows = n;
    }

    public final boolean isTruncated() {
        return this._truncated;
    }

    public final void setTruncated(boolean bl) {
        this._truncated = bl;
    }
}

