/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import javax.swing.JToggleButton;

public class TristateButtonModel
extends JToggleButton.ToggleButtonModel {
    private static final long serialVersionUID = 9179129427948325126L;
    public static final int MIXED = 128;

    public final void setState(int n) {
        switch (n) {
            case 0: {
                this.setSelected(false);
                break;
            }
            case 1: {
                this.setSelected(true);
                break;
            }
            case 2: {
                this.setMixed(true);
            }
        }
    }

    public final int getState() {
        if (this.isMixed()) {
            return 2;
        }
        if (this.isSelected()) {
            return 1;
        }
        return 0;
    }

    protected final int getNextState(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return 2;
        }
        return 0;
    }

    public final void setPressed(boolean bl) {
        if (this.isPressed() == bl || !this.isEnabled()) {
            return;
        }
        if (!bl && this.isArmed()) {
            this.updateState();
        }
        this.stateMask = bl ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
        this.fireStateChanged();
        if (!this.isPressed() && this.isArmed()) {
            int n = 0;
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            if (aWTEvent instanceof InputEvent) {
                n = ((InputEvent)aWTEvent).getModifiers();
            } else if (aWTEvent instanceof ActionEvent) {
                n = ((ActionEvent)aWTEvent).getModifiers();
            }
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), n));
        }
    }

    protected final void updateState() {
        this.setState(this.getNextState(this.getState()));
    }

    public final void setSelected(boolean bl) {
        boolean bl2 = this.isMixed();
        if (bl2) {
            this.stateMask &= 0xFFFFFF7F;
            this.internalSetSelected(!this.isSelected());
        }
        super.setSelected(bl);
    }

    private final void internalSetSelected(boolean bl) {
        this.stateMask = bl ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
    }

    public final boolean isMixed() {
        return (this.stateMask & 0x80) != 0;
    }

    public final void setMixed(boolean bl) {
        if (this.isMixed() == bl) {
            return;
        }
        if (bl) {
            this.stateMask |= 0x80;
            this.stateMask |= 2;
        } else {
            this.stateMask &= 0xFFFFFF7F;
        }
        this.fireStateChanged();
    }
}

