/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import com.sun.media.jai.codec.SeekableStream;
import java.io.InputStream;

public class ForwardSeekableStream
extends SeekableStream {
    private InputStream src;
    long pointer = 0L;
    long markPos = -1L;

    public ForwardSeekableStream(InputStream inputStream) {
        this.src = inputStream;
    }

    public final int available() {
        return this.src.available();
    }

    public final boolean canSeekBackwards() {
        return false;
    }

    public final void close() {
        this.src.close();
    }

    public final long getFilePointer() {
        return this.pointer;
    }

    public final synchronized void mark(int n) {
        this.markPos = this.pointer;
        this.src.mark(n);
    }

    public final boolean markSupported() {
        return this.src.markSupported();
    }

    public final int read() {
        int n = this.src.read();
        if (n != -1) {
            ++this.pointer;
        }
        return n;
    }

    public final int read(byte[] byArray, int n, int n2) {
        int n3 = this.src.read(byArray, n, n2);
        if (n3 != -1) {
            this.pointer += (long)n3;
        }
        return n3;
    }

    public final synchronized void reset() {
        if (this.markPos != -1L) {
            this.pointer = this.markPos;
        }
        this.src.reset();
    }

    public final void seek(long l2) {
        while (l2 - this.pointer > 0L) {
            this.pointer += this.src.skip(l2 - this.pointer);
        }
    }

    public final long skip(long l2) {
        long l3 = this.src.skip(l2);
        this.pointer += l3;
        return l3;
    }
}

