/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoderImpl;
import com.sun.media.jai.codecimpl.GIFImageSource;
import com.sun.media.jai.codecimpl.JaiI18N;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;

public class GIFImageDecoder
extends ImageDecoderImpl {
    BufferedImage bufferedImage = null;

    public GIFImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        super(inputStream, imageDecodeParam);
    }

    private synchronized RenderedImage decode() {
        if (this.bufferedImage == null) {
            GIFImageSource gIFImageSource = new GIFImageSource(this.input);
            Image image = Toolkit.getDefaultToolkit().createImage(gIFImageSource);
            MediaTracker mediaTracker = new MediaTracker(new Canvas());
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(JaiI18N.getString("GIFImageDecoder0"));
            }
            if (mediaTracker.isErrorID(0)) {
                throw new RuntimeException(JaiI18N.getString("GIFImageDecoder1"));
            }
            mediaTracker.removeImage(image);
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            this.bufferedImage = new BufferedImage(n, n2, 5);
            Graphics graphics = this.bufferedImage.getGraphics();
            graphics.drawImage(image, 0, 0, null);
        }
        return this.bufferedImage;
    }

    public final RenderedImage decodeAsRenderedImage(int n) {
        if (n != 0) {
            throw new IOException(JaiI18N.getString("GIFImageDecoder2"));
        }
        return this.decode();
    }
}

