/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageEncoderImpl;
import com.sun.media.jai.codec.PNGEncodeParam;
import com.sun.media.jai.codec.PNGEncodeParam$Gray;
import com.sun.media.jai.codec.PNGEncodeParam$Palette;
import com.sun.media.jai.codec.PNGEncodeParam$RGB;
import com.sun.media.jai.codecimpl.ChunkStream;
import com.sun.media.jai.codecimpl.IDATOutputStream;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PNGImageEncoder
extends ImageEncoderImpl {
    private static final int PNG_COLOR_GRAY = 0;
    private static final int PNG_COLOR_RGB = 2;
    private static final int PNG_COLOR_PALETTE = 3;
    private static final int PNG_COLOR_GRAY_ALPHA = 4;
    private static final int PNG_COLOR_RGB_ALPHA = 6;
    private static final byte[] magic = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private PNGEncodeParam param;
    private RenderedImage image;
    private int width;
    private int height;
    private int bitDepth;
    private int bitShift;
    private int numBands;
    private int colorType;
    private int bpp;
    private boolean skipAlpha = false;
    private boolean compressGray = false;
    private boolean interlace;
    private byte[] redPalette = null;
    private byte[] greenPalette = null;
    private byte[] bluePalette = null;
    private byte[] alphaPalette = null;
    private DataOutputStream dataOutput;
    private byte[] prevRow = null;
    private byte[] currRow = null;
    private byte[][] filteredRows = null;
    private static final float[] srgbChroma = new float[]{0.3127f, 0.329f, 0.64f, 0.33f, 0.3f, 0.6f, 0.15f, 0.06f};
    private final byte[][] expandBits;

    public PNGImageEncoder(OutputStream outputStream, PNGEncodeParam pNGEncodeParam) {
        super(outputStream, pNGEncodeParam);
        byte[][] byArrayArray = new byte[5][];
        byArrayArray[0] = null;
        byte[] byArray = new byte[2];
        byArray[1] = -1;
        byArrayArray[1] = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[1] = 85;
        byArray2[2] = -86;
        byArray2[3] = -1;
        byArrayArray[2] = byArray2;
        byArrayArray[3] = null;
        byte[] byArray3 = new byte[16];
        byArray3[1] = 17;
        byArray3[2] = 34;
        byArray3[3] = 51;
        byArray3[4] = 68;
        byArray3[5] = 85;
        byArray3[6] = 102;
        byArray3[7] = 119;
        byArray3[8] = -120;
        byArray3[9] = -103;
        byArray3[10] = -86;
        byArray3[11] = -69;
        byArray3[12] = -52;
        byArray3[13] = -35;
        byArray3[14] = -18;
        byArray3[15] = -1;
        byArrayArray[4] = byArray3;
        this.expandBits = byArrayArray;
        if (pNGEncodeParam != null) {
            this.param = pNGEncodeParam;
        }
        this.dataOutput = new DataOutputStream(outputStream);
    }

    private static int clamp(int n, int n2) {
        return n > n2 ? n2 : n;
    }

    private PNGEncodeParam$Gray createGrayParam(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        PNGEncodeParam$Gray pNGEncodeParam$Gray = new PNGEncodeParam$Gray();
        int n = 0;
        int n2 = 1 << this.bitDepth;
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray[n3];
            if (by != byArray2[n3] || by != byArray3[n3] || by != this.expandBits[this.bitDepth][n3]) {
                return null;
            }
            byte by2 = byArray4[n3];
            if (by2 == 0) {
                pNGEncodeParam$Gray.setTransparentGray(n3);
                if (++n > 1) {
                    return null;
                }
            } else if (by2 != -1) {
                return null;
            }
            ++n3;
        }
        return pNGEncodeParam$Gray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void encode(RenderedImage renderedImage) {
        Object object;
        this.image = renderedImage;
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        SampleModel sampleModel = this.image.getSampleModel();
        int[] nArray = sampleModel.getSampleSize();
        this.bitDepth = -1;
        this.bitShift = 0;
        if (this.param instanceof PNGEncodeParam$Gray) {
            object = (PNGEncodeParam$Gray)this.param;
            if (((PNGEncodeParam$Gray)object).isBitDepthSet()) {
                this.bitDepth = ((PNGEncodeParam)object).getBitDepth();
            }
            if (((PNGEncodeParam$Gray)object).isBitShiftSet()) {
                this.bitShift = ((PNGEncodeParam$Gray)object).getBitShift();
            }
        }
        if (this.bitDepth == -1) {
            this.bitDepth = nArray[0];
            int n = 1;
            while (n < nArray.length) {
                if (nArray[n] != this.bitDepth) {
                    throw new RuntimeException();
                }
                ++n;
            }
            if (this.bitDepth > 2 && this.bitDepth < 4) {
                this.bitDepth = 4;
            } else if (this.bitDepth > 4 && this.bitDepth < 8) {
                this.bitDepth = 8;
            } else if (this.bitDepth > 8 && this.bitDepth < 16) {
                this.bitDepth = 16;
            } else if (this.bitDepth > 16) {
                throw new RuntimeException();
            }
        }
        this.numBands = sampleModel.getNumBands();
        this.bpp = this.numBands * (this.bitDepth == 16 ? 2 : 1);
        object = this.image.getColorModel();
        if (object instanceof IndexColorModel) {
            if (this.bitDepth < 1 || this.bitDepth > 8) {
                throw new RuntimeException();
            }
            if (sampleModel.getNumBands() != 1) {
                throw new RuntimeException();
            }
            IndexColorModel indexColorModel = (IndexColorModel)object;
            int n = indexColorModel.getMapSize();
            this.redPalette = new byte[n];
            this.greenPalette = new byte[n];
            this.bluePalette = new byte[n];
            this.alphaPalette = new byte[n];
            indexColorModel.getReds(this.redPalette);
            indexColorModel.getGreens(this.greenPalette);
            indexColorModel.getBlues(this.bluePalette);
            indexColorModel.getAlphas(this.alphaPalette);
            this.bpp = 1;
            if (this.param == null) {
                this.param = this.createGrayParam(this.redPalette, this.greenPalette, this.bluePalette, this.alphaPalette);
            }
            if (this.param == null) {
                this.param = new PNGEncodeParam$Palette();
            }
            if (this.param instanceof PNGEncodeParam$Palette) {
                PNGEncodeParam$Palette pNGEncodeParam$Palette = (PNGEncodeParam$Palette)this.param;
                if (pNGEncodeParam$Palette.isPaletteSet()) {
                    int[] nArray2 = pNGEncodeParam$Palette.getPalette();
                    n = nArray2.length / 3;
                    int n2 = 0;
                    int n3 = 0;
                    while (n3 < n) {
                        this.redPalette[n3] = (byte)nArray2[n2++];
                        this.greenPalette[n3] = (byte)nArray2[n2++];
                        this.bluePalette[n3] = (byte)nArray2[n2++];
                        this.alphaPalette[n3] = -1;
                        ++n3;
                    }
                }
                this.colorType = 3;
            } else {
                if (!(this.param instanceof PNGEncodeParam$Gray)) throw new RuntimeException();
                this.alphaPalette = null;
                this.bluePalette = null;
                this.greenPalette = null;
                this.redPalette = null;
                this.colorType = 0;
            }
        } else if (this.numBands == 1) {
            if (this.param == null) {
                this.param = new PNGEncodeParam$Gray();
            }
            this.colorType = 0;
        } else if (this.numBands == 2) {
            if (this.param == null) {
                this.param = new PNGEncodeParam$Gray();
            }
            if (this.param.isTransparencySet()) {
                this.skipAlpha = true;
                this.numBands = 1;
                if (nArray[0] == 8 && this.bitDepth < 8) {
                    this.compressGray = true;
                }
                this.bpp = this.bitDepth == 16 ? 2 : 1;
                this.colorType = 0;
            } else {
                if (this.bitDepth < 8) {
                    this.bitDepth = 8;
                }
                this.colorType = 4;
            }
        } else if (this.numBands == 3) {
            if (this.param == null) {
                this.param = new PNGEncodeParam$RGB();
            }
            this.colorType = 2;
        } else if (this.numBands == 4) {
            if (this.param == null) {
                this.param = new PNGEncodeParam$RGB();
            }
            if (this.param.isTransparencySet()) {
                this.skipAlpha = true;
                this.numBands = 3;
                this.bpp = this.bitDepth == 16 ? 6 : 3;
                this.colorType = 2;
            } else {
                this.colorType = 6;
            }
        }
        this.interlace = this.param.getInterlacing();
        this.writeMagic();
        this.writeIHDR();
        this.writeCHRM();
        this.writeGAMA();
        this.writeICCP();
        this.writeSBIT();
        this.writeSRGB();
        this.writePLTE();
        this.writeHIST();
        this.writeTRNS();
        this.writeBKGD();
        this.writePHYS();
        this.writeSPLT();
        this.writeTIME();
        this.writeTEXT();
        this.writeZTXT();
        this.writePrivateChunks();
        this.writeIDAT();
        this.writeIEND();
        this.dataOutput.flush();
        this.dataOutput.close();
    }

    private void encodePass(OutputStream outputStream, Raster raster, int n, int n2, int n3, int n4) {
        int n5 = raster.getMinX();
        int n6 = raster.getMinY();
        int n7 = raster.getWidth();
        int n8 = raster.getHeight();
        int n9 = 8 / this.bitDepth;
        int n10 = n7 * this.numBands;
        int[] nArray = new int[n10];
        int n11 = (n10 - (n *= this.numBands) + (n3 *= this.numBands) - 1) / n3;
        int n12 = n11 * this.numBands;
        if (this.bitDepth < 8) {
            n12 = (n12 + n9 - 1) / n9;
        } else if (this.bitDepth == 16) {
            n12 *= 2;
        }
        if (n12 == 0) {
            return;
        }
        this.currRow = new byte[n12 + this.bpp];
        this.prevRow = new byte[n12 + this.bpp];
        this.filteredRows = new byte[5][n12 + this.bpp];
        int n13 = (1 << this.bitDepth) - 1;
        int n14 = n6 + n2;
        while (n14 < n6 + n8) {
            int n15;
            int n16;
            int n17;
            raster.getPixels(n5, n14, n7, 1, nArray);
            if (this.compressGray) {
                n17 = 8 - this.bitDepth;
                n16 = 0;
                while (n16 < n7) {
                    int n18 = n16++;
                    nArray[n18] = nArray[n18] >> n17;
                }
            }
            n17 = this.bpp;
            n16 = 0;
            int n19 = 0;
            switch (this.bitDepth) {
                case 1: 
                case 2: 
                case 4: {
                    int n20;
                    n15 = n9 - 1;
                    int n21 = n;
                    while (n21 < n10) {
                        n20 = PNGImageEncoder.clamp(nArray[n21] >> this.bitShift, n13);
                        n19 = n19 << this.bitDepth | n20;
                        if ((n16++ & n15) == n15) {
                            this.currRow[n17++] = (byte)n19;
                            n19 = 0;
                        }
                        n21 += n3;
                    }
                    if ((n16 & n15) == 0) break;
                    this.currRow[n17++] = (byte)(n19 <<= (8 / this.bitDepth - n16) * this.bitDepth);
                    break;
                }
                case 8: {
                    int n20;
                    int n22 = n;
                    while (n22 < n10) {
                        n20 = 0;
                        while (n20 < this.numBands) {
                            this.currRow[n17++] = (byte)PNGImageEncoder.clamp(nArray[n22 + n20] >> this.bitShift, n13);
                            ++n20;
                        }
                        n22 += n3;
                    }
                    break;
                }
                case 16: {
                    int n20;
                    int n23 = n;
                    while (n23 < n10) {
                        n20 = 0;
                        while (n20 < this.numBands) {
                            int n24 = PNGImageEncoder.clamp(nArray[n23 + n20] >> this.bitShift, n13);
                            this.currRow[n17++] = (byte)(n24 >> 8);
                            this.currRow[n17++] = (byte)(n24 & 0xFF);
                            ++n20;
                        }
                        n23 += n3;
                    }
                    break;
                }
            }
            n15 = this.param.filterRow(this.currRow, this.prevRow, this.filteredRows, n12, this.bpp);
            outputStream.write(n15);
            outputStream.write(this.filteredRows[n15], this.bpp, n12);
            byte[] byArray = this.currRow;
            this.currRow = this.prevRow;
            this.prevRow = byArray;
            n14 += n4;
        }
    }

    private void writeBKGD() {
        if (this.param.isBackgroundSet()) {
            ChunkStream chunkStream = new ChunkStream("bKGD");
            switch (this.colorType) {
                case 0: 
                case 4: {
                    int n = ((PNGEncodeParam$Gray)this.param).getBackgroundGray();
                    chunkStream.writeShort(n);
                    break;
                }
                case 3: {
                    int n = ((PNGEncodeParam$Palette)this.param).getBackgroundPaletteIndex();
                    chunkStream.writeByte(n);
                    break;
                }
                case 2: 
                case 6: {
                    int[] nArray = ((PNGEncodeParam$RGB)this.param).getBackgroundRGB();
                    chunkStream.writeShort(nArray[0]);
                    chunkStream.writeShort(nArray[1]);
                    chunkStream.writeShort(nArray[2]);
                    break;
                }
            }
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writeCHRM() {
        if (this.param.isChromaticitySet() || this.param.isSRGBIntentSet()) {
            ChunkStream chunkStream = new ChunkStream("cHRM");
            float[] fArray = !this.param.isSRGBIntentSet() ? this.param.getChromaticity() : srgbChroma;
            int n = 0;
            while (n < 8) {
                chunkStream.writeInt((int)(fArray[n] * 100000.0f));
                ++n;
            }
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writeGAMA() {
        if (this.param.isGammaSet() || this.param.isSRGBIntentSet()) {
            ChunkStream chunkStream = new ChunkStream("gAMA");
            float f2 = !this.param.isSRGBIntentSet() ? this.param.getGamma() : 0.45454544f;
            chunkStream.writeInt((int)(f2 * 100000.0f));
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writeHIST() {
        if (this.param.isPaletteHistogramSet()) {
            ChunkStream chunkStream = new ChunkStream("hIST");
            int[] nArray = this.param.getPaletteHistogram();
            int n = 0;
            while (n < nArray.length) {
                chunkStream.writeShort(nArray[n]);
                ++n;
            }
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writeICCP() {
        if (this.param.isICCProfileDataSet()) {
            ChunkStream chunkStream = new ChunkStream("iCCP");
            byte[] byArray = this.param.getICCProfileData();
            chunkStream.write(byArray);
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writeIDAT() {
        IDATOutputStream iDATOutputStream = new IDATOutputStream(this.dataOutput, 8192);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)iDATOutputStream, new Deflater(9));
        Raster raster = this.image.getData();
        if (this.skipAlpha) {
            int n = raster.getNumBands() - 1;
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = n2;
                ++n2;
            }
            raster = raster.createChild(0, 0, raster.getWidth(), raster.getHeight(), 0, 0, nArray);
        }
        if (this.interlace) {
            this.encodePass(deflaterOutputStream, raster, 0, 0, 8, 8);
            this.encodePass(deflaterOutputStream, raster, 4, 0, 8, 8);
            this.encodePass(deflaterOutputStream, raster, 0, 4, 4, 8);
            this.encodePass(deflaterOutputStream, raster, 2, 0, 4, 4);
            this.encodePass(deflaterOutputStream, raster, 0, 2, 2, 4);
            this.encodePass(deflaterOutputStream, raster, 1, 0, 2, 2);
            this.encodePass(deflaterOutputStream, raster, 0, 1, 1, 2);
        } else {
            this.encodePass(deflaterOutputStream, raster, 0, 0, 1, 1);
        }
        deflaterOutputStream.finish();
        iDATOutputStream.flush();
    }

    private void writeIEND() {
        ChunkStream chunkStream = new ChunkStream("IEND");
        chunkStream.writeToStream(this.dataOutput);
    }

    private void writeIHDR() {
        ChunkStream chunkStream = new ChunkStream("IHDR");
        chunkStream.writeInt(this.width);
        chunkStream.writeInt(this.height);
        chunkStream.writeByte((byte)this.bitDepth);
        chunkStream.writeByte((byte)this.colorType);
        chunkStream.writeByte(0);
        chunkStream.writeByte(0);
        chunkStream.writeByte(this.interlace ? 1 : 0);
        chunkStream.writeToStream(this.dataOutput);
    }

    private void writeMagic() {
        this.dataOutput.write(magic);
    }

    private void writePHYS() {
        if (this.param.isPhysicalDimensionSet()) {
            ChunkStream chunkStream = new ChunkStream("pHYs");
            int[] nArray = this.param.getPhysicalDimension();
            chunkStream.writeInt(nArray[0]);
            chunkStream.writeInt(nArray[1]);
            chunkStream.writeByte((byte)nArray[2]);
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writePLTE() {
        if (this.redPalette == null) {
            return;
        }
        ChunkStream chunkStream = new ChunkStream("PLTE");
        int n = 0;
        while (n < this.redPalette.length) {
            chunkStream.writeByte(this.redPalette[n]);
            chunkStream.writeByte(this.greenPalette[n]);
            chunkStream.writeByte(this.bluePalette[n]);
            ++n;
        }
        chunkStream.writeToStream(this.dataOutput);
    }

    private void writePrivateChunks() {
        int n = this.param.getNumPrivateChunks();
        int n2 = 0;
        while (n2 < n) {
            String string = this.param.getPrivateChunkType(n2);
            char c2 = string.charAt(3);
            byte[] byArray = this.param.getPrivateChunkData(n2);
            ChunkStream chunkStream = new ChunkStream(string);
            chunkStream.write(byArray);
            chunkStream.writeToStream(this.dataOutput);
            ++n2;
        }
    }

    private void writeSBIT() {
        if (this.param.isSignificantBitsSet()) {
            ChunkStream chunkStream = new ChunkStream("sBIT");
            int[] nArray = this.param.getSignificantBits();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                chunkStream.writeByte(nArray[n2]);
                ++n2;
            }
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writeSPLT() {
        if (this.param.isSuggestedPaletteSet()) {
            ChunkStream chunkStream = new ChunkStream("sPLT");
            System.out.println("sPLT not supported yet.");
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writeSRGB() {
        if (this.param.isSRGBIntentSet()) {
            ChunkStream chunkStream = new ChunkStream("sRGB");
            int n = this.param.getSRGBIntent();
            chunkStream.write(n);
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writeTEXT() {
        if (this.param.isTextSet()) {
            String[] stringArray = this.param.getText();
            int n = 0;
            while (n < stringArray.length / 2) {
                byte[] byArray = stringArray[2 * n].getBytes();
                byte[] byArray2 = stringArray[2 * n + 1].getBytes();
                ChunkStream chunkStream = new ChunkStream("tEXt");
                chunkStream.write(byArray, 0, Math.min(byArray.length, 79));
                chunkStream.write(0);
                chunkStream.write(byArray2);
                chunkStream.writeToStream(this.dataOutput);
                ++n;
            }
        }
    }

    private void writeTIME() {
        if (this.param.isModificationTimeSet()) {
            ChunkStream chunkStream = new ChunkStream("tIME");
            Date date = this.param.getModificationTime();
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            gregorianCalendar.setTime(date);
            int n = gregorianCalendar.get(1);
            int n2 = gregorianCalendar.get(2);
            int n3 = gregorianCalendar.get(5);
            int n4 = gregorianCalendar.get(11);
            int n5 = gregorianCalendar.get(12);
            int n6 = gregorianCalendar.get(13);
            chunkStream.writeShort(n);
            chunkStream.writeByte(n2 + 1);
            chunkStream.writeByte(n3);
            chunkStream.writeByte(n4);
            chunkStream.writeByte(n5);
            chunkStream.writeByte(n6);
            chunkStream.writeToStream(this.dataOutput);
        }
    }

    private void writeTRNS() {
        if (this.param.isTransparencySet() && this.colorType != 4 && this.colorType != 6) {
            ChunkStream chunkStream = new ChunkStream("tRNS");
            if (this.param instanceof PNGEncodeParam$Palette) {
                byte[] byArray = ((PNGEncodeParam$Palette)this.param).getPaletteTransparency();
                int n = 0;
                while (n < byArray.length) {
                    chunkStream.writeByte(byArray[n]);
                    ++n;
                }
            } else if (this.param instanceof PNGEncodeParam$Gray) {
                int n = ((PNGEncodeParam$Gray)this.param).getTransparentGray();
                chunkStream.writeShort(n);
            } else if (this.param instanceof PNGEncodeParam$RGB) {
                int[] nArray = ((PNGEncodeParam$RGB)this.param).getTransparentRGB();
                chunkStream.writeShort(nArray[0]);
                chunkStream.writeShort(nArray[1]);
                chunkStream.writeShort(nArray[2]);
            }
            chunkStream.writeToStream(this.dataOutput);
        } else if (this.colorType == 3) {
            int n;
            int n2 = n = Math.min(255, this.alphaPalette.length - 1);
            while (n2 >= 0) {
                if (this.alphaPalette[n2] != -1) break;
                --n2;
            }
            if (n2 >= 0) {
                ChunkStream chunkStream = new ChunkStream("tRNS");
                int n3 = 0;
                while (n3 <= n2) {
                    chunkStream.writeByte(this.alphaPalette[n3]);
                    ++n3;
                }
                chunkStream.writeToStream(this.dataOutput);
            }
        }
    }

    private void writeZTXT() {
        if (this.param.isCompressedTextSet()) {
            String[] stringArray = this.param.getCompressedText();
            int n = 0;
            while (n < stringArray.length / 2) {
                byte[] byArray = stringArray[2 * n].getBytes();
                byte[] byArray2 = stringArray[2 * n + 1].getBytes();
                ChunkStream chunkStream = new ChunkStream("zTXt");
                chunkStream.write(byArray, 0, Math.min(byArray.length, 79));
                chunkStream.write(0);
                chunkStream.write(0);
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(chunkStream);
                deflaterOutputStream.write(byArray2);
                deflaterOutputStream.finish();
                chunkStream.writeToStream(this.dataOutput);
                ++n;
            }
        }
    }
}

