/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ForwardSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.PNMEncodeParam;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.PNMImageDecoder;
import com.sun.media.jai.codecimpl.PNMImageEncoder;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class PNMCodec
extends ImageCodec {
    static Class class$com$sun$media$jai$codec$PNMEncodeParam;
    static Class class$java$lang$Object;

    public final boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getTransferType();
        if (n == 4 || n == 5) {
            return false;
        }
        int n2 = sampleModel.getNumBands();
        return n2 == 1 || n2 == 3;
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected final ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new PNMImageDecoder(seekableStream, null);
    }

    protected final ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        return new PNMImageDecoder(new ForwardSeekableStream(inputStream), null);
    }

    protected final ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        PNMEncodeParam pNMEncodeParam = null;
        if (imageEncodeParam != null) {
            pNMEncodeParam = (PNMEncodeParam)imageEncodeParam;
        }
        return new PNMImageEncoder(outputStream, pNMEncodeParam);
    }

    public final Class getDecodeParamClass() {
        return class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = PNMCodec.class$("java.lang.Object"));
    }

    public final Class getEncodeParamClass() {
        return class$com$sun$media$jai$codec$PNMEncodeParam != null ? class$com$sun$media$jai$codec$PNMEncodeParam : (class$com$sun$media$jai$codec$PNMEncodeParam = PNMCodec.class$("com.sun.media.jai.codec.PNMEncodeParam"));
    }

    public final String getFormatName() {
        return "pnm";
    }

    public final int getNumHeaderBytes() {
        return 2;
    }

    public final boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == 80 && byArray[1] >= 49 && byArray[1] <= 54;
    }
}

