/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.util.MathJAI;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterFactory;
import javax.media.jai.TileCache;
import javax.media.jai.UntiledOpImage;
import javax.media.jai.operator.DFTDescriptor;
import mediaLib.mediaLibImage;
import mediaLibwrapper.Image;

final class MlibDFTOpImage
extends UntiledOpImage {
    private int DFTMode;

    public MlibDFTOpImage(RenderedImage renderedImage, TileCache tileCache, ImageLayout imageLayout, Integer n, boolean bl, Integer n2) {
        super(renderedImage, tileCache, MlibDFTOpImage.layoutHelper(imageLayout, renderedImage, n));
        if (n2.equals(DFTDescriptor.SCALING_NONE)) {
            this.DFTMode = bl ? 0 : 3;
        } else if (n2.equals(DFTDescriptor.SCALING_UNITARY)) {
            this.DFTMode = bl ? 2 : 5;
        } else if (n2.equals(DFTDescriptor.SCALING_DIMENSIONS)) {
            this.DFTMode = bl ? 1 : 4;
        } else {
            throw new RuntimeException(JaiI18N.getString("MlibDFTOpImage1"));
        }
    }

    protected final void computeImage(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        int n = MediaLibAccessor.findCompatibleTag(new Raster[]{raster}, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, this.mapDestRect(rectangle, 0), n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        int n2 = 0;
        while (n2 < mediaLibImageArray2.length) {
            Image.FourierTransform((mediaLibImage)mediaLibImageArray2[n2], (mediaLibImage)mediaLibImageArray[n2], (int)this.DFTMode);
            ++n2;
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }

    public static final boolean isAcceptableSampleModel(SampleModel sampleModel) {
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return true;
        }
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
        int[] nArray = componentSampleModel.getBandOffsets();
        return nArray.length == 2 && nArray[1] == nArray[0] + 1;
    }

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, Integer n) {
        int n2;
        int n3;
        int n4;
        boolean bl = n.equals(DFTDescriptor.REAL_TO_COMPLEX) ^ true;
        boolean bl2 = n.equals(DFTDescriptor.COMPLEX_TO_REAL) ^ true;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n5 = sampleModel.getNumBands();
        if (bl && n5 != 2 || !bl && n5 != 1) {
            throw new RuntimeException(JaiI18N.getString("MlibDFTOpImage0"));
        }
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout(renderedImage) : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX(renderedImage.getMinX());
        imageLayout2.setMinY(renderedImage.getMinY());
        int n6 = imageLayout2.getWidth(renderedImage);
        int n7 = imageLayout2.getHeight(renderedImage);
        if (n6 == 1 && n7 == 1) {
            n4 = 1;
            n3 = 1;
        } else if (n6 == 1 && n7 > 1) {
            n3 = 1;
            n4 = MathJAI.nextPositivePowerOf2(n7);
        } else if (n6 > 1 && n7 == 1) {
            n3 = MathJAI.nextPositivePowerOf2(n6);
            n4 = 1;
        } else {
            n3 = MathJAI.nextPositivePowerOf2(n6);
            n4 = MathJAI.nextPositivePowerOf2(n7);
        }
        imageLayout2.setWidth(n3);
        imageLayout2.setHeight(n4);
        boolean bl3 = false;
        int n8 = n5;
        if (bl && !bl2) {
            n8 /= 2;
        } else if (!bl && bl2) {
            n8 *= 2;
        }
        SampleModel sampleModel2 = imageLayout2.getSampleModel(renderedImage);
        int n9 = sampleModel2.getNumBands();
        if (n9 != n8) {
            n9 = n8;
            bl3 = true;
        }
        if ((n2 = sampleModel2.getTransferType()) != 4 && n2 != 5) {
            n2 = 4;
            bl3 = true;
        }
        if (bl3) {
            int[] nArray = new int[n9];
            int n10 = 0;
            while (n10 < n9) {
                nArray[n10] = n10;
                ++n10;
            }
            int n11 = n3 * n9;
            sampleModel2 = RasterFactory.createPixelInterleavedSampleModel(n2, n3, n4, n9, n11, nArray);
            imageLayout2.setSampleModel(sampleModel2);
        }
        return imageLayout2;
    }
}

