/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibUtils;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.TileCache;
import mediaLib.mediaLibImage;
import mediaLibwrapper.Image;

final class MlibDivideIntoConstOpImage
extends PointOpImage {
    private double[] constants;

    public MlibDivideIntoConstOpImage(RenderedImage renderedImage, TileCache tileCache, ImageLayout imageLayout, double[] dArray) {
        super(renderedImage, tileCache, imageLayout, true);
        this.constants = MlibUtils.initConstants(dArray, this.getSampleModel().getNumBands());
        this.permitInPlaceOperation();
    }

    protected final void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 2: 
            case 3: {
                int n2 = 0;
                while (n2 < mediaLibImageArray2.length) {
                    double[] dArray = mediaLibAccessor2.getDoubleParameters(n2, this.constants);
                    Image.ConstDiv((mediaLibImage)mediaLibImageArray2[n2], (mediaLibImage)mediaLibImageArray[n2], (double[])dArray);
                    ++n2;
                }
                break;
            }
            case 4: 
            case 5: {
                int n3 = 0;
                while (n3 < mediaLibImageArray2.length) {
                    double[] dArray = mediaLibAccessor2.getDoubleParameters(n3, this.constants);
                    Image.ConstDiv_Fp((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (double[])dArray);
                    ++n3;
                }
                break;
            }
            default: {
                String string = this.getClass().getName();
                throw new RuntimeException(String.valueOf(string) + JaiI18N.getString("MlibUshort"));
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

