/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.TileCache;
import mediaLib.mediaLibImage;
import mediaLibwrapper.Image;

final class MlibLookupOpImage
extends PointOpImage {
    private LookupTableJAI table;

    public MlibLookupOpImage(RenderedImage renderedImage, TileCache tileCache, ImageLayout imageLayout, LookupTableJAI lookupTableJAI) {
        super(renderedImage, tileCache, imageLayout, true);
        this.table = lookupTableJAI;
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (this.sampleModel.getTransferType() != lookupTableJAI.getDataType() || this.sampleModel.getNumBands() != lookupTableJAI.getDestNumBands(sampleModel.getNumBands())) {
            this.sampleModel = lookupTableJAI.getDestSampleModel(sampleModel, this.tileWidth, this.tileHeight);
            this.colorModel = PlanarImage.createColorModel(this.sampleModel);
        }
        this.permitInPlaceOperation();
    }

    protected final void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Object object;
        mediaLibImage[] mediaLibImageArray;
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n = MediaLibAccessor.findCompatibleTag(null, raster);
        int n2 = MediaLibAccessor.findCompatibleTag(null, writableRaster);
        SampleModel sampleModel = raster.getSampleModel();
        if (sampleModel.getNumBands() > 1) {
            int n3 = n & 0x80;
            int n4 = n2 & 0x80;
            int n5 = n & 0x7F;
            int n6 = n2 & 0x7F;
            if (!(n3 == 0 && n4 == 0 && MediaLibAccessor.isPixelSequential(sampleModel) && MediaLibAccessor.isPixelSequential(this.sampleModel) && MediaLibAccessor.hasMatchingBandOffsets((ComponentSampleModel)sampleModel, (ComponentSampleModel)this.sampleModel))) {
                n = n5 | 0x80;
                n2 = n6 | 0x80;
            }
        }
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n2);
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor.getMediaLibImages();
        if (mediaLibImageArray2.length < (mediaLibImageArray = mediaLibAccessor2.getMediaLibImages()).length) {
            object = mediaLibImageArray2[0];
            mediaLibImageArray2 = new mediaLibImage[mediaLibImageArray.length];
            int n7 = 0;
            while (n7 < mediaLibImageArray.length) {
                mediaLibImageArray2[n7] = (mediaLibImage)object;
                ++n7;
            }
        }
        object = mediaLibAccessor2.getBandOffsets();
        Object object2 = this.getTableData((int[])object);
        int[] nArray = this.getTableOffsets((int[])object);
        int n8 = 0;
        while (n8 < mediaLibImageArray.length) {
            Image.LookUp2((mediaLibImage)mediaLibImageArray[n8], (mediaLibImage)mediaLibImageArray2[n8], (Object)object2, (int[])nArray);
            ++n8;
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.copyDataToRaster();
        }
    }

    private Object getTableData(int[] nArray) {
        int n = this.table.getNumBands();
        int n2 = this.sampleModel.getNumBands();
        Object object = null;
        switch (this.table.getDataType()) {
            case 0: {
                byte[][] byArray = new byte[n2][];
                if (n < n2) {
                    int n3 = 0;
                    while (n3 < n2) {
                        byArray[n3] = this.table.getByteData(0);
                        ++n3;
                    }
                } else {
                    int n4 = 0;
                    while (n4 < n2) {
                        byArray[n4] = this.table.getByteData(nArray[n4]);
                        ++n4;
                    }
                }
                object = byArray;
                break;
            }
            case 2: {
                short[][] sArray = new short[n2][];
                if (n < n2) {
                    int n5 = 0;
                    while (n5 < n2) {
                        sArray[n5] = this.table.getShortData(0);
                        ++n5;
                    }
                } else {
                    int n6 = 0;
                    while (n6 < n2) {
                        sArray[n6] = this.table.getShortData(nArray[n6]);
                        ++n6;
                    }
                }
                object = sArray;
                break;
            }
            case 3: {
                int[][] nArray2 = new int[n2][];
                if (n < n2) {
                    int n7 = 0;
                    while (n7 < n2) {
                        nArray2[n7] = this.table.getIntData(0);
                        ++n7;
                    }
                } else {
                    int n8 = 0;
                    while (n8 < n2) {
                        nArray2[n8] = this.table.getIntData(nArray[n8]);
                        ++n8;
                    }
                }
                object = nArray2;
                break;
            }
            case 4: {
                float[][] fArray = new float[n2][];
                if (n < n2) {
                    int n9 = 0;
                    while (n9 < n2) {
                        fArray[n9] = this.table.getFloatData(0);
                        ++n9;
                    }
                } else {
                    int n10 = 0;
                    while (n10 < n2) {
                        fArray[n10] = this.table.getFloatData(nArray[n10]);
                        ++n10;
                    }
                }
                object = fArray;
                break;
            }
            case 5: {
                double[][] dArray = new double[n2][];
                if (n < n2) {
                    int n11 = 0;
                    while (n11 < n2) {
                        dArray[n11] = this.table.getDoubleData(0);
                        ++n11;
                    }
                } else {
                    int n12 = 0;
                    while (n12 < n2) {
                        dArray[n12] = this.table.getDoubleData(nArray[n12]);
                        ++n12;
                    }
                }
                object = dArray;
                break;
            }
        }
        return object;
    }

    private int[] getTableOffsets(int[] nArray) {
        int n = this.table.getNumBands();
        int n2 = this.sampleModel.getNumBands();
        int[] nArray2 = new int[n2];
        if (n < n2) {
            int n3 = 0;
            while (n3 < n2) {
                nArray2[n3] = this.table.getOffset(0);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                nArray2[n4] = this.table.getOffset(nArray[n4]);
                ++n4;
            }
        }
        return nArray2;
    }
}

