/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibScaleBicubicOpImage;
import com.sun.media.jai.mlib.MlibScaleBilinearOpImage;
import com.sun.media.jai.mlib.MlibScaleNearestOpImage;
import com.sun.media.jai.mlib.MlibScaleTableOpImage;
import com.sun.media.jai.mlib.MlibTranslateIntOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.InterpolationTable;
import javax.media.jai.TileCache;

public class MlibTranslateRIF
implements RenderedImageFactory {
    private static final float TOLERANCE = 0.01f;

    public final RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        float f2 = parameterBlock.getFloatParameter(0);
        float f3 = parameterBlock.getFloatParameter(1);
        Interpolation interpolation = (Interpolation)parameterBlock.getObjectParameter(2);
        if (Math.abs(f2 - (float)((int)f2)) < 0.01f && Math.abs(f3 - (float)((int)f3)) < 0.01f) {
            return new MlibTranslateIntOpImage(renderedImage, (int)f2, (int)f3);
        }
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        TileCache tileCache = RIFUtil.getTileCacheHint(renderingHints);
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout)) {
            return null;
        }
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        float f4 = 1.0f;
        float f5 = 1.0f;
        if (interpolation instanceof InterpolationNearest) {
            return new MlibScaleNearestOpImage(renderedImage, borderExtender, tileCache, imageLayout, f4, f5, f2, f3, interpolation);
        }
        if (interpolation instanceof InterpolationBilinear) {
            return new MlibScaleBilinearOpImage(renderedImage, borderExtender, tileCache, imageLayout, f4, f5, f2, f3, interpolation);
        }
        if (interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2) {
            return new MlibScaleBicubicOpImage(renderedImage, borderExtender, tileCache, imageLayout, f4, f5, f2, f3, interpolation);
        }
        if (interpolation instanceof InterpolationTable) {
            return new MlibScaleTableOpImage(renderedImage, borderExtender, tileCache, imageLayout, f4, f5, f2, f3, interpolation);
        }
        return null;
    }
}

