/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.TileCache;

final class ConvolveOpImage
extends AreaOpImage {
    protected KernelJAI kernel;
    private int kw;
    private int kh;
    private int kx;
    private int ky;

    public ConvolveOpImage(RenderedImage renderedImage, BorderExtender borderExtender, TileCache tileCache, ImageLayout imageLayout, KernelJAI kernelJAI) {
        super(renderedImage, borderExtender, tileCache, imageLayout, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding(), true);
        this.kernel = kernelJAI;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.kx = kernelJAI.getXOrigin();
        this.ky = kernelJAI.getYOrigin();
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n4 = this.kernel.getWidth();
        int n5 = this.kernel.getHeight();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = 0;
        while (n10 < n3) {
            byte[] byArray3 = byArray[n10];
            byte[] byArray4 = byArray2[n10];
            int n11 = nArray2[n10];
            int n12 = nArray[n10];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n) {
                    int n17;
                    float f2 = 0.5f;
                    int n18 = 0;
                    int n19 = n14;
                    int n20 = 0;
                    while (n20 < n5) {
                        n17 = n19;
                        int n21 = 0;
                        while (n21 < n4) {
                            f2 += (float)(byArray4[n17] & 0xFF) * fArray[n18 + n21];
                            n17 += n8;
                            ++n21;
                        }
                        n18 += n4;
                        n19 += n9;
                        ++n20;
                    }
                    n17 = (int)f2;
                    if (n17 < 0) {
                        n17 = 0;
                    } else if (n17 > 255) {
                        n17 = 255;
                    }
                    byArray3[n15] = (byte)n17;
                    n14 += n8;
                    n15 += n6;
                    ++n16;
                }
                n11 += n9;
                n12 += n7;
                ++n13;
            }
            ++n10;
        }
    }

    protected final void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2);
                break;
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n4 = this.kernel.getWidth();
        int n5 = this.kernel.getHeight();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = 0;
        while (n10 < n3) {
            double[] dArray3 = dArray[n10];
            double[] dArray4 = dArray2[n10];
            int n11 = nArray2[n10];
            int n12 = nArray[n10];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n) {
                    double d2 = 0.5;
                    int n17 = 0;
                    int n18 = n14;
                    int n19 = 0;
                    while (n19 < n5) {
                        int n20 = n18;
                        int n21 = 0;
                        while (n21 < n4) {
                            d2 += dArray4[n20] * (double)fArray[n17 + n21];
                            n20 += n8;
                            ++n21;
                        }
                        n17 += n4;
                        n18 += n9;
                        ++n19;
                    }
                    dArray3[n15] = d2;
                    n14 += n8;
                    n15 += n6;
                    ++n16;
                }
                n11 += n9;
                n12 += n7;
                ++n13;
            }
            ++n10;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n4 = this.kernel.getWidth();
        int n5 = this.kernel.getHeight();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        float[][] fArray3 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = 0;
        while (n10 < n3) {
            float[] fArray4 = fArray2[n10];
            float[] fArray5 = fArray3[n10];
            int n11 = nArray2[n10];
            int n12 = nArray[n10];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n) {
                    float f2 = 0.0f;
                    int n17 = 0;
                    int n18 = n14;
                    int n19 = 0;
                    while (n19 < n5) {
                        int n20 = n18;
                        int n21 = 0;
                        while (n21 < n4) {
                            f2 += fArray5[n20] * fArray[n17 + n21];
                            n20 += n8;
                            ++n21;
                        }
                        n17 += n4;
                        n18 += n9;
                        ++n19;
                    }
                    fArray4[n15] = f2;
                    n14 += n8;
                    n15 += n6;
                    ++n16;
                }
                n11 += n9;
                n12 += n7;
                ++n13;
            }
            ++n10;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n4 = this.kernel.getWidth();
        int n5 = this.kernel.getHeight();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = 0;
        while (n10 < n3) {
            int[] nArray5 = nArray[n10];
            int[] nArray6 = nArray3[n10];
            int n11 = nArray4[n10];
            int n12 = nArray2[n10];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n) {
                    float f2 = 0.5f;
                    int n17 = 0;
                    int n18 = n14;
                    int n19 = 0;
                    while (n19 < n5) {
                        int n20 = n18;
                        int n21 = 0;
                        while (n21 < n4) {
                            f2 += (float)nArray6[n20] * fArray[n17 + n21];
                            n20 += n8;
                            ++n21;
                        }
                        n17 += n4;
                        n18 += n9;
                        ++n19;
                    }
                    nArray5[n15] = (int)f2;
                    n14 += n8;
                    n15 += n6;
                    ++n16;
                }
                n11 += n9;
                n12 += n7;
                ++n13;
            }
            ++n10;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n4 = this.kernel.getWidth();
        int n5 = this.kernel.getHeight();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = 0;
        while (n10 < n3) {
            short[] sArray3 = sArray[n10];
            short[] sArray4 = sArray2[n10];
            int n11 = nArray2[n10];
            int n12 = nArray[n10];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n) {
                    int n17;
                    float f2 = 0.5f;
                    int n18 = 0;
                    int n19 = n14;
                    int n20 = 0;
                    while (n20 < n5) {
                        n17 = n19;
                        int n21 = 0;
                        while (n21 < n4) {
                            f2 += (float)sArray4[n17] * fArray[n18 + n21];
                            n17 += n8;
                            ++n21;
                        }
                        n18 += n4;
                        n19 += n9;
                        ++n20;
                    }
                    n17 = (int)f2;
                    if (n17 < Short.MIN_VALUE) {
                        n17 = Short.MIN_VALUE;
                    } else if (n17 > Short.MAX_VALUE) {
                        n17 = Short.MAX_VALUE;
                    }
                    sArray3[n15] = (short)n17;
                    n14 += n8;
                    n15 += n6;
                    ++n16;
                }
                n11 += n9;
                n12 += n7;
                ++n13;
            }
            ++n10;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n4 = this.kernel.getWidth();
        int n5 = this.kernel.getHeight();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = 0;
        while (n10 < n3) {
            short[] sArray3 = sArray[n10];
            short[] sArray4 = sArray2[n10];
            int n11 = nArray2[n10];
            int n12 = nArray[n10];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                int n16 = 0;
                while (n16 < n) {
                    int n17;
                    float f2 = 0.5f;
                    int n18 = 0;
                    int n19 = n14;
                    int n20 = 0;
                    while (n20 < n5) {
                        n17 = n19;
                        int n21 = 0;
                        while (n21 < n4) {
                            f2 += (float)(sArray4[n17] & 0xFFFF) * fArray[n18 + n21];
                            n17 += n8;
                            ++n21;
                        }
                        n18 += n4;
                        n19 += n9;
                        ++n20;
                    }
                    n17 = (int)f2;
                    if (n17 < 0) {
                        n17 = 0;
                    } else if (n17 > 65535) {
                        n17 = 65535;
                    }
                    sArray3[n15] = (short)n17;
                    n14 += n8;
                    n15 += n6;
                    ++n16;
                }
                n11 += n9;
                n12 += n7;
                ++n13;
            }
            ++n10;
        }
    }
}

