/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.TileCache;

public class IIPResolutionOpImage
extends OpImage {
    private static final int TILE_SIZE = 64;
    private static final int TILE_BLOCK_WIDTH = 8;
    private static final int TILE_BLOCK_HEIGHT = 2;
    private static final char BLANK = ' ';
    private static final char COLON = ':';
    private static final char SLASH = '/';
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final int CS_COLORLESS = 0;
    private static final int CS_MONOCHROME = 1;
    private static final int CS_PHOTOYCC = 2;
    private static final int CS_NIFRGB = 3;
    private static final int CS_PLANE_ALPHA = 32766;
    private static final int TILE_UNCOMPRESSED = 0;
    private static final int TILE_SINGLE_COLOR = 1;
    private static final int TILE_JPEG = 2;
    private static final int TILE_INVALID = -1;
    private String URLString;
    private int resolution;
    private int subImage;
    private int colorSpaceType;
    private boolean hasAlpha;
    private boolean isAlphaPremultilpied;
    private int minTileX;
    private int minTileY;
    private int numXTiles;
    private JPEGDecodeParam[] decodeParamCache = new JPEGDecodeParam[255];
    private boolean arePropertiesInitialized = false;
    private int tileBlockWidth = 8;
    private int tileBlockHeight = 2;

    public IIPResolutionOpImage(TileCache tileCache, String string, int n, int n2) {
        super((Vector)null, (BorderExtender[])null, tileCache, IIPResolutionOpImage.layoutHelper(string, n, n2), false);
        Object object;
        this.URLString = string;
        this.subImage = n2;
        String[] stringArray = new String[]{"OBJ=Resolution-number"};
        InputStream inputStream = this.postCommands(stringArray);
        String string2 = null;
        while ((string2 = IIPResolutionOpImage.getLabel(inputStream)) != null) {
            if (string2.equals("resolution-number")) {
                object = IIPResolutionOpImage.getDataAsString(inputStream, false);
                int n3 = Integer.valueOf((String)object);
                if (n < 0) {
                    this.resolution = 0;
                    continue;
                }
                if (n >= n3) {
                    this.resolution = n3 - 1;
                    continue;
                }
                this.resolution = n;
                continue;
            }
            IIPResolutionOpImage.checkError(string2, inputStream, true);
        }
        this.endResponse(inputStream);
        object = this.colorModel.getColorSpace();
        this.colorSpaceType = ((ColorSpace)object).isCS_sRGB() ? 3 : (object.equals(ColorSpace.getInstance(1003)) ? 1 : 2);
        this.hasAlpha = this.colorModel.hasAlpha();
        this.isAlphaPremultilpied = this.colorModel.isAlphaPremultiplied();
        this.minTileX = this.getMinTileX();
        this.minTileY = this.getMinTileY();
        this.numXTiles = this.getNumXTiles();
    }

    /*
     * Unable to fully structure code
     */
    private static final void YCbCrToNIFRGB(Raster var0) {
        block2: {
            var1_1 = ((DataBufferByte)var0.getDataBuffer()).getData();
            var2_2 = 0;
            var3_3 = var1_1.length;
            var4_4 = 255;
            var5_5 = 65280;
            if (var0.getSampleModel().getNumBands() != 3) ** GOTO lbl35
            while (var2_2 < var3_3) {
                var6_6 = var1_1[var2_2] & 255;
                var7_8 = var1_1[var2_2 + 1] & 255;
                var8_10 = var1_1[var2_2 + 2] & 255;
                var9_12 = (int)(var6_6 + 1.402f * var8_10 - 178.255f);
                var10_14 = (int)(var6_6 - 0.34414f * var7_8 - 0.71414f * var8_10 + 135.4307f);
                var11_16 = (int)(var6_6 + 1.772f * var7_8 - 225.43f);
                var12_18 = var9_12 >> 5 & 24;
                var1_1[var2_2++] = (byte)((var9_12 & var4_4 >> var12_18 | var5_5 >> var12_18) & 255);
                var12_18 = var10_14 >> 5 & 24;
                var1_1[var2_2++] = (byte)((var10_14 & var4_4 >> var12_18 | var5_5 >> var12_18) & 255);
                var12_18 = var11_16 >> 5 & 24;
                var1_1[var2_2++] = (byte)((var11_16 & var4_4 >> var12_18 | var5_5 >> var12_18) & 255);
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var6_7 = var1_1[var2_2] & 255;
                var7_9 = var1_1[var2_2 + 1] & 255;
                var8_11 = var1_1[var2_2 + 2] & 255;
                var9_13 = (int)(-var6_7 - 1.402f * var8_11 - 433.255f);
                var10_15 = (int)(-var6_7 + 0.34414f * var7_9 + 0.71414f * var8_11 + 119.5693f);
                var11_17 = (int)(-var6_7 - 1.772f * var7_9 - 480.43f);
                var12_19 = var9_13 >> 5 & 24;
                var1_1[var2_2++] = (byte)((var9_13 & var4_4 >> var12_19 | var5_5 >> var12_19) & 255);
                var12_19 = var10_15 >> 5 & 24;
                var1_1[var2_2++] = (byte)((var10_15 & var4_4 >> var12_19 | var5_5 >> var12_19) & 255);
                var12_19 = var11_17 >> 5 & 24;
                var1_1[var2_2++] = (byte)((var11_17 & var4_4 >> var12_19 | var5_5 >> var12_19) & 255);
                ++var2_2;
lbl35:
                // 2 sources

                ** while (var2_2 < var3_3)
            }
        }
    }

    private static InputStream checkError(String string, InputStream inputStream, boolean bl) {
        if (string.equals("error")) {
            int n = Integer.valueOf(IIPResolutionOpImage.getLabel(inputStream));
            byte[] byArray = new byte[n];
            try {
                inputStream.read(byArray);
            }
            catch (Exception exception) {
                throw new RuntimeException(String.valueOf(String.valueOf(exception.getClass())) + " " + exception.getMessage());
            }
            String string2 = new String(byArray);
            if (bl) {
                IIPResolutionOpImage.throwIIPException(string2);
            } else {
                IIPResolutionOpImage.printIIPException(string2);
            }
        } else if (string.startsWith("iip")) {
            String string3 = IIPResolutionOpImage.getDataAsString(inputStream, false);
        }
        return inputStream;
    }

    private static void closeStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
    }

    public final Raster computeTile(int n, int n2) {
        Raster raster = null;
        if ((n - this.minTileX) % this.tileBlockWidth == 0 && (n2 - this.minTileY) % this.tileBlockHeight == 0) {
            int n3;
            int n4 = n + this.tileBlockWidth - 1;
            if (n4 > this.getMaxTileX()) {
                n4 = this.getMaxTileX();
            }
            if ((n3 = n2 + this.tileBlockHeight - 1) > this.getMaxTileY()) {
                n3 = this.getMaxTileY();
            }
            raster = this.getTileBlock(n, n2, n4, n3);
        } else {
            raster = this.getTileFromCache(n, n2);
            if (raster == null) {
                raster = this.getTileBlock(n, n2, n, n2);
            }
        }
        return raster;
    }

    private void endResponse(InputStream inputStream) {
        IIPResolutionOpImage.closeStream(inputStream);
    }

    protected final void finalize() {
        super.finalize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void flushData(InputStream inputStream, boolean bl) {
        if (bl) {
            try {
                int n = IIPResolutionOpImage.getLength(inputStream);
                long l2 = inputStream.skip(n);
                if (l2 != (long)n) return;
                inputStream.read();
                inputStream.read();
                return;
            }
            catch (Exception exception) {
                throw new RuntimeException(String.valueOf(String.valueOf(exception.getClass())) + " " + exception.getMessage());
            }
        }
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                if ((char)(0xFF & n) != '\r') continue;
                inputStream.read();
                return;
            }
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(String.valueOf(String.valueOf(exception.getClass())) + " " + exception.getMessage());
        }
    }

    private static String formatIIPErrorMessage(String string) {
        return new String(String.valueOf(JaiI18N.getString("IIPResolutionOpImage0")) + " " + string);
    }

    private static byte[] getDataAsByteArray(InputStream inputStream) {
        int n = IIPResolutionOpImage.getLength(inputStream);
        byte[] byArray = new byte[n];
        try {
            inputStream.read(byArray);
            inputStream.read();
            inputStream.read();
        }
        catch (Exception exception) {
            throw new RuntimeException(String.valueOf(String.valueOf(exception.getClass())) + " " + exception.getMessage());
        }
        return byArray;
    }

    private static String getDataAsString(InputStream inputStream, boolean bl) {
        String string = null;
        if (bl) {
            try {
                int n = IIPResolutionOpImage.getLength(inputStream);
                byte[] byArray = new byte[n];
                inputStream.read(byArray);
                inputStream.read();
                inputStream.read();
                string = new String(byArray);
            }
            catch (Exception exception) {
                throw new RuntimeException(String.valueOf(String.valueOf(exception.getClass())) + " " + exception.getMessage());
            }
        }
        StringBuffer stringBuffer = new StringBuffer(16);
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                char c2 = (char)(0xFF & n);
                if (c2 == '\r') {
                    inputStream.read();
                    break;
                }
                stringBuffer.append(c2);
            }
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            throw new RuntimeException(String.valueOf(String.valueOf(exception.getClass())) + " " + exception.getMessage());
        }
        return string;
    }

    private synchronized JPEGDecodeParam getJPEGDecodeParam(int n) {
        JPEGDecodeParam jPEGDecodeParam = this.decodeParamCache[n - 1];
        if (jPEGDecodeParam == null) {
            String string = new String("OBJ=Comp-group,2," + n);
            InputStream inputStream = this.postCommands(new String[]{string});
            String string2 = null;
            while ((string2 = IIPResolutionOpImage.getLabel(inputStream)) != null) {
                if (string2.startsWith("comp-group")) {
                    byte[] byArray = IIPResolutionOpImage.getDataAsByteArray(inputStream);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
                    try {
                        jPEGImageDecoder.decodeAsRaster();
                    }
                    catch (Exception exception) {}
                    jPEGDecodeParam = jPEGImageDecoder.getJPEGDecodeParam();
                    continue;
                }
                IIPResolutionOpImage.checkError(string2, inputStream, true);
            }
            this.endResponse(inputStream);
            if (jPEGDecodeParam != null) {
                this.decodeParamCache[n - 1] = jPEGDecodeParam;
            }
        }
        return jPEGDecodeParam;
    }

    private Raster getJPEGTile(int n, int n2, int n3, byte[] byArray) {
        int n4 = n3 >> 24 & 0xFF;
        boolean bl = (n3 & 0xFF0000) != 0;
        JPEGDecodeParam jPEGDecodeParam = null;
        if (n4 != 0) {
            jPEGDecodeParam = this.getJPEGDecodeParam(n4);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        JPEGImageDecoder jPEGImageDecoder = jPEGDecodeParam == null ? JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream) : JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream, (JPEGDecodeParam)jPEGDecodeParam);
        Raster raster = null;
        try {
            raster = jPEGImageDecoder.decodeAsRaster().createTranslatedChild(n, n2);
        }
        catch (Exception exception) {
            String string = String.valueOf(JaiI18N.getString("IIPResolutionOpImage3")) + " " + exception.getMessage();
            throw new RuntimeException(string);
        }
        IIPResolutionOpImage.closeStream(byteArrayInputStream);
        if (this.colorSpaceType == 3 && bl) {
            IIPResolutionOpImage.YCbCrToNIFRGB(raster);
        }
        return raster;
    }

    private static String getLabel(InputStream inputStream) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(16);
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                char c2 = (char)(0xFF & n);
                if (c2 != '/' && c2 != ':') {
                    stringBuffer.append(c2);
                    bl = true;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(String.valueOf(String.valueOf(exception.getClass())) + " " + exception.getMessage());
        }
        return bl ? stringBuffer.toString().toLowerCase() : null;
    }

    private static int getLength(InputStream inputStream) {
        return Integer.valueOf(IIPResolutionOpImage.getLabel(inputStream));
    }

    public final Object getProperty(String string) {
        this.initializeIIPProperties();
        return super.getProperty(string);
    }

    public final String[] getPropertyNames() {
        this.initializeIIPProperties();
        return super.getPropertyNames();
    }

    /*
     * Exception decompiling
     */
    private Raster getSingleColorTile(int var1_1, int var2_2, int var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: First case is not immediately after switch.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:442)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Raster getTileBlock(int n, int n2, int n3, int n4) {
        int n5 = (n2 - this.minTileY) * this.numXTiles + n - this.minTileX;
        int n6 = (n4 - this.minTileY) * this.numXTiles + n3 - this.minTileX;
        String string = null;
        string = n5 == n6 ? new String("til=" + this.resolution + "," + n5 + "," + this.subImage) : new String("til=" + this.resolution + "," + n5 + "-" + n6 + "," + this.subImage);
        InputStream inputStream = this.postCommands(new String[]{string});
        int n7 = -1;
        int n8 = -1;
        byte[] byArray = null;
        String string2 = null;
        Raster raster = null;
        Point point = new Point();
        while ((string2 = IIPResolutionOpImage.getLabel(inputStream)) != null) {
            if (string2.startsWith("tile")) {
                int n9;
                int n10;
                int n11 = IIPResolutionOpImage.getLength(inputStream);
                byte[] byArray2 = new byte[8];
                try {
                    inputStream.read(byArray2);
                }
                catch (Exception exception) {
                    IIPResolutionOpImage.throwIIPException(JaiI18N.getString("IIPResolutionOpImage1"));
                }
                n7 = byArray2[3] << 24 | byArray2[2] << 16 | byArray2[1] << 8 | byArray2[0];
                n8 = byArray2[7] << 24 | byArray2[6] << 16 | byArray2[5] << 8 | byArray2[4];
                if ((n11 -= 8) != 0) {
                    byArray = new byte[n11];
                    try {
                        n10 = 0;
                        n9 = 0;
                        while ((n9 += (n10 = inputStream.read(byArray, n9, n11 - n9))) < n11 && n10 != -1) {
                        }
                        if (n10 != -1) {
                            inputStream.read();
                            inputStream.read();
                        }
                    }
                    catch (Exception exception) {
                        IIPResolutionOpImage.throwIIPException(JaiI18N.getString("IIPResolutionOpImage2"));
                    }
                }
                this.getTileXY(string2, point);
                n10 = (int)point.getX();
                n9 = (int)point.getY();
                int n12 = this.tileXToX(n10);
                int n13 = this.tileYToY(n9);
                Raster raster2 = null;
                switch (n7) {
                    case 0: {
                        raster2 = this.getUncompressedTile(n12, n13, byArray);
                        break;
                    }
                    case 1: {
                        raster2 = this.getSingleColorTile(n12, n13, n8);
                        break;
                    }
                    case 2: {
                        raster2 = this.getJPEGTile(n12, n13, n8, byArray);
                        break;
                    }
                    default: {
                        raster2 = Raster.createWritableRaster(this.sampleModel, new Point(n12, n13));
                    }
                }
                if (n10 == n && n9 == n2) {
                    raster = raster2;
                    continue;
                }
                this.addTileToCache(n10, n9, raster2);
                continue;
            }
            IIPResolutionOpImage.checkError(string2, inputStream, true);
        }
        this.endResponse(inputStream);
        return raster;
    }

    private Point getTileXY(String string, Point point) {
        int n = string.indexOf(",", string.indexOf(",") + 1) + 1;
        int n2 = string.lastIndexOf(",");
        int n3 = Integer.valueOf(string.substring(n, n2));
        int n4 = (n3 + this.minTileX) % this.numXTiles;
        int n5 = (n3 + this.minTileX - n4) / this.numXTiles + this.minTileY;
        if (point == null) {
            point = new Point(n4, n5);
        } else {
            point.setLocation(n4, n5);
        }
        return point;
    }

    private Raster getUncompressedTile(int n, int n2, byte[] byArray) {
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        return Raster.createRaster(this.sampleModel, dataBufferByte, new Point(n, n2));
    }

    private synchronized void initializeIIPProperties() {
        if (!this.arePropertiesInitialized) {
            String[] stringArray = new String[]{"OBJ=IIP", "OBJ=Basic-info", "OBJ=View-info", "OBJ=Summary-info", "OBJ=Copyright"};
            InputStream inputStream = this.postCommands(stringArray);
            String string = null;
            while ((string = IIPResolutionOpImage.getLabel(inputStream)) != null) {
                float[] fArray;
                String string2 = string;
                Object object = null;
                if (string.equals("error")) {
                    IIPResolutionOpImage.flushData(inputStream, true);
                } else if (string.startsWith("colorspace") || string.equals("max-size")) {
                    if (string.startsWith("colorspace")) {
                        string2 = "colorspace";
                    }
                    object = IIPResolutionOpImage.stringToIntArray(IIPResolutionOpImage.getDataAsString(inputStream, false));
                } else if (string.equals("resolution-number")) {
                    object = Integer.valueOf(IIPResolutionOpImage.getDataAsString(inputStream, false));
                } else if (string.equals("aspect-ratio") || string.equals("contrast-adjust") || string.equals("filtering-value")) {
                    object = Float.valueOf(IIPResolutionOpImage.getDataAsString(inputStream, false));
                } else if (string.equals("affine-transform")) {
                    fArray = IIPResolutionOpImage.stringToFloatArray(IIPResolutionOpImage.getDataAsString(inputStream, false));
                    object = new AffineTransform(fArray[0], fArray[1], fArray[3], fArray[4], fArray[5], fArray[7]);
                } else if (string.equals("color-twist")) {
                    object = IIPResolutionOpImage.stringToFloatArray(IIPResolutionOpImage.getDataAsString(inputStream, false));
                } else if (string.equals("roi")) {
                    string2 = "roi-iip";
                    fArray = IIPResolutionOpImage.stringToFloatArray(IIPResolutionOpImage.getDataAsString(inputStream, false));
                    object = new Rectangle2D.Float(fArray[0], fArray[1], fArray[2], fArray[3]);
                } else if (string.equals("copyright") || string.equals("title") || string.equals("subject") || string.equals("author") || string.equals("keywords") || string.equals("comment") || string.equals("last-author") || string.equals("rev-number") || string.equals("app-name")) {
                    object = IIPResolutionOpImage.getDataAsString(inputStream, true);
                } else if (string.equals("iip") || string.equals("iip-server") || string.equals("edit-time") || string.equals("last-printed") || string.equals("create-dtm") || string.equals("last-save-dtm")) {
                    object = IIPResolutionOpImage.getDataAsString(inputStream, false);
                } else {
                    IIPResolutionOpImage.flushData(inputStream, false);
                }
                if (string2 == null || object == null) continue;
                this.setProperty(string2, object);
            }
            this.endResponse(inputStream);
            this.arePropertiesInitialized = true;
        }
    }

    private static ImageLayout layoutHelper(String string, int n, int n2) {
        int n3;
        Object object;
        ImageLayout imageLayout = new ImageLayout();
        imageLayout.setTileGridXOffset(0);
        imageLayout.setTileGridYOffset(0);
        imageLayout.setTileWidth(64);
        imageLayout.setTileHeight(64);
        imageLayout.setMinX(0);
        imageLayout.setMinY(0);
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        String[] stringArray = new String[]{"OBJ=Max-size", "OBJ=Resolution-number"};
        InputStream inputStream = IIPResolutionOpImage.postCommands(string, stringArray);
        String string2 = null;
        while ((string2 = IIPResolutionOpImage.getLabel(inputStream)) != null) {
            String string3;
            if (string2.equals("max-size")) {
                string3 = IIPResolutionOpImage.getDataAsString(inputStream, false);
                int[] nArray = IIPResolutionOpImage.stringToIntArray(string3);
                n4 = nArray[0];
                n5 = nArray[1];
                continue;
            }
            if (string2.equals("resolution-number")) {
                string3 = IIPResolutionOpImage.getDataAsString(inputStream, false);
                n6 = Integer.valueOf(string3);
                if (n < 0) {
                    n7 = 0;
                    continue;
                }
                if (n >= n6) {
                    n7 = n6 - 1;
                    continue;
                }
                n7 = n;
                continue;
            }
            IIPResolutionOpImage.checkError(string2, inputStream, true);
        }
        IIPResolutionOpImage.closeStream(inputStream);
        int n8 = n4;
        int n9 = n5;
        int n10 = n6 - 1;
        while (n10 > n7) {
            n8 = (n8 + 1) / 2;
            n9 = (n9 + 1) / 2;
            --n10;
        }
        imageLayout.setWidth(n8);
        imageLayout.setHeight(n9);
        boolean bl = false;
        boolean bl2 = false;
        stringArray = new String[]{"OBJ=Colorspace," + n7 + "," + n2};
        inputStream = IIPResolutionOpImage.postCommands(string, stringArray);
        int n11 = 0;
        int n12 = 0;
        while ((string2 = IIPResolutionOpImage.getLabel(inputStream)) != null) {
            if (string2.startsWith("colorspace")) {
                object = IIPResolutionOpImage.stringToIntArray(IIPResolutionOpImage.getDataAsString(inputStream, false));
                n12 = (int)object[3];
                switch (object[2]) {
                    case 1: {
                        n11 = 1003;
                        break;
                    }
                    case 2: {
                        n11 = 1002;
                        break;
                    }
                    case 3: {
                        n11 = 1000;
                        break;
                    }
                    default: {
                        n11 = n12 < 3 ? 1003 : 1000;
                    }
                }
                n3 = 1;
                while (n3 <= n12) {
                    if (object[3 + n3] == 32766) {
                        bl = true;
                    }
                    ++n3;
                }
                bl2 = object[1] == true;
                continue;
            }
            IIPResolutionOpImage.checkError(string2, inputStream, true);
        }
        IIPResolutionOpImage.closeStream(inputStream);
        object = ColorSpace.getInstance(n11);
        n3 = DataBuffer.getDataTypeSize(0);
        int[] nArray = new int[n12];
        int n13 = 0;
        while (n13 < n12) {
            nArray[n13] = n3;
            ++n13;
        }
        int n14 = bl ? 3 : 1;
        ComponentColorModel componentColorModel = new ComponentColorModel((ColorSpace)object, nArray, bl, bl2, n14, 0);
        imageLayout.setColorModel(componentColorModel);
        int[] nArray2 = new int[n12];
        int n15 = 0;
        while (n15 < n12) {
            nArray2[n15] = n15;
            ++n15;
        }
        imageLayout.setSampleModel(RasterFactory.createPixelInterleavedSampleModel(0, 64, 64, n12, n12 * 64, nArray2));
        return imageLayout;
    }

    public final Rectangle mapDestRect(Rectangle rectangle, int n) {
        throw new IllegalArgumentException(JaiI18N.getString("AreaOpImage0"));
    }

    public final Rectangle mapSourceRect(Rectangle rectangle, int n) {
        throw new IllegalArgumentException(JaiI18N.getString("AreaOpImage0"));
    }

    private static InputStream postCommands(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(string) + "&OBJ=iip,1.0");
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append("&" + stringArray[n]);
                ++n;
            }
        }
        InputStream inputStream = null;
        try {
            URL uRL = new URL(stringBuffer.toString());
            inputStream = uRL.openStream();
        }
        catch (Exception exception) {
            throw new RuntimeException(String.valueOf(String.valueOf(exception.getClass())) + " " + exception.getMessage());
        }
        return inputStream;
    }

    private InputStream postCommands(String[] stringArray) {
        return IIPResolutionOpImage.postCommands(this.URLString, stringArray);
    }

    private static void printIIPException(String string) {
        System.err.println(IIPResolutionOpImage.formatIIPErrorMessage(string));
    }

    private static float[] stringToFloatArray(String string) {
        Vector<Float> vector = new Vector<Float>();
        int n = 0;
        int n2 = string.indexOf(32, 0);
        do {
            vector.add(Float.valueOf(string.substring(n, n2)));
        } while ((n2 = string.indexOf(32, n = n2 + 1)) != -1);
        vector.add(Float.valueOf(string.substring(n)));
        int n3 = vector.size();
        float[] fArray = new float[n3];
        int n4 = 0;
        while (n4 < n3) {
            fArray[n4] = ((Float)vector.get(n4)).floatValue();
            ++n4;
        }
        return fArray;
    }

    private static int[] stringToIntArray(String string) {
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        int n2 = string.indexOf(32, 0);
        do {
            vector.add(Integer.valueOf(string.substring(n, n2)));
        } while ((n2 = string.indexOf(32, n = n2 + 1)) != -1);
        vector.add(Integer.valueOf(string.substring(n)));
        int n3 = vector.size();
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = (Integer)vector.get(n4);
            ++n4;
        }
        return nArray;
    }

    private static void throwIIPException(String string) {
        throw new RuntimeException(IIPResolutionOpImage.formatIIPErrorMessage(string));
    }
}

