/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.TileCache;

final class OrConstOpImage
extends PointOpImage {
    protected int[] constants;

    public OrConstOpImage(RenderedImage renderedImage, TileCache tileCache, ImageLayout imageLayout, int[] nArray) {
        super(renderedImage, tileCache, imageLayout, true);
        int n = this.getSampleModel().getNumBands();
        if (nArray.length < n) {
            this.constants = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.constants[n2] = nArray[0];
                ++n2;
            }
        } else {
            this.constants = (int[])nArray.clone();
        }
        this.permitInPlaceOperation();
    }

    protected final void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[0], rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor2, rasterAccessor);
                break;
            }
            case 1: 
            case 2: {
                this.computeRectShort(rasterAccessor2, rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor2, rasterAccessor);
                break;
            }
        }
        rasterAccessor.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            int n9 = this.constants[n8];
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            int n10 = nArray[n8];
            int n11 = nArray2[n8];
            int n12 = 0;
            while (n12 < n2) {
                int n13 = n10;
                int n14 = n11;
                n10 += n4;
                n11 += n6;
                int n15 = 0;
                while (n15 < n) {
                    byArray3[n13] = (byte)(byArray4[n14] | n9);
                    n13 += n5;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int[][] nArray2 = rasterAccessor2.getIntDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            int n9 = this.constants[n8];
            int[] nArray5 = nArray2[n8];
            int[] nArray6 = nArray4[n8];
            int n10 = nArray[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n2) {
                int n13 = n10;
                int n14 = n11;
                n10 += n4;
                n11 += n6;
                int n15 = 0;
                while (n15 < n) {
                    nArray5[n13] = nArray6[n14] | n9;
                    n13 += n5;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            int n9 = this.constants[n8];
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n10 = nArray[n8];
            int n11 = nArray2[n8];
            int n12 = 0;
            while (n12 < n2) {
                int n13 = n10;
                int n14 = n11;
                n10 += n4;
                n11 += n6;
                int n15 = 0;
                while (n15 < n) {
                    sArray3[n13] = (short)(sArray4[n14] | n9);
                    n13 += n5;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }
}

