/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.ScaleOpImage;
import javax.media.jai.TileCache;

final class ScaleNearestBinaryOpImage
extends ScaleOpImage {
    int dx;
    int dy;
    int dwidth;
    int dheight;
    int[] xvalues;
    int[] yvalues;
    long invScaleXInt;
    long invScaleXFrac;
    long invScaleYInt;
    long invScaleYFrac;

    public ScaleNearestBinaryOpImage(RenderedImage renderedImage, BorderExtender borderExtender, TileCache tileCache, ImageLayout imageLayout, float f2, float f3, float f4, float f5, Interpolation interpolation) {
        super(renderedImage, borderExtender, tileCache, imageLayout, f2, f3, f4, f5, interpolation, true);
        this.colorModel = imageLayout != null ? imageLayout.getColorModel(renderedImage) : renderedImage.getColorModel();
        this.sampleModel = renderedImage.getSampleModel();
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
    }

    private void byteLoop(Raster raster, WritableRaster writableRaster) {
        int n;
        int n2;
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        int n3 = raster.getSampleModelTranslateX();
        int n4 = raster.getSampleModelTranslateY();
        int n5 = multiPixelPackedSampleModel.getDataBitOffset();
        int n6 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte2 = (DataBufferByte)writableRaster.getDataBuffer();
        int n7 = writableRaster.getMinX();
        int n8 = writableRaster.getMinY();
        int n9 = writableRaster.getSampleModelTranslateX();
        int n10 = writableRaster.getSampleModelTranslateY();
        int n11 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n12 = multiPixelPackedSampleModel2.getScanlineStride();
        byte[] byArray = dataBufferByte.getData();
        int n13 = dataBufferByte.getOffset();
        byte[] byArray2 = dataBufferByte2.getData();
        int n14 = dataBufferByte2.getOffset();
        int[] nArray = new int[this.dwidth];
        int[] nArray2 = new int[this.dwidth];
        int n15 = 0;
        while (n15 < this.dwidth) {
            n2 = this.xvalues[n15];
            n = n5 + (n2 - n3);
            nArray[n15] = n >> 3;
            nArray2[n15] = 7 - (n & 7);
            ++n15;
        }
        n2 = 0;
        while (n2 < this.dheight) {
            int n16;
            n = this.yvalues[n2];
            int n17 = (n - n4) * n6 + n13;
            int n18 = (n2 + this.dy - n10) * n12 + n14;
            int n19 = n11 + (this.dx - n9);
            if (n2 > 0 && n == this.yvalues[n2 - 1]) {
                n16 = n18 + (n19 >> 3);
                System.arraycopy(byArray2, n16 - n12, byArray2, n16, (this.dwidth + 7) / 8);
            } else {
                int n20;
                int n21;
                int n22;
                int n23;
                int n24 = 0;
                while (n24 < this.dwidth && (n19 & 7) != 0) {
                    n16 = byArray[n17 + nArray[n24]];
                    n23 = n16 >> nArray2[n24] & 1;
                    n22 = n18 + (n19 >> 3);
                    n21 = 7 - (n19 & 7);
                    n20 = byArray2[n22];
                    byArray2[n22] = (byte)(n20 |= n23 << n21);
                    ++n19;
                    ++n24;
                }
                n22 = n18 + (n19 >> 3);
                while (n24 < this.dwidth - 7) {
                    n16 = byArray[n17 + nArray[n24]];
                    n23 = n16 >> nArray2[n24] & 1;
                    n20 = n23 << 7;
                    n16 = byArray[n17 + nArray[++n24]];
                    n23 = n16 >> nArray2[n24] & 1;
                    n20 |= n23 << 6;
                    n16 = byArray[n17 + nArray[++n24]];
                    n23 = n16 >> nArray2[n24] & 1;
                    n20 |= n23 << 5;
                    n16 = byArray[n17 + nArray[++n24]];
                    n23 = n16 >> nArray2[n24] & 1;
                    n20 |= n23 << 4;
                    n16 = byArray[n17 + nArray[++n24]];
                    n23 = n16 >> nArray2[n24] & 1;
                    n20 |= n23 << 3;
                    n16 = byArray[n17 + nArray[++n24]];
                    n23 = n16 >> nArray2[n24] & 1;
                    n20 |= n23 << 2;
                    n16 = byArray[n17 + nArray[++n24]];
                    n23 = n16 >> nArray2[n24] & 1;
                    n20 |= n23 << 1;
                    n16 = byArray[n17 + nArray[++n24]];
                    n23 = n16 >> nArray2[n24] & 1;
                    ++n24;
                    byArray2[n22++] = (byte)(n20 |= n23);
                    n19 += 8;
                }
                if (n24 < this.dwidth) {
                    n22 = n18 + (n19 >> 3);
                    n20 = byArray2[n22];
                    while (n24 < this.dwidth) {
                        n16 = byArray[n17 + nArray[n24]];
                        n23 = n16 >> nArray2[n24] & 1;
                        n21 = 7 - (n19 & 7);
                        n20 |= n23 << n21;
                        ++n19;
                        ++n24;
                    }
                    byArray2[n22] = (byte)n20;
                }
            }
            ++n2;
        }
    }

    protected final void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        this.dx = rectangle.x;
        this.dy = rectangle.y;
        this.dwidth = rectangle.width;
        this.dheight = rectangle.height;
        this.xvalues = new int[this.dwidth];
        long l2 = this.dx;
        long l3 = 1L;
        l2 = l2 * this.transXRationalDenom - this.transXRationalNum * l3;
        l2 = 2L * l2 + (l3 *= this.transXRationalDenom);
        l3 *= 2L;
        int n3 = Rational.floor(l2 *= this.invScaleXRationalNum, l3 *= this.invScaleXRationalDenom);
        long l4 = l2 % l3;
        if (n3 < 0) {
            l4 = l3 + l4;
        }
        long l5 = l3 * this.invScaleXRationalDenom;
        l4 *= this.invScaleXRationalDenom;
        long l6 = this.invScaleXFrac * l3;
        int n4 = 0;
        while (n4 < this.dwidth) {
            this.xvalues[n4] = n3;
            n3 = (int)((long)n3 + this.invScaleXInt);
            if ((l4 += l6) >= l5) {
                ++n3;
                l4 -= l5;
            }
            ++n4;
        }
        this.yvalues = new int[this.dheight];
        long l7 = this.dy;
        long l8 = 1L;
        l7 = l7 * this.transYRationalDenom - this.transYRationalNum * l8;
        l7 = 2L * l7 + (l8 *= this.transYRationalDenom);
        l8 *= 2L;
        int n5 = Rational.floor(l7 *= this.invScaleYRationalNum, l8 *= this.invScaleYRationalDenom);
        long l9 = l7 % l8;
        if (n5 < 0) {
            l9 = l8 + l9;
        }
        long l10 = l8 * this.invScaleYRationalDenom;
        l9 *= this.invScaleYRationalDenom;
        long l11 = this.invScaleYFrac * l8;
        int n6 = 0;
        while (n6 < this.dheight) {
            this.yvalues[n6] = n5;
            n5 = (int)((long)n5 + this.invScaleYInt);
            if ((l9 += l11) >= l10) {
                ++n5;
                l9 -= l10;
            }
            ++n6;
        }
        switch (raster.getSampleModel().getDataType()) {
            case 0: {
                this.byteLoop(raster, writableRaster);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(raster, writableRaster);
                break;
            }
            case 3: {
                this.intLoop(raster, writableRaster);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
    }

    private void intLoop(Raster raster, WritableRaster writableRaster) {
        int n;
        int n2;
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int n3 = raster.getSampleModelTranslateX();
        int n4 = raster.getSampleModelTranslateY();
        int n5 = multiPixelPackedSampleModel.getDataBitOffset();
        int n6 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n7 = writableRaster.getMinX();
        int n8 = writableRaster.getMinY();
        int n9 = writableRaster.getSampleModelTranslateX();
        int n10 = writableRaster.getSampleModelTranslateY();
        int n11 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n12 = multiPixelPackedSampleModel2.getScanlineStride();
        int[] nArray = dataBufferInt.getData();
        int n13 = dataBufferInt.getOffset();
        int[] nArray2 = dataBufferInt2.getData();
        int n14 = dataBufferInt2.getOffset();
        int[] nArray3 = new int[this.dwidth];
        int[] nArray4 = new int[this.dwidth];
        int n15 = 0;
        while (n15 < this.dwidth) {
            n2 = this.xvalues[n15];
            n = n5 + (n2 - n3);
            nArray3[n15] = n >> 5;
            nArray4[n15] = 31 - (n & 0x1F);
            ++n15;
        }
        n2 = 0;
        while (n2 < this.dheight) {
            int n16;
            n = this.yvalues[n2];
            int n17 = (n - n4) * n6 + n13;
            int n18 = (n2 + this.dy - n10) * n12 + n14;
            int n19 = n11 + (this.dx - n9);
            if (n2 > 0 && n == this.yvalues[n2 - 1]) {
                n16 = n18 + (n19 >> 5);
                System.arraycopy(nArray2, n16 - n12, nArray2, n16, (this.dwidth + 31) / 32);
            } else {
                int n20;
                int n21;
                int n22;
                int n23;
                int n24 = 0;
                while (n24 < this.dwidth && (n19 & 0x1F) != 0) {
                    n16 = nArray[n17 + nArray3[n24]];
                    n23 = n16 >> nArray4[n24] & 1;
                    n22 = n18 + (n19 >> 5);
                    n21 = 31 - (n19 & 0x1F);
                    n20 = nArray2[n22];
                    nArray2[n22] = n20 |= n23 << n21;
                    ++n19;
                    ++n24;
                }
                n22 = n18 + (n19 >> 5);
                while (n24 < this.dwidth - 31) {
                    n20 = 0;
                    int n25 = 31;
                    while (n25 >= 0) {
                        n16 = nArray[n17 + nArray3[n24]];
                        n23 = n16 >> nArray4[n24] & 1;
                        n20 |= n23 << n25;
                        ++n24;
                        --n25;
                    }
                    nArray2[n22++] = n20;
                    n19 += 32;
                }
                if (n24 < this.dwidth) {
                    n22 = n18 + (n19 >> 5);
                    n20 = nArray2[n22];
                    while (n24 < this.dwidth) {
                        n16 = nArray[n17 + nArray3[n24]];
                        n23 = n16 >> nArray4[n24] & 1;
                        n21 = 31 - (n19 & 0x1F);
                        n20 |= n23 << n21;
                        ++n19;
                        ++n24;
                    }
                    nArray2[n22] = n20;
                }
            }
            ++n2;
        }
    }

    private void shortLoop(Raster raster, WritableRaster writableRaster) {
        int n;
        int n2;
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        int n3 = raster.getSampleModelTranslateX();
        int n4 = raster.getSampleModelTranslateY();
        int n5 = multiPixelPackedSampleModel.getDataBitOffset();
        int n6 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        int n7 = writableRaster.getMinX();
        int n8 = writableRaster.getMinY();
        int n9 = writableRaster.getSampleModelTranslateX();
        int n10 = writableRaster.getSampleModelTranslateY();
        int n11 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n12 = multiPixelPackedSampleModel2.getScanlineStride();
        DataBufferUShort dataBufferUShort = (DataBufferUShort)raster.getDataBuffer();
        short[] sArray = dataBufferUShort.getData();
        int n13 = dataBufferUShort.getOffset();
        DataBufferUShort dataBufferUShort2 = (DataBufferUShort)writableRaster.getDataBuffer();
        short[] sArray2 = dataBufferUShort2.getData();
        int n14 = dataBufferUShort2.getOffset();
        int[] nArray = new int[this.dwidth];
        int[] nArray2 = new int[this.dwidth];
        int n15 = 0;
        while (n15 < this.dwidth) {
            n2 = this.xvalues[n15];
            n = n5 + (n2 - n3);
            nArray[n15] = n >> 4;
            nArray2[n15] = 15 - (n & 0xF);
            ++n15;
        }
        n2 = 0;
        while (n2 < this.dheight) {
            int n16;
            n = this.yvalues[n2];
            int n17 = (n - n4) * n6 + n13;
            int n18 = (n2 + this.dy - n10) * n12 + n14;
            int n19 = n11 + (this.dx - n9);
            if (n2 > 0 && n == this.yvalues[n2 - 1]) {
                n16 = n18 + (n19 >> 4);
                System.arraycopy(sArray2, n16 - n12, sArray2, n16, (this.dwidth + 15) / 16);
            } else {
                int n20;
                int n21;
                int n22;
                int n23;
                int n24 = 0;
                while (n24 < this.dwidth && (n19 & 0xF) != 0) {
                    n16 = sArray[n17 + nArray[n24]];
                    n23 = n16 >> nArray2[n24] & 1;
                    n22 = n18 + (n19 >> 4);
                    n21 = 15 - (n19 & 0xF);
                    n20 = sArray2[n22];
                    sArray2[n22] = (short)(n20 |= n23 << n21);
                    ++n19;
                    ++n24;
                }
                n22 = n18 + (n19 >> 4);
                while (n24 < this.dwidth - 15) {
                    n20 = 0;
                    int n25 = 15;
                    while (n25 >= 0) {
                        n16 = sArray[n17 + nArray[n24]];
                        n23 = n16 >> nArray2[n24] & 1;
                        n20 |= n23 << n25;
                        ++n24;
                        --n25;
                    }
                    sArray2[n22++] = (short)n20;
                    n19 += 16;
                }
                if (n24 < this.dwidth) {
                    n22 = n18 + (n19 >> 4);
                    n20 = sArray2[n22];
                    while (n24 < this.dwidth) {
                        n16 = sArray[n17 + nArray[n24]];
                        n23 = n16 >> nArray2[n24] & 1;
                        n21 = 15 - (n19 & 0xF);
                        n20 |= n23 << n21;
                        ++n19;
                        ++n24;
                    }
                    sArray2[n22] = (short)n20;
                }
            }
            ++n2;
        }
    }
}

