/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.TileCache;
import javax.media.jai.Warp;
import javax.media.jai.WarpOpImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

final class WarpGeneralOpImage
extends WarpOpImage {
    private byte[][] ctable = null;

    public WarpGeneralOpImage(RenderedImage renderedImage, BorderExtender borderExtender, TileCache tileCache, ImageLayout imageLayout, Warp warp, Interpolation interpolation) {
        super(renderedImage, borderExtender, tileCache, imageLayout, warp, interpolation, false);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            this.ctable = new byte[3][indexColorModel.getMapSize()];
            indexColorModel.getReds(this.ctable[0]);
            indexColorModel.getGreens(this.ctable[1]);
            indexColorModel.getBlues(this.ctable[2]);
        }
    }

    protected final void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(planarImageArray[0], rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(planarImageArray[0], rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(planarImageArray[0], rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(planarImageArray[0], rasterAccessor);
                break;
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    private void computeRectByte(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = this.getLeftPadding();
        int n2 = this.getRightPadding();
        int n3 = this.getTopPadding();
        int n4 = this.getBottomPadding();
        int n5 = this.interp.getWidth();
        int n6 = this.interp.getHeight();
        int n7 = planarImage.getMinX() + n;
        int n8 = planarImage.getMaxX() - n2;
        int n9 = planarImage.getMinY() + n3;
        int n10 = planarImage.getMaxY() - n4;
        int n11 = rasterAccessor.getWidth();
        int n12 = rasterAccessor.getHeight();
        int n13 = rasterAccessor.getNumBands();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n16 = 1 << this.interp.getSubsampleBitsH();
        int n17 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n11];
        int[][] nArray2 = new int[n6][n5];
        int n18 = 0;
        if (this.ctable == null) {
            int n19 = 0;
            while (n19 < n12) {
                int n20 = n18;
                n18 += n14;
                this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n19, n11, 1, fArray);
                int n21 = 0;
                int n22 = 0;
                while (n22 < n11) {
                    float f2 = fArray[n21++];
                    float f3 = fArray[n21++];
                    int n23 = WarpGeneralOpImage.floor(f2);
                    int n24 = WarpGeneralOpImage.floor(f3);
                    int n25 = (int)((f2 - (float)n23) * (float)n16);
                    int n26 = (int)((f3 - (float)n24) * (float)n17);
                    if (n23 >= n7 && n23 < n8 && n24 >= n9 && n24 < n10) {
                        n23 -= n;
                        n24 -= n3;
                        int n27 = 0;
                        while (n27 < n13) {
                            int n28 = 0;
                            while (n28 < n6) {
                                int n29 = 0;
                                while (n29 < n5) {
                                    nArray2[n28][n29] = randomIter.getSample(n23 + n29, n24 + n28, n27) & 0xFF;
                                    ++n29;
                                }
                                ++n28;
                            }
                            byArray[n27][n20 + nArray[n27]] = ImageUtil.clampByte(this.interp.interpolate(nArray2, n25, n26));
                            ++n27;
                        }
                    }
                    n20 += n15;
                    ++n22;
                }
                ++n19;
            }
        } else {
            int n30 = 0;
            while (n30 < n12) {
                int n31 = n18;
                n18 += n14;
                this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n30, n11, 1, fArray);
                int n32 = 0;
                int n33 = 0;
                while (n33 < n11) {
                    float f4 = fArray[n32++];
                    float f5 = fArray[n32++];
                    int n34 = WarpGeneralOpImage.floor(f4);
                    int n35 = WarpGeneralOpImage.floor(f5);
                    int n36 = (int)((f4 - (float)n34) * (float)n16);
                    int n37 = (int)((f5 - (float)n35) * (float)n17);
                    if (n34 >= n7 && n34 < n8 && n35 >= n9 && n35 < n10) {
                        n34 -= n;
                        n35 -= n3;
                        int n38 = 0;
                        while (n38 < n13) {
                            byte[] byArray2 = this.ctable[n38];
                            int n39 = 0;
                            while (n39 < n6) {
                                int n40 = 0;
                                while (n40 < n5) {
                                    nArray2[n39][n40] = byArray2[randomIter.getSample(n34 + n40, n35 + n39, 0) & 0xFF] & 0xFF;
                                    ++n40;
                                }
                                ++n39;
                            }
                            byArray[n38][n31 + nArray[n38]] = ImageUtil.clampByte(this.interp.interpolate(nArray2, n36, n37));
                            ++n38;
                        }
                    }
                    n31 += n15;
                    ++n33;
                }
                ++n30;
            }
        }
    }

    private void computeRectDouble(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = this.getLeftPadding();
        int n2 = this.getRightPadding();
        int n3 = this.getTopPadding();
        int n4 = this.getBottomPadding();
        int n5 = this.interp.getWidth();
        int n6 = this.interp.getHeight();
        int n7 = planarImage.getMinX() + n;
        int n8 = planarImage.getMaxX() - n2;
        int n9 = planarImage.getMinY() + n3;
        int n10 = planarImage.getMaxY() - n4;
        int n11 = rasterAccessor.getWidth();
        int n12 = rasterAccessor.getHeight();
        int n13 = rasterAccessor.getNumBands();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        float[] fArray = new float[2 * n11];
        double[][] dArray2 = new double[n6][n5];
        int n16 = 0;
        int n17 = 0;
        while (n17 < n12) {
            int n18 = n16;
            n16 += n14;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n17, n11, 1, fArray);
            int n19 = 0;
            int n20 = 0;
            while (n20 < n11) {
                float f2 = fArray[n19++];
                float f3 = fArray[n19++];
                int n21 = WarpGeneralOpImage.floor(f2);
                int n22 = WarpGeneralOpImage.floor(f3);
                float f4 = f2 - (float)n21;
                float f5 = f3 - (float)n22;
                if (n21 >= n7 && n21 < n8 && n22 >= n9 && n22 < n10) {
                    n21 -= n;
                    n22 -= n3;
                    int n23 = 0;
                    while (n23 < n13) {
                        int n24 = 0;
                        while (n24 < n6) {
                            int n25 = 0;
                            while (n25 < n5) {
                                dArray2[n24][n25] = randomIter.getSampleDouble(n21 + n25, n22 + n24, n23);
                                ++n25;
                            }
                            ++n24;
                        }
                        dArray[n23][n18 + nArray[n23]] = this.interp.interpolate(dArray2, f4, f5);
                        ++n23;
                    }
                }
                n18 += n15;
                ++n20;
            }
            ++n17;
        }
    }

    private void computeRectFloat(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = this.getLeftPadding();
        int n2 = this.getRightPadding();
        int n3 = this.getTopPadding();
        int n4 = this.getBottomPadding();
        int n5 = this.interp.getWidth();
        int n6 = this.interp.getHeight();
        int n7 = planarImage.getMinX() + n;
        int n8 = planarImage.getMaxX() - n2;
        int n9 = planarImage.getMinY() + n3;
        int n10 = planarImage.getMaxY() - n4;
        int n11 = rasterAccessor.getWidth();
        int n12 = rasterAccessor.getHeight();
        int n13 = rasterAccessor.getNumBands();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        float[] fArray2 = new float[2 * n11];
        float[][] fArray3 = new float[n6][n5];
        int n16 = 0;
        int n17 = 0;
        while (n17 < n12) {
            int n18 = n16;
            n16 += n14;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n17, n11, 1, fArray2);
            int n19 = 0;
            int n20 = 0;
            while (n20 < n11) {
                float f2 = fArray2[n19++];
                float f3 = fArray2[n19++];
                int n21 = WarpGeneralOpImage.floor(f2);
                int n22 = WarpGeneralOpImage.floor(f3);
                float f4 = f2 - (float)n21;
                float f5 = f3 - (float)n22;
                if (n21 >= n7 && n21 < n8 && n22 >= n9 && n22 < n10) {
                    n21 -= n;
                    n22 -= n3;
                    int n23 = 0;
                    while (n23 < n13) {
                        int n24 = 0;
                        while (n24 < n6) {
                            int n25 = 0;
                            while (n25 < n5) {
                                fArray3[n24][n25] = randomIter.getSampleFloat(n21 + n25, n22 + n24, n23);
                                ++n25;
                            }
                            ++n24;
                        }
                        fArray[n23][n18 + nArray[n23]] = this.interp.interpolate(fArray3, f4, f5);
                        ++n23;
                    }
                }
                n18 += n15;
                ++n20;
            }
            ++n17;
        }
    }

    private void computeRectInt(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = this.getLeftPadding();
        int n2 = this.getRightPadding();
        int n3 = this.getTopPadding();
        int n4 = this.getBottomPadding();
        int n5 = this.interp.getWidth();
        int n6 = this.interp.getHeight();
        int n7 = planarImage.getMinX() + n;
        int n8 = planarImage.getMaxX() - n2;
        int n9 = planarImage.getMinY() + n3;
        int n10 = planarImage.getMaxY() - n4;
        int n11 = rasterAccessor.getWidth();
        int n12 = rasterAccessor.getHeight();
        int n13 = rasterAccessor.getNumBands();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n16 = 1 << this.interp.getSubsampleBitsH();
        int n17 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n11];
        int[][] nArray3 = new int[n6][n5];
        int n18 = 0;
        int n19 = 0;
        while (n19 < n12) {
            int n20 = n18;
            n18 += n14;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n19, n11, 1, fArray);
            int n21 = 0;
            int n22 = 0;
            while (n22 < n11) {
                float f2 = fArray[n21++];
                float f3 = fArray[n21++];
                int n23 = WarpGeneralOpImage.floor(f2);
                int n24 = WarpGeneralOpImage.floor(f3);
                int n25 = (int)((f2 - (float)n23) * (float)n16);
                int n26 = (int)((f3 - (float)n24) * (float)n17);
                if (n23 >= n7 && n23 < n8 && n24 >= n9 && n24 < n10) {
                    n23 -= n;
                    n24 -= n3;
                    int n27 = 0;
                    while (n27 < n13) {
                        int n28 = 0;
                        while (n28 < n6) {
                            int n29 = 0;
                            while (n29 < n5) {
                                nArray3[n28][n29] = randomIter.getSample(n23 + n29, n24 + n28, n27);
                                ++n29;
                            }
                            ++n28;
                        }
                        nArray2[n27][n20 + nArray[n27]] = this.interp.interpolate(nArray3, n25, n26);
                        ++n27;
                    }
                }
                n20 += n15;
                ++n22;
            }
            ++n19;
        }
    }

    private void computeRectShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = this.getLeftPadding();
        int n2 = this.getRightPadding();
        int n3 = this.getTopPadding();
        int n4 = this.getBottomPadding();
        int n5 = this.interp.getWidth();
        int n6 = this.interp.getHeight();
        int n7 = planarImage.getMinX() + n;
        int n8 = planarImage.getMaxX() - n2;
        int n9 = planarImage.getMinY() + n3;
        int n10 = planarImage.getMaxY() - n4;
        int n11 = rasterAccessor.getWidth();
        int n12 = rasterAccessor.getHeight();
        int n13 = rasterAccessor.getNumBands();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n16 = 1 << this.interp.getSubsampleBitsH();
        int n17 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n11];
        int[][] nArray2 = new int[n6][n5];
        int n18 = 0;
        int n19 = 0;
        while (n19 < n12) {
            int n20 = n18;
            n18 += n14;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n19, n11, 1, fArray);
            int n21 = 0;
            int n22 = 0;
            while (n22 < n11) {
                float f2 = fArray[n21++];
                float f3 = fArray[n21++];
                int n23 = WarpGeneralOpImage.floor(f2);
                int n24 = WarpGeneralOpImage.floor(f3);
                int n25 = (int)((f2 - (float)n23) * (float)n16);
                int n26 = (int)((f3 - (float)n24) * (float)n17);
                if (n23 >= n7 && n23 < n8 && n24 >= n9 && n24 < n10) {
                    n23 -= n;
                    n24 -= n3;
                    int n27 = 0;
                    while (n27 < n13) {
                        int n28 = 0;
                        while (n28 < n6) {
                            int n29 = 0;
                            while (n29 < n5) {
                                nArray2[n28][n29] = randomIter.getSample(n23 + n29, n24 + n28, n27);
                                ++n29;
                            }
                            ++n28;
                        }
                        sArray[n27][n20 + nArray[n27]] = ImageUtil.clampShort(this.interp.interpolate(nArray2, n25, n26));
                        ++n27;
                    }
                }
                n20 += n15;
                ++n22;
            }
            ++n19;
        }
    }

    private void computeRectUShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = this.getLeftPadding();
        int n2 = this.getRightPadding();
        int n3 = this.getTopPadding();
        int n4 = this.getBottomPadding();
        int n5 = this.interp.getWidth();
        int n6 = this.interp.getHeight();
        int n7 = planarImage.getMinX() + n;
        int n8 = planarImage.getMaxX() - n2;
        int n9 = planarImage.getMinY() + n3;
        int n10 = planarImage.getMaxY() - n4;
        int n11 = rasterAccessor.getWidth();
        int n12 = rasterAccessor.getHeight();
        int n13 = rasterAccessor.getNumBands();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n16 = 1 << this.interp.getSubsampleBitsH();
        int n17 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n11];
        int[][] nArray2 = new int[n6][n5];
        int n18 = 0;
        int n19 = 0;
        while (n19 < n12) {
            int n20 = n18;
            n18 += n14;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n19, n11, 1, fArray);
            int n21 = 0;
            int n22 = 0;
            while (n22 < n11) {
                float f2 = fArray[n21++];
                float f3 = fArray[n21++];
                int n23 = WarpGeneralOpImage.floor(f2);
                int n24 = WarpGeneralOpImage.floor(f3);
                int n25 = (int)((f2 - (float)n23) * (float)n16);
                int n26 = (int)((f3 - (float)n24) * (float)n17);
                if (n23 >= n7 && n23 < n8 && n24 >= n9 && n24 < n10) {
                    n23 -= n;
                    n24 -= n3;
                    int n27 = 0;
                    while (n27 < n13) {
                        int n28 = 0;
                        while (n28 < n6) {
                            int n29 = 0;
                            while (n29 < n5) {
                                nArray2[n28][n29] = randomIter.getSample(n23 + n29, n24 + n28, n27) & 0xFFFF;
                                ++n29;
                            }
                            ++n28;
                        }
                        sArray[n27][n20 + nArray[n27]] = ImageUtil.clampUShort(this.interp.interpolate(nArray2, n25, n26));
                        ++n27;
                    }
                }
                n20 += n15;
                ++n22;
            }
            ++n19;
        }
    }

    private static final int floor(float f2) {
        return f2 >= 0.0f ? (int)f2 : (int)f2 - 1;
    }
}

