/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.TileCache;
import javax.media.jai.Warp;
import javax.media.jai.WarpOpImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

final class WarpNearestOpImage
extends WarpOpImage {
    public WarpNearestOpImage(RenderedImage renderedImage, TileCache tileCache, ImageLayout imageLayout, Warp warp, Interpolation interpolation) {
        super(renderedImage, null, tileCache, imageLayout, warp, interpolation, false);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            this.sampleModel = renderedImage.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = colorModel;
        }
    }

    protected final void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(planarImageArray[0], rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(planarImageArray[0], rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(planarImageArray[0], rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(planarImageArray[0], rasterAccessor);
                break;
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    private void computeRectByte(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX();
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY();
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n6) {
            int n12 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n11, n5, 1, fArray);
            int n13 = 0;
            int n14 = 0;
            while (n14 < n5) {
                int n15 = WarpNearestOpImage.round(fArray[n13++]);
                int n16 = WarpNearestOpImage.round(fArray[n13++]);
                if (n15 >= n && n15 < n2 && n16 >= n3 && n16 < n4) {
                    int n17 = 0;
                    while (n17 < n7) {
                        byArray[n17][n12 + nArray[n17]] = (byte)(randomIter.getSample(n15, n16, n17) & 0xFF);
                        ++n17;
                    }
                }
                n12 += n9;
                ++n14;
            }
            ++n11;
        }
    }

    private void computeRectDouble(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX();
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY();
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n6) {
            int n12 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n11, n5, 1, fArray);
            int n13 = 0;
            int n14 = 0;
            while (n14 < n5) {
                int n15 = WarpNearestOpImage.round(fArray[n13++]);
                int n16 = WarpNearestOpImage.round(fArray[n13++]);
                if (n15 >= n && n15 < n2 && n16 >= n3 && n16 < n4) {
                    int n17 = 0;
                    while (n17 < n7) {
                        dArray[n17][n12 + nArray[n17]] = randomIter.getSampleDouble(n15, n16, n17);
                        ++n17;
                    }
                }
                n12 += n9;
                ++n14;
            }
            ++n11;
        }
    }

    private void computeRectFloat(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX();
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY();
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        float[] fArray2 = new float[2 * n5];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n6) {
            int n12 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n11, n5, 1, fArray2);
            int n13 = 0;
            int n14 = 0;
            while (n14 < n5) {
                int n15 = WarpNearestOpImage.round(fArray2[n13++]);
                int n16 = WarpNearestOpImage.round(fArray2[n13++]);
                if (n15 >= n && n15 < n2 && n16 >= n3 && n16 < n4) {
                    int n17 = 0;
                    while (n17 < n7) {
                        fArray[n17][n12 + nArray[n17]] = randomIter.getSampleFloat(n15, n16, n17);
                        ++n17;
                    }
                }
                n12 += n9;
                ++n14;
            }
            ++n11;
        }
    }

    private void computeRectInt(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX();
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY();
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n6) {
            int n12 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n11, n5, 1, fArray);
            int n13 = 0;
            int n14 = 0;
            while (n14 < n5) {
                int n15 = WarpNearestOpImage.round(fArray[n13++]);
                int n16 = WarpNearestOpImage.round(fArray[n13++]);
                if (n15 >= n && n15 < n2 && n16 >= n3 && n16 < n4) {
                    int n17 = 0;
                    while (n17 < n7) {
                        nArray2[n17][n12 + nArray[n17]] = randomIter.getSample(n15, n16, n17);
                        ++n17;
                    }
                }
                n12 += n9;
                ++n14;
            }
            ++n11;
        }
    }

    private void computeRectShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX();
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY();
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n6) {
            int n12 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n11, n5, 1, fArray);
            int n13 = 0;
            int n14 = 0;
            while (n14 < n5) {
                int n15 = WarpNearestOpImage.round(fArray[n13++]);
                int n16 = WarpNearestOpImage.round(fArray[n13++]);
                if (n15 >= n && n15 < n2 && n16 >= n3 && n16 < n4) {
                    int n17 = 0;
                    while (n17 < n7) {
                        sArray[n17][n12 + nArray[n17]] = (short)randomIter.getSample(n15, n16, n17);
                        ++n17;
                    }
                }
                n12 += n9;
                ++n14;
            }
            ++n11;
        }
    }

    private void computeRectUShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX();
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY();
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n6) {
            int n12 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n11, n5, 1, fArray);
            int n13 = 0;
            int n14 = 0;
            while (n14 < n5) {
                int n15 = WarpNearestOpImage.round(fArray[n13++]);
                int n16 = WarpNearestOpImage.round(fArray[n13++]);
                if (n15 >= n && n15 < n2 && n16 >= n3 && n16 < n4) {
                    int n17 = 0;
                    while (n17 < n7) {
                        sArray[n17][n12 + nArray[n17]] = (short)(randomIter.getSample(n15, n16, n17) & 0xFFFF);
                        ++n17;
                    }
                }
                n12 += n9;
                ++n14;
            }
            ++n11;
        }
    }

    private static final int round(float f2) {
        return f2 >= 0.0f ? (int)(f2 + 0.5f) : (int)(f2 - 0.5f);
    }
}

