/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.JaiI18N;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.media.jai.FloatDoubleColorModel;

public class ColorModelProxy
implements Serializable {
    private static final int COLORSPACE_UNKNOWN = 0;
    private static final int COLORSPACE_PREDEFINED = 1;
    private static final int COLORSPACE_ICC = 2;
    private static final int COLORMODEL_NULL = 0;
    private static final int COLORMODEL_FLOAT_DOUBLE_COMPONENT = 1;
    private static final int COLORMODEL_COMPONENT = 2;
    private static final int COLORMODEL_INDEX = 3;
    private static final int COLORMODEL_DIRECT = 4;
    private transient ColorModel colorModel = null;

    public ColorModelProxy(ColorModel colorModel) {
        this.colorModel = colorModel;
    }

    private static ColorSpace deserializeColorSpace(ObjectInputStream objectInputStream) {
        ColorSpace colorSpace = null;
        int n = objectInputStream.readInt();
        if (n == 2) {
            colorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(objectInputStream));
        } else if (n == 1) {
            colorSpace = ColorSpace.getInstance(objectInputStream.readInt());
        } else if (n == 0) {
            switch (objectInputStream.readInt()) {
                case 1: {
                    colorSpace = ColorSpace.getInstance(1003);
                    break;
                }
                case 3: {
                    colorSpace = ColorSpace.getInstance(1000);
                    break;
                }
                default: {
                    colorSpace = null;
                }
            }
        }
        return colorSpace;
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    private static int[] getPredefinedColorSpace(ColorSpace colorSpace) {
        int[] nArray = new int[]{1001, 1003, 1004, 1002, 1000};
        int n = 0;
        while (n < nArray.length) {
            if (colorSpace.equals(ColorSpace.getInstance(nArray[n]))) {
                return new int[]{nArray[n]};
            }
            ++n;
        }
        int n2 = colorSpace.getNumComponents();
        int n3 = colorSpace.getType();
        if (n2 == 1 && n3 == 6) {
            return new int[]{1003};
        }
        if (n2 == 3) {
            if (n3 == 5) {
                return new int[]{1000};
            }
            if (n3 == 0) {
                return new int[]{1001};
            }
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ColorSpace colorSpace = null;
        switch (objectInputStream.readInt()) {
            case 0: {
                this.colorModel = null;
                break;
            }
            case 1: {
                colorSpace = ColorModelProxy.deserializeColorSpace(objectInputStream);
                if (colorSpace == null) {
                    this.colorModel = null;
                    return;
                }
                this.colorModel = new FloatDoubleColorModel(colorSpace, objectInputStream.readBoolean(), objectInputStream.readBoolean(), objectInputStream.readInt(), objectInputStream.readInt());
                break;
            }
            case 2: {
                colorSpace = ColorModelProxy.deserializeColorSpace(objectInputStream);
                if (colorSpace == null) {
                    this.colorModel = null;
                    return;
                }
                this.colorModel = new ComponentColorModel(colorSpace, (int[])objectInputStream.readObject(), objectInputStream.readBoolean(), objectInputStream.readBoolean(), objectInputStream.readInt(), objectInputStream.readInt());
                break;
            }
            case 3: {
                this.colorModel = new IndexColorModel(objectInputStream.readInt(), objectInputStream.readInt(), (int[])objectInputStream.readObject(), 0, objectInputStream.readBoolean(), objectInputStream.readInt(), objectInputStream.readInt());
                break;
            }
            case 4: {
                colorSpace = ColorModelProxy.deserializeColorSpace(objectInputStream);
                if (colorSpace != null) {
                    this.colorModel = new DirectColorModel(colorSpace, objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readBoolean(), objectInputStream.readInt());
                    break;
                }
                if (objectInputStream.readBoolean()) {
                    this.colorModel = new DirectColorModel(objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt());
                    break;
                }
                this.colorModel = new DirectColorModel(objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt());
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ColorModelProxy1"));
            }
        }
    }

    private static boolean serializeColorSpace(ColorSpace colorSpace, ObjectOutputStream objectOutputStream) {
        int[] nArray = null;
        if (!(colorSpace instanceof ICC_ColorSpace) && (nArray = ColorModelProxy.getPredefinedColorSpace(colorSpace)) == null) {
            objectOutputStream.writeInt(0);
            objectOutputStream.writeInt(colorSpace.getNumComponents());
            return false;
        }
        if (colorSpace instanceof ICC_ColorSpace) {
            objectOutputStream.writeInt(2);
            ((ICC_ColorSpace)colorSpace).getProfile().write(objectOutputStream);
        } else {
            objectOutputStream.writeInt(1);
            objectOutputStream.writeInt(nArray[0]);
        }
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        if (this.colorModel == null) {
            objectOutputStream.writeInt(0);
        } else if (this.colorModel instanceof ComponentColorModel) {
            ComponentColorModel componentColorModel = (ComponentColorModel)this.colorModel;
            int n = 2;
            if (this.colorModel instanceof FloatDoubleColorModel) {
                n = 1;
            }
            objectOutputStream.writeInt(n);
            ColorModelProxy.serializeColorSpace(componentColorModel.getColorSpace(), objectOutputStream);
            if (n == 2) {
                objectOutputStream.writeObject(componentColorModel.getComponentSize());
            }
            objectOutputStream.writeBoolean(componentColorModel.hasAlpha());
            objectOutputStream.writeBoolean(componentColorModel.isAlphaPremultiplied());
            objectOutputStream.writeInt(componentColorModel.getTransparency());
            SampleModel sampleModel = componentColorModel.createCompatibleSampleModel(1, 1);
            objectOutputStream.writeInt(sampleModel.getTransferType());
        } else if (this.colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)this.colorModel;
            objectOutputStream.writeInt(3);
            int n = indexColorModel.getMapSize();
            int[] nArray = new int[n];
            indexColorModel.getRGBs(nArray);
            objectOutputStream.writeInt(indexColorModel.getPixelSize());
            objectOutputStream.writeInt(n);
            objectOutputStream.writeObject(nArray);
            objectOutputStream.writeBoolean(indexColorModel.hasAlpha());
            objectOutputStream.writeInt(indexColorModel.getTransparentPixel());
            SampleModel sampleModel = indexColorModel.createCompatibleSampleModel(1, 1);
            objectOutputStream.writeInt(sampleModel.getTransferType());
        } else if (this.colorModel instanceof DirectColorModel) {
            DirectColorModel directColorModel = (DirectColorModel)this.colorModel;
            objectOutputStream.writeInt(4);
            boolean bl = ColorModelProxy.serializeColorSpace(directColorModel.getColorSpace(), objectOutputStream);
            if (!bl) {
                objectOutputStream.writeBoolean(directColorModel.hasAlpha());
            }
            objectOutputStream.writeInt(directColorModel.getPixelSize());
            objectOutputStream.writeInt(directColorModel.getRedMask());
            objectOutputStream.writeInt(directColorModel.getGreenMask());
            objectOutputStream.writeInt(directColorModel.getBlueMask());
            if (bl || directColorModel.hasAlpha()) {
                objectOutputStream.writeInt(directColorModel.getAlphaMask());
            }
            if (bl) {
                objectOutputStream.writeBoolean(directColorModel.isAlphaPremultiplied());
                SampleModel sampleModel = directColorModel.createCompatibleSampleModel(1, 1);
                objectOutputStream.writeInt(sampleModel.getTransferType());
            }
        } else {
            throw new RuntimeException(JaiI18N.getString("ColorModelProxy0"));
        }
    }
}

