/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import com.sun.media.jai.util.JaiI18N;
import com.sun.media.jai.util.PackedPixelData;
import com.sun.media.jai.util.UnpackedPixelData;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;
import javax.media.jai.DataBufferDouble;
import javax.media.jai.DataBufferFloat;

public class PixelAccessor {
    public static final int TYPE_BIT = -1;
    private static final int TYPE_HAS_CM = 0;
    private static final int TYPE_NO_CM = 1;
    private static final int TYPE_CSM = 2;
    private static final int TYPE_ICM = 3;
    public SampleModel sampleModel;
    public ColorModel colorModel;
    public boolean isComponentSM;
    public boolean isMultiPixelPackedSM;
    public boolean isSinglePixelPackedSM;
    public boolean hasColorModel;
    public boolean isComponentCM;
    public boolean isIndexCM;
    public boolean isPackedCM;
    public int pixelType;
    public int numBands;
    public int bufferType;
    public int transferType;
    public int sampleType;
    public int numSamples;
    public int[] sampleSize;
    public int componentType;
    public int numComponents;
    public int[] componentSize;
    public byte[][] icmColorMap = null;
    public int type;
    public boolean packed;
    public boolean indexed;

    public PixelAccessor(RenderedImage renderedImage) {
        this(renderedImage.getSampleModel(), renderedImage.getColorModel());
    }

    public PixelAccessor(SampleModel sampleModel, ColorModel colorModel) {
        this.sampleModel = sampleModel;
        this.colorModel = colorModel;
        this.isComponentSM = this.sampleModel instanceof ComponentSampleModel;
        this.isMultiPixelPackedSM = this.sampleModel instanceof MultiPixelPackedSampleModel;
        this.isSinglePixelPackedSM = this.sampleModel instanceof SinglePixelPackedSampleModel;
        this.bufferType = this.sampleModel.getDataType();
        this.transferType = this.sampleModel.getTransferType();
        this.numSamples = this.sampleModel.getNumBands();
        this.sampleSize = this.sampleModel.getSampleSize();
        this.sampleType = this.isComponentSM || this.isMultiPixelPackedSM ? this.transferType : PixelAccessor.getType(this.sampleSize);
        boolean bl = this.hasColorModel = this.colorModel != null && this.colorModel.isCompatibleSampleModel(this.sampleModel);
        if (this.isMultiPixelPackedSM && this.colorModel != null && this.colorModel instanceof IndexColorModel) {
            this.hasColorModel = true;
        }
        if (this.hasColorModel) {
            this.isComponentCM = this.colorModel instanceof ComponentColorModel;
            this.isIndexCM = this.colorModel instanceof IndexColorModel;
            this.isPackedCM = this.colorModel instanceof PackedColorModel;
            this.numComponents = this.colorModel.getNumComponents();
            this.componentSize = this.colorModel.getComponentSize();
            this.componentType = PixelAccessor.getType(this.componentSize);
        } else {
            this.isComponentCM = false;
            this.isIndexCM = false;
            this.isPackedCM = false;
        }
        this.pixelType = PixelAccessor.getPixelType(this.sampleModel, this.colorModel);
        this.numBands = PixelAccessor.getNumBands(this.sampleModel, this.colorModel);
        int n = this.type = this.hasColorModel ? 0 : 1;
        if (this.isComponentSM && (!this.hasColorModel || this.isComponentCM)) {
            this.type = 2;
        } else if (this.isIndexCM) {
            this.type = 3;
        }
        this.packed = this.isMultiPixelPackedSM && this.sampleSize[0] == 1 || this.pixelType == -1 && this.numBands == 1;
        this.indexed = this.isIndexCM && this.numSamples == 1 && this.sampleType <= 3;
    }

    private Object clampByte(Object object, int n) {
        switch (n) {
            case 1: {
                short[] sArray = (short[])object;
                int n2 = sArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = sArray[n3] & 0xFFFF;
                    sArray[n3] = (short)(n4 > 255 ? 255 : n4);
                    ++n3;
                }
                break;
            }
            case 2: {
                short[] sArray = (short[])object;
                int n5 = sArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    int n7 = sArray[n6];
                    sArray[n6] = n7 > 255 ? 255 : (n7 < 0 ? 0 : n7);
                    ++n6;
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                int n8 = nArray.length;
                int n9 = 0;
                while (n9 < n8) {
                    int n10 = nArray[n9];
                    nArray[n9] = n10 > 255 ? 255 : (n10 < 0 ? 0 : n10);
                    ++n9;
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                int n11 = fArray.length;
                int n12 = 0;
                while (n12 < n11) {
                    float f2 = fArray[n12];
                    fArray[n12] = f2 > 255.0f ? 255.0f : (f2 < 0.0f ? 0.0f : f2);
                    ++n12;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n13 = dArray.length;
                int n14 = 0;
                while (n14 < n13) {
                    double d2 = dArray[n14];
                    dArray[n14] = d2 > 255.0 ? 255.0 : (d2 < 0.0 ? 0.0 : d2);
                    ++n14;
                }
                break;
            }
        }
        return object;
    }

    private Object clampFloat(Object object, int n) {
        switch (n) {
            case 5: {
                double[] dArray = (double[])object;
                int n2 = dArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    double d2 = dArray[n3];
                    dArray[n3] = d2 > 3.4028234663852886E38 ? 3.4028234663852886E38 : (d2 < -3.4028234663852886E38 ? -3.4028234663852886E38 : d2);
                    ++n3;
                }
                break;
            }
        }
        return object;
    }

    private Object clampInt(Object object, int n) {
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                int n2 = fArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    float f2 = fArray[n3];
                    fArray[n3] = f2 > 2.1474836E9f ? 2.1474836E9f : (f2 < -2.1474836E9f ? -2.1474836E9f : f2);
                    ++n3;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n4 = dArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    double d2 = dArray[n5];
                    dArray[n5] = d2 > 2.147483647E9 ? 2.147483647E9 : (d2 < -2.147483648E9 ? -2.147483648E9 : d2);
                    ++n5;
                }
                break;
            }
        }
        return object;
    }

    private Object clampShort(Object object, int n) {
        switch (n) {
            case 1: {
                short[] sArray = (short[])object;
                int n2 = sArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = sArray[n3] & 0xFFFF;
                    sArray[n3] = (short)(n4 > Short.MAX_VALUE ? Short.MAX_VALUE : n4);
                    ++n3;
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                int n5 = nArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    int n7 = nArray[n6];
                    nArray[n6] = n7 > Short.MAX_VALUE ? Short.MAX_VALUE : (n7 < Short.MIN_VALUE ? Short.MIN_VALUE : n7);
                    ++n6;
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                int n8 = fArray.length;
                int n9 = 0;
                while (n9 < n8) {
                    float f2 = fArray[n9];
                    fArray[n9] = f2 > 32767.0f ? 32767.0f : (f2 < -32768.0f ? -32768.0f : f2);
                    ++n9;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n10 = dArray.length;
                int n11 = 0;
                while (n11 < n10) {
                    double d2 = dArray[n11];
                    dArray[n11] = d2 > 32767.0 ? 32767.0 : (d2 < -32768.0 ? -32768.0 : d2);
                    ++n11;
                }
                break;
            }
        }
        return object;
    }

    private Object clampUShort(Object object, int n) {
        switch (n) {
            case 2: {
                short[] sArray = (short[])object;
                int n2 = sArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = sArray[n3];
                    sArray[n3] = (short)(n4 > 65535 ? 65535 : (n4 < 0 ? 0 : n4));
                    ++n3;
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                int n5 = nArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    int n7 = nArray[n6];
                    nArray[n6] = n7 > 65535 ? 65535 : (n7 < 0 ? 0 : n7);
                    ++n6;
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                int n8 = fArray.length;
                int n9 = 0;
                while (n9 < n8) {
                    float f2 = fArray[n9];
                    fArray[n9] = f2 > 65535.0f ? 65535.0f : (f2 < 0.0f ? 0.0f : f2);
                    ++n9;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n10 = dArray.length;
                int n11 = 0;
                while (n11 < n10) {
                    double d2 = dArray[n11];
                    dArray[n11] = d2 > 65535.0 ? 255.0 : (d2 < 0.0 ? 0.0 : d2);
                    ++n11;
                }
                break;
            }
        }
        return object;
    }

    public final int findCompatibleType(Vector vector) {
        int n = this.pixelType;
        if (vector != null) {
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                RenderedImage renderedImage = (RenderedImage)vector.get(n3);
                int n4 = PixelAccessor.getPixelType(renderedImage);
                n = n == 1 && n4 == 2 || n == 2 && n4 == 1 ? 3 : Math.max(n, n4);
                ++n3;
            }
        }
        return n == -1 ? 0 : n;
    }

    private Object getBandedDestData(int n, int n2, int n3, int n4) {
        int n5 = n2 * n3;
        Object object = null;
        switch (n) {
            case 0: {
                object = new byte[n4][n5];
                break;
            }
            case 1: 
            case 2: {
                object = new short[n4][n5];
                break;
            }
            case 3: {
                object = new int[n4][n5];
                break;
            }
            case 4: {
                object = new float[n4][n5];
                break;
            }
            case 5: {
                object = new double[n4][n5];
                break;
            }
        }
        return object;
    }

    private int[] getBandedOffsets(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = 0;
            ++n2;
        }
        return nArray;
    }

    private Object getColorMapData(int n, Object object, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.getIcmColorMap();
        int n8 = n3 * n4;
        n3 *= n5;
        int n9 = n7 + (n4 *= n6);
        byte[][] byArray = null;
        switch (n) {
            case 0: {
                byte[][] byArray2 = null;
                switch (n2) {
                    case 0: {
                        byte[] byArray3 = (byte[])object;
                        if (this.numBands == 1) {
                            byte[] byArray4 = new byte[n8];
                            byte[] byArray5 = this.icmColorMap[0];
                            int n10 = 0;
                            int n11 = n7;
                            while (n11 < n9) {
                                int n12 = n11 + n3;
                                int n13 = n11;
                                while (n13 < n12) {
                                    byArray4[n10++] = byArray5[byArray3[n13] & 0xFF];
                                    n13 += n5;
                                }
                                n11 += n6;
                            }
                            byArray2 = this.repeatBand(byArray4, this.numComponents);
                            break;
                        }
                        byArray2 = new byte[this.numComponents][n8];
                        int n14 = 0;
                        int n15 = n7;
                        while (n15 < n9) {
                            int n16 = n15 + n3;
                            int n17 = n15;
                            while (n17 < n16) {
                                int n18 = byArray3[n17] & 0xFF;
                                int n19 = 0;
                                while (n19 < this.numComponents) {
                                    byArray2[n19][n14] = this.icmColorMap[n19][n18];
                                    ++n19;
                                }
                                ++n14;
                                n17 += n5;
                            }
                            n15 += n6;
                        }
                        break;
                    }
                    case 1: {
                        short[] sArray = (short[])object;
                        if (this.numBands == 1) {
                            byte[] byArray6 = new byte[n8];
                            byte[] byArray7 = this.icmColorMap[0];
                            int n20 = 0;
                            int n21 = n7;
                            while (n21 < n9) {
                                int n22 = n21 + n3;
                                int n23 = n21;
                                while (n23 < n22) {
                                    byArray6[n20++] = byArray7[sArray[n23] & 0xFFFF];
                                    n23 += n5;
                                }
                                n21 += n6;
                            }
                            byArray2 = this.repeatBand(byArray6, this.numComponents);
                            break;
                        }
                        byArray2 = new byte[this.numComponents][n8];
                        int n24 = 0;
                        int n25 = n7;
                        while (n25 < n9) {
                            int n26 = n25 + n3;
                            int n27 = n25;
                            while (n27 < n26) {
                                int n28 = sArray[n27] & 0xFFFF;
                                int n29 = 0;
                                while (n29 < this.numComponents) {
                                    byArray2[n29][n24] = this.icmColorMap[n29][n28];
                                    ++n29;
                                }
                                ++n24;
                                n27 += n5;
                            }
                            n25 += n6;
                        }
                        break;
                    }
                    case 2: {
                        short[] sArray = (short[])object;
                        if (this.numBands == 1) {
                            byte[] byArray8 = new byte[n8];
                            byte[] byArray9 = this.icmColorMap[0];
                            int n30 = 0;
                            int n31 = n7;
                            while (n31 < n9) {
                                int n32 = n31 + n3;
                                int n33 = n31;
                                while (n33 < n32) {
                                    byArray8[n30++] = byArray9[sArray[n33]];
                                    n33 += n5;
                                }
                                n31 += n6;
                            }
                            byArray2 = this.repeatBand(byArray8, this.numComponents);
                            break;
                        }
                        byArray2 = new byte[this.numComponents][n8];
                        int n34 = 0;
                        int n35 = n7;
                        while (n35 < n9) {
                            int n36 = n35 + n3;
                            int n37 = n35;
                            while (n37 < n36) {
                                short s = sArray[n37];
                                int n38 = 0;
                                while (n38 < this.numComponents) {
                                    byArray2[n38][n34] = this.icmColorMap[n38][s];
                                    ++n38;
                                }
                                ++n34;
                                n37 += n5;
                            }
                            n35 += n6;
                        }
                        break;
                    }
                    case 3: {
                        int[] nArray = (int[])object;
                        if (this.numBands == 1) {
                            byte[] byArray10 = new byte[n8];
                            byte[] byArray11 = this.icmColorMap[0];
                            int n39 = 0;
                            int n40 = n7;
                            while (n40 < n9) {
                                int n41 = n40 + n3;
                                int n42 = n40;
                                while (n42 < n41) {
                                    byArray10[n39++] = byArray11[nArray[n42]];
                                    n42 += n5;
                                }
                                n40 += n6;
                            }
                            byArray2 = this.repeatBand(byArray10, this.numComponents);
                            break;
                        }
                        byArray2 = new byte[this.numComponents][n8];
                        int n43 = 0;
                        int n44 = n7;
                        while (n44 < n9) {
                            int n45 = n44 + n3;
                            int n46 = n44;
                            while (n46 < n45) {
                                int n47 = nArray[n46];
                                int n48 = 0;
                                while (n48 < this.numComponents) {
                                    byArray2[n48][n43] = this.icmColorMap[n48][n47];
                                    ++n48;
                                }
                                ++n43;
                                n46 += n5;
                            }
                            n44 += n6;
                        }
                        break;
                    }
                }
                byArray = byArray2;
                break;
            }
            case 1: 
            case 2: {
                Object object2 = null;
                switch (n2) {
                    case 0: {
                        byte[] byArray12 = (byte[])object;
                        if (this.numBands == 1) {
                            short[] sArray = new short[n8];
                            byte[] byArray13 = this.icmColorMap[0];
                            int n49 = 0;
                            int n50 = n7;
                            while (n50 < n9) {
                                int n51 = n50 + n3;
                                int n52 = n50;
                                while (n52 < n51) {
                                    sArray[n49++] = (short)(byArray13[byArray12[n52] & 0xFF] & 0xFF);
                                    n52 += n5;
                                }
                                n50 += n6;
                            }
                            object2 = this.repeatBand(sArray, this.numComponents);
                            break;
                        }
                        object2 = new short[this.numComponents][n8];
                        int n53 = 0;
                        int n54 = n7;
                        while (n54 < n9) {
                            int n55 = n54 + n3;
                            int n56 = n54;
                            while (n56 < n55) {
                                int n57 = byArray12[n56] & 0xFF;
                                int n58 = 0;
                                while (n58 < this.numComponents) {
                                    object2[n58][n53] = (short)(this.icmColorMap[n58][n57] & 0xFF);
                                    ++n58;
                                }
                                ++n53;
                                n56 += n5;
                            }
                            n54 += n6;
                        }
                        break;
                    }
                    case 1: {
                        short[] sArray = (short[])object;
                        if (this.numBands == 1) {
                            short[] sArray2 = new short[n8];
                            byte[] byArray14 = this.icmColorMap[0];
                            int n59 = 0;
                            int n60 = n7;
                            while (n60 < n9) {
                                int n61 = n60 + n3;
                                int n62 = n60;
                                while (n62 < n61) {
                                    sArray2[n59++] = (short)(byArray14[sArray[n62] & 0xFFFF] & 0xFF);
                                    n62 += n5;
                                }
                                n60 += n6;
                            }
                            object2 = this.repeatBand(sArray2, this.numComponents);
                            break;
                        }
                        object2 = new short[this.numComponents][n8];
                        int n63 = 0;
                        int n64 = n7;
                        while (n64 < n9) {
                            int n65 = n64 + n3;
                            int n66 = n64;
                            while (n66 < n65) {
                                int n67 = sArray[n66] & 0xFFFF;
                                int n68 = 0;
                                while (n68 < this.numComponents) {
                                    object2[n68][n63] = (short)(this.icmColorMap[n68][n67] & 0xFF);
                                    ++n68;
                                }
                                ++n63;
                                n66 += n5;
                            }
                            n64 += n6;
                        }
                        break;
                    }
                    case 2: {
                        short[] sArray = (short[])object;
                        if (this.numBands == 1) {
                            short[] sArray3 = new short[n8];
                            byte[] byArray15 = this.icmColorMap[0];
                            int n69 = 0;
                            int n70 = n7;
                            while (n70 < n9) {
                                int n71 = n70 + n3;
                                int n72 = n70;
                                while (n72 < n71) {
                                    sArray3[n69++] = (short)(byArray15[sArray[n72]] & 0xFF);
                                    n72 += n5;
                                }
                                n70 += n6;
                            }
                            object2 = this.repeatBand(sArray3, this.numComponents);
                            break;
                        }
                        object2 = new short[this.numComponents][n8];
                        int n73 = 0;
                        int n74 = n7;
                        while (n74 < n9) {
                            int n75 = n74 + n3;
                            int n76 = n74;
                            while (n76 < n75) {
                                short s = sArray[n76];
                                int n77 = 0;
                                while (n77 < this.numComponents) {
                                    object2[n77][n73] = (short)(this.icmColorMap[n77][s] & 0xFF);
                                    ++n77;
                                }
                                ++n73;
                                n76 += n5;
                            }
                            n74 += n6;
                        }
                        break;
                    }
                    case 3: {
                        int[] nArray = (int[])object;
                        if (this.numBands == 1) {
                            short[] sArray = new short[n8];
                            byte[] byArray16 = this.icmColorMap[0];
                            int n78 = 0;
                            int n79 = n7;
                            while (n79 < n9) {
                                int n80 = n79 + n3;
                                int n81 = n79;
                                while (n81 < n80) {
                                    sArray[n78++] = (short)(byArray16[nArray[n81]] & 0xFF);
                                    n81 += n5;
                                }
                                n79 += n6;
                            }
                            object2 = this.repeatBand(sArray, this.numComponents);
                            break;
                        }
                        object2 = new short[this.numComponents][n8];
                        int n82 = 0;
                        int n83 = n7;
                        while (n83 < n9) {
                            int n84 = n83 + n3;
                            int n85 = n83;
                            while (n85 < n84) {
                                int n86 = nArray[n85];
                                int n87 = 0;
                                while (n87 < this.numComponents) {
                                    object2[n87][n82] = (short)(this.icmColorMap[n87][n86] & 0xFF);
                                    ++n87;
                                }
                                ++n82;
                                n85 += n5;
                            }
                            n83 += n6;
                        }
                        break;
                    }
                }
                byArray = object2;
                break;
            }
            case 3: {
                Object object3 = null;
                switch (n2) {
                    case 0: {
                        byte[] byArray17 = (byte[])object;
                        if (this.numBands == 1) {
                            int[] nArray = new int[n8];
                            byte[] byArray18 = this.icmColorMap[0];
                            int n88 = 0;
                            int n89 = n7;
                            while (n89 < n9) {
                                int n90 = n89 + n3;
                                int n91 = n89;
                                while (n91 < n90) {
                                    nArray[n88++] = byArray18[byArray17[n91] & 0xFF] & 0xFF;
                                    n91 += n5;
                                }
                                n89 += n6;
                            }
                            object3 = this.repeatBand(nArray, this.numComponents);
                            break;
                        }
                        object3 = new int[this.numComponents][n8];
                        int n92 = 0;
                        int n93 = n7;
                        while (n93 < n9) {
                            int n94 = n93 + n3;
                            int n95 = n93;
                            while (n95 < n94) {
                                int n96 = byArray17[n95] & 0xFF;
                                int n97 = 0;
                                while (n97 < this.numComponents) {
                                    object3[n97][n92] = this.icmColorMap[n97][n96] & 0xFF;
                                    ++n97;
                                }
                                ++n92;
                                n95 += n5;
                            }
                            n93 += n6;
                        }
                        break;
                    }
                    case 1: {
                        short[] sArray = (short[])object;
                        if (this.numBands == 1) {
                            int[] nArray = new int[n8];
                            byte[] byArray19 = this.icmColorMap[0];
                            int n98 = 0;
                            int n99 = n7;
                            while (n99 < n9) {
                                int n100 = n99 + n3;
                                int n101 = n99;
                                while (n101 < n100) {
                                    nArray[n98++] = byArray19[sArray[n101] & 0xFFFF] & 0xFF;
                                    n101 += n5;
                                }
                                n99 += n6;
                            }
                            object3 = this.repeatBand(nArray, this.numComponents);
                            break;
                        }
                        object3 = new int[this.numComponents][n8];
                        int n102 = 0;
                        int n103 = n7;
                        while (n103 < n9) {
                            int n104 = n103 + n3;
                            int n105 = n103;
                            while (n105 < n104) {
                                int n106 = sArray[n105] & 0xFFFF;
                                int n107 = 0;
                                while (n107 < this.numComponents) {
                                    object3[n107][n102] = this.icmColorMap[n107][n106] & 0xFF;
                                    ++n107;
                                }
                                ++n102;
                                n105 += n5;
                            }
                            n103 += n6;
                        }
                        break;
                    }
                    case 2: {
                        short[] sArray = (short[])object;
                        if (this.numBands == 1) {
                            int[] nArray = new int[n8];
                            byte[] byArray20 = this.icmColorMap[0];
                            int n108 = 0;
                            int n109 = n7;
                            while (n109 < n9) {
                                int n110 = n109 + n3;
                                int n111 = n109;
                                while (n111 < n110) {
                                    nArray[n108++] = byArray20[sArray[n111]] & 0xFF;
                                    n111 += n5;
                                }
                                n109 += n6;
                            }
                            object3 = this.repeatBand(nArray, this.numComponents);
                            break;
                        }
                        object3 = new int[this.numComponents][n8];
                        int n112 = 0;
                        int n113 = n7;
                        while (n113 < n9) {
                            int n114 = n113 + n3;
                            int n115 = n113;
                            while (n115 < n114) {
                                short s = sArray[n115];
                                int n116 = 0;
                                while (n116 < this.numComponents) {
                                    object3[n116][n112] = this.icmColorMap[n116][s] & 0xFF;
                                    ++n116;
                                }
                                ++n112;
                                n115 += n5;
                            }
                            n113 += n6;
                        }
                        break;
                    }
                    case 3: {
                        int[] nArray = (int[])object;
                        if (this.numBands == 1) {
                            int[] nArray2 = new int[n8];
                            byte[] byArray21 = this.icmColorMap[0];
                            int n117 = 0;
                            int n118 = n7;
                            while (n118 < n9) {
                                int n119 = n118 + n3;
                                int n120 = n118;
                                while (n120 < n119) {
                                    nArray2[n117++] = byArray21[nArray[n120]] & 0xFF;
                                    n120 += n5;
                                }
                                n118 += n6;
                            }
                            object3 = this.repeatBand(nArray2, this.numComponents);
                            break;
                        }
                        object3 = new int[this.numComponents][n8];
                        int n121 = 0;
                        int n122 = n7;
                        while (n122 < n9) {
                            int n123 = n122 + n3;
                            int n124 = n122;
                            while (n124 < n123) {
                                int n125 = nArray[n124];
                                int n126 = 0;
                                while (n126 < this.numComponents) {
                                    object3[n126][n121] = this.icmColorMap[n126][n125] & 0xFF;
                                    ++n126;
                                }
                                ++n121;
                                n124 += n5;
                            }
                            n122 += n6;
                        }
                        break;
                    }
                }
                byArray = object3;
                break;
            }
            case 4: {
                Object object4 = null;
                switch (n2) {
                    case 0: {
                        byte[] byArray22 = (byte[])object;
                        if (this.numBands == 1) {
                            float[] fArray = new float[n8];
                            byte[] byArray23 = this.icmColorMap[0];
                            int n127 = 0;
                            int n128 = n7;
                            while (n128 < n9) {
                                int n129 = n128 + n3;
                                int n130 = n128;
                                while (n130 < n129) {
                                    fArray[n127++] = byArray23[byArray22[n130] & 0xFF] & 0xFF;
                                    n130 += n5;
                                }
                                n128 += n6;
                            }
                            object4 = this.repeatBand(fArray, this.numComponents);
                            break;
                        }
                        object4 = new float[this.numComponents][n8];
                        int n131 = 0;
                        int n132 = n7;
                        while (n132 < n9) {
                            int n133 = n132 + n3;
                            int n134 = n132;
                            while (n134 < n133) {
                                int n135 = byArray22[n134] & 0xFF;
                                int n136 = 0;
                                while (n136 < this.numComponents) {
                                    object4[n136][n131] = (byte)(this.icmColorMap[n136][n135] & 0xFF);
                                    ++n136;
                                }
                                ++n131;
                                n134 += n5;
                            }
                            n132 += n6;
                        }
                        break;
                    }
                    case 1: {
                        short[] sArray = (short[])object;
                        if (this.numBands == 1) {
                            float[] fArray = new float[n8];
                            byte[] byArray24 = this.icmColorMap[0];
                            int n137 = 0;
                            int n138 = n7;
                            while (n138 < n9) {
                                int n139 = n138 + n3;
                                int n140 = n138;
                                while (n140 < n139) {
                                    fArray[n137++] = byArray24[sArray[n140] & 0xFFFF] & 0xFF;
                                    n140 += n5;
                                }
                                n138 += n6;
                            }
                            object4 = this.repeatBand(fArray, this.numComponents);
                            break;
                        }
                        object4 = new float[this.numComponents][n8];
                        int n141 = 0;
                        int n142 = n7;
                        while (n142 < n9) {
                            int n143 = n142 + n3;
                            int n144 = n142;
                            while (n144 < n143) {
                                int n145 = sArray[n144] & 0xFFFF;
                                int n146 = 0;
                                while (n146 < this.numComponents) {
                                    object4[n146][n141] = (byte)(this.icmColorMap[n146][n145] & 0xFF);
                                    ++n146;
                                }
                                ++n141;
                                n144 += n5;
                            }
                            n142 += n6;
                        }
                        break;
                    }
                    case 2: {
                        short[] sArray = (short[])object;
                        if (this.numBands == 1) {
                            float[] fArray = new float[n8];
                            byte[] byArray25 = this.icmColorMap[0];
                            int n147 = 0;
                            int n148 = n7;
                            while (n148 < n9) {
                                int n149 = n148 + n3;
                                int n150 = n148;
                                while (n150 < n149) {
                                    fArray[n147++] = byArray25[sArray[n150]] & 0xFF;
                                    n150 += n5;
                                }
                                n148 += n6;
                            }
                            object4 = this.repeatBand(fArray, this.numComponents);
                            break;
                        }
                        object4 = new float[this.numComponents][n8];
                        int n151 = 0;
                        int n152 = n7;
                        while (n152 < n9) {
                            int n153 = n152 + n3;
                            int n154 = n152;
                            while (n154 < n153) {
                                short s = sArray[n154];
                                int n155 = 0;
                                while (n155 < this.numComponents) {
                                    object4[n155][n151] = (byte)(this.icmColorMap[n155][s] & 0xFF);
                                    ++n155;
                                }
                                ++n151;
                                n154 += n5;
                            }
                            n152 += n6;
                        }
                        break;
                    }
                    case 3: {
                        int[] nArray = (int[])object;
                        if (this.numBands == 1) {
                            float[] fArray = new float[n8];
                            byte[] byArray26 = this.icmColorMap[0];
                            int n156 = 0;
                            int n157 = n7;
                            while (n157 < n9) {
                                int n158 = n157 + n3;
                                int n159 = n157;
                                while (n159 < n158) {
                                    fArray[n156++] = byArray26[nArray[n159]] & 0xFF;
                                    n159 += n5;
                                }
                                n157 += n6;
                            }
                            object4 = this.repeatBand(fArray, this.numComponents);
                            break;
                        }
                        object4 = new float[this.numComponents][n8];
                        int n160 = 0;
                        int n161 = n7;
                        while (n161 < n9) {
                            int n162 = n161 + n3;
                            int n163 = n161;
                            while (n163 < n162) {
                                int n164 = nArray[n163];
                                int n165 = 0;
                                while (n165 < this.numComponents) {
                                    object4[n165][n160] = (byte)(this.icmColorMap[n165][n164] & 0xFF);
                                    ++n165;
                                }
                                ++n160;
                                n163 += n5;
                            }
                            n161 += n6;
                        }
                        break;
                    }
                }
                byArray = object4;
                break;
            }
            case 5: {
                Object object5 = null;
                switch (n2) {
                    case 0: {
                        byte[] byArray27 = (byte[])object;
                        if (this.numBands == 1) {
                            double[] dArray = new double[n8];
                            byte[] byArray28 = this.icmColorMap[0];
                            int n166 = 0;
                            int n167 = n7;
                            while (n167 < n9) {
                                int n168 = n167 + n3;
                                int n169 = n167;
                                while (n169 < n168) {
                                    dArray[n166++] = byArray28[byArray27[n169] & 0xFF] & 0xFF;
                                    n169 += n5;
                                }
                                n167 += n6;
                            }
                            object5 = this.repeatBand(dArray, this.numComponents);
                            break;
                        }
                        object5 = new double[this.numComponents][n8];
                        int n170 = 0;
                        int n171 = n7;
                        while (n171 < n9) {
                            int n172 = n171 + n3;
                            int n173 = n171;
                            while (n173 < n172) {
                                int n174 = byArray27[n173] & 0xFF;
                                int n175 = 0;
                                while (n175 < this.numComponents) {
                                    object5[n175][n170] = (byte)(this.icmColorMap[n175][n174] & 0xFF);
                                    ++n175;
                                }
                                ++n170;
                                n173 += n5;
                            }
                            n171 += n6;
                        }
                        break;
                    }
                    case 1: {
                        short[] sArray = (short[])object;
                        if (this.numBands == 1) {
                            double[] dArray = new double[n8];
                            byte[] byArray29 = this.icmColorMap[0];
                            int n176 = 0;
                            int n177 = n7;
                            while (n177 < n9) {
                                int n178 = n177 + n3;
                                int n179 = n177;
                                while (n179 < n178) {
                                    dArray[n176++] = byArray29[sArray[n179] & 0xFFFF] & 0xFF;
                                    n179 += n5;
                                }
                                n177 += n6;
                            }
                            object5 = this.repeatBand(dArray, this.numComponents);
                            break;
                        }
                        object5 = new double[this.numComponents][n8];
                        int n180 = 0;
                        int n181 = n7;
                        while (n181 < n9) {
                            int n182 = n181 + n3;
                            int n183 = n181;
                            while (n183 < n182) {
                                int n184 = sArray[n183] & 0xFFFF;
                                int n185 = 0;
                                while (n185 < this.numComponents) {
                                    object5[n185][n180] = (byte)(this.icmColorMap[n185][n184] & 0xFF);
                                    ++n185;
                                }
                                ++n180;
                                n183 += n5;
                            }
                            n181 += n6;
                        }
                        break;
                    }
                    case 2: {
                        short[] sArray = (short[])object;
                        if (this.numBands == 1) {
                            double[] dArray = new double[n8];
                            byte[] byArray30 = this.icmColorMap[0];
                            int n186 = 0;
                            int n187 = n7;
                            while (n187 < n9) {
                                int n188 = n187 + n3;
                                int n189 = n187;
                                while (n189 < n188) {
                                    dArray[n186++] = byArray30[sArray[n189]] & 0xFF;
                                    n189 += n5;
                                }
                                n187 += n6;
                            }
                            object5 = this.repeatBand(dArray, this.numComponents);
                            break;
                        }
                        object5 = new double[this.numComponents][n8];
                        int n190 = 0;
                        int n191 = n7;
                        while (n191 < n9) {
                            int n192 = n191 + n3;
                            int n193 = n191;
                            while (n193 < n192) {
                                short s = sArray[n193];
                                int n194 = 0;
                                while (n194 < this.numComponents) {
                                    object5[n194][n190] = (byte)(this.icmColorMap[n194][s] & 0xFF);
                                    ++n194;
                                }
                                ++n190;
                                n193 += n5;
                            }
                            n191 += n6;
                        }
                        break;
                    }
                    case 3: {
                        int[] nArray = (int[])object;
                        if (this.numBands == 1) {
                            double[] dArray = new double[n8];
                            byte[] byArray31 = this.icmColorMap[0];
                            int n195 = 0;
                            int n196 = n7;
                            while (n196 < n9) {
                                int n197 = n196 + n3;
                                int n198 = n196;
                                while (n198 < n197) {
                                    dArray[n195++] = byArray31[nArray[n198]] & 0xFF;
                                    n198 += n5;
                                }
                                n196 += n6;
                            }
                            object5 = this.repeatBand(dArray, this.numComponents);
                            break;
                        }
                        object5 = new double[this.numComponents][n8];
                        int n199 = 0;
                        int n200 = n7;
                        while (n200 < n9) {
                            int n201 = n200 + n3;
                            int n202 = n200;
                            while (n202 < n201) {
                                int n203 = nArray[n202];
                                int n204 = 0;
                                while (n204 < this.numComponents) {
                                    object5[n204][n199] = (byte)(this.icmColorMap[n204][n203] & 0xFF);
                                    ++n204;
                                }
                                ++n199;
                                n202 += n5;
                            }
                            n200 += n6;
                        }
                        break;
                    }
                }
                byArray = object5;
                break;
            }
        }
        return byArray;
    }

    private UnpackedPixelData getCsmData(Raster raster, Rectangle rectangle, int n, boolean bl) {
        int[] nArray;
        int n2;
        int n3;
        boolean bl2;
        if (n < this.bufferType && (n != 1 || this.bufferType != 2)) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor4"));
        }
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)this.sampleModel;
        int[] nArray2 = componentSampleModel.getBankIndices();
        Object object = null;
        if (n == this.bufferType || n == 1 && this.bufferType == 2 || n == 2 && this.bufferType == 1) {
            Object object2;
            n = this.bufferType;
            DataBuffer dataBuffer = raster.getDataBuffer();
            boolean bl3 = dataBuffer.getNumBanks() == 1;
            switch (n) {
                case 0: {
                    int n4;
                    object2 = ((DataBufferByte)dataBuffer).getBankData();
                    byte[][] byArray = new byte[this.numSamples][];
                    if (bl3) {
                        n4 = 0;
                        while (n4 < this.numSamples) {
                            byArray[n4] = object2[nArray2[0]];
                            ++n4;
                        }
                    } else {
                        n4 = 0;
                        while (n4 < this.numSamples) {
                            byArray[n4] = object2[nArray2[n4]];
                            ++n4;
                        }
                    }
                    object = byArray;
                    break;
                }
                case 1: 
                case 2: {
                    int n5;
                    short[][] sArray = dataBuffer instanceof DataBufferUShort ? ((DataBufferUShort)dataBuffer).getBankData() : ((DataBufferShort)dataBuffer).getBankData();
                    short[][] sArray2 = new short[this.numSamples][];
                    if (bl3) {
                        n5 = 0;
                        while (n5 < this.numSamples) {
                            sArray2[n5] = sArray[nArray2[0]];
                            ++n5;
                        }
                    } else {
                        n5 = 0;
                        while (n5 < this.numSamples) {
                            sArray2[n5] = sArray[nArray2[n5]];
                            ++n5;
                        }
                    }
                    object = sArray2;
                    break;
                }
                case 3: {
                    int n6;
                    int[][] nArray3 = ((DataBufferInt)dataBuffer).getBankData();
                    int[][] nArray4 = new int[this.numSamples][];
                    if (bl3) {
                        n6 = 0;
                        while (n6 < this.numSamples) {
                            nArray4[n6] = nArray3[nArray2[0]];
                            ++n6;
                        }
                    } else {
                        n6 = 0;
                        while (n6 < this.numSamples) {
                            nArray4[n6] = nArray3[nArray2[n6]];
                            ++n6;
                        }
                    }
                    object = nArray4;
                    break;
                }
                case 4: {
                    int n7;
                    float[][] fArray = ((DataBufferFloat)dataBuffer).getBankData();
                    float[][] fArray2 = new float[this.numSamples][];
                    if (bl3) {
                        n7 = 0;
                        while (n7 < this.numSamples) {
                            fArray2[n7] = fArray[nArray2[0]];
                            ++n7;
                        }
                    } else {
                        n7 = 0;
                        while (n7 < this.numSamples) {
                            fArray2[n7] = fArray[nArray2[n7]];
                            ++n7;
                        }
                    }
                    object = fArray2;
                    break;
                }
                case 5: {
                    int n8;
                    double[][] dArray = ((DataBufferDouble)dataBuffer).getBankData();
                    double[][] dArray2 = new double[this.numSamples][];
                    if (bl3) {
                        n8 = 0;
                        while (n8 < this.numSamples) {
                            dArray2[n8] = dArray[nArray2[0]];
                            ++n8;
                        }
                    } else {
                        n8 = 0;
                        while (n8 < this.numSamples) {
                            dArray2[n8] = dArray[nArray2[n8]];
                            ++n8;
                        }
                    }
                    object = dArray2;
                    break;
                }
            }
            bl2 = false;
            n3 = componentSampleModel.getPixelStride();
            n2 = componentSampleModel.getScanlineStride();
            object2 = dataBuffer.getOffsets();
            int n9 = rectangle.x - raster.getSampleModelTranslateX();
            int n10 = rectangle.y - raster.getSampleModelTranslateY();
            nArray = new int[this.numSamples];
            if (bl3) {
                int n11 = 0;
                while (n11 < this.numSamples) {
                    nArray[n11] = componentSampleModel.getOffset(n9, n10, n11) + object2[0];
                    ++n11;
                }
            } else {
                int n12 = 0;
                while (n12 < this.numSamples) {
                    nArray[n12] = componentSampleModel.getOffset(n9, n10, n12) + object2[n12];
                    ++n12;
                }
            }
        } else {
            int n13 = rectangle.width * rectangle.height * this.numSamples;
            switch (n) {
                case 1: 
                case 2: {
                    short[] sArray = new short[n13];
                    if (!bl) {
                        UnpackedPixelData unpackedPixelData = this.getCsmData(raster, rectangle, this.bufferType, bl);
                        byte[][] byArray = unpackedPixelData.getByteData();
                        int n14 = 0;
                        while (n14 < this.numSamples) {
                            byte[] byArray2 = byArray[n14];
                            int n15 = unpackedPixelData.getOffset(n14);
                            int n16 = n14;
                            int n17 = 0;
                            while (n17 < rectangle.height) {
                                int n18 = n15;
                                n15 += unpackedPixelData.lineStride;
                                int n19 = 0;
                                while (n19 < rectangle.width) {
                                    sArray[n16] = (short)(byArray2[n18] & 0xFF);
                                    n18 += unpackedPixelData.pixelStride;
                                    n16 += this.numSamples;
                                    ++n19;
                                }
                                ++n17;
                            }
                            ++n14;
                        }
                    }
                    object = this.repeatBand(sArray, this.numSamples);
                    break;
                }
                case 3: {
                    int[] nArray5 = bl ? new int[n13] : raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
                    object = this.repeatBand(nArray5, this.numSamples);
                    break;
                }
                case 4: {
                    float[] fArray = bl ? new float[n13] : raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (float[])null);
                    object = this.repeatBand(fArray, this.numSamples);
                    break;
                }
                case 5: {
                    double[] dArray = bl ? new double[n13] : raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (double[])null);
                    object = this.repeatBand(dArray, this.numSamples);
                    break;
                }
            }
            bl2 = bl & raster instanceof WritableRaster;
            n3 = this.numSamples;
            n2 = n3 * rectangle.width;
            nArray = this.getInterleavedOffsets(this.numSamples);
        }
        return new UnpackedPixelData(raster, rectangle, bl2 & bl, n, this.numSamples, object, n3, n2, nArray);
    }

    public final UnpackedPixelData getData(Raster raster, Rectangle rectangle, int n, boolean bl) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor3"));
        }
        if ((rectangle = rectangle.intersection(raster.getBounds())).isEmpty()) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor0"));
        }
        switch (this.type) {
            case 2: {
                return this.getCsmData(raster, rectangle, n, bl);
            }
            case 3: {
                return this.getIcmData(raster, rectangle, n, bl);
            }
            case 1: {
                return this.getNocmData(raster, rectangle, n, bl);
            }
            case 0: {
                return this.getGenericData(raster, rectangle, n, bl);
            }
        }
        return null;
    }

    public static final int getDestNumBands(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        if (n2 > 0) {
            RenderedImage renderedImage = (RenderedImage)vector.get(0);
            SampleModel sampleModel = renderedImage.getSampleModel();
            ColorModel colorModel = renderedImage.getColorModel();
            n = PixelAccessor.getNumBands(sampleModel, colorModel);
            int n3 = colorModel == null ? n : colorModel.getNumComponents();
            int n4 = 1;
            while (n4 < n2) {
                renderedImage = (RenderedImage)vector.get(n4);
                sampleModel = renderedImage.getSampleModel();
                colorModel = renderedImage.getColorModel();
                int n5 = PixelAccessor.getNumBands(sampleModel, colorModel);
                int n6 = colorModel == null ? n5 : colorModel.getNumComponents();
                n3 = Math.min(n3, n6);
                if (n > 1 || n5 > 1) {
                    n = n3;
                }
                ++n4;
            }
        }
        return n;
    }

    public static final int getDestPixelType(Vector vector) {
        int n = 32;
        int n2 = vector.size();
        if (n2 > 0) {
            RenderedImage renderedImage = (RenderedImage)vector.get(0);
            SampleModel sampleModel = renderedImage.getSampleModel();
            ColorModel colorModel = renderedImage.getColorModel();
            n = sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getSampleSize(0) == 1 ? -1 : PixelAccessor.getPixelType(sampleModel, colorModel);
            int n3 = 1;
            while (n3 < n2) {
                renderedImage = (RenderedImage)vector.get(n3);
                sampleModel = renderedImage.getSampleModel();
                colorModel = renderedImage.getColorModel();
                int n4 = sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getSampleSize(0) == 1 ? -1 : PixelAccessor.getPixelType(sampleModel, colorModel);
                n = n == 1 && n4 == 2 || n == 2 && n4 == 1 ? 3 : Math.max(n, n4);
                ++n3;
            }
        }
        return n;
    }

    private UnpackedPixelData getGenericData(Raster raster, Rectangle rectangle, int n, boolean bl) {
        if (n < this.componentType) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor4"));
        }
        Object object = this.getInterleavedDestData(n, rectangle.width, rectangle.height, this.numComponents);
        if (!bl) {
            Object object2;
            int n2 = rectangle.width * rectangle.height * this.numComponents;
            int[] nArray = new int[n2];
            int n3 = rectangle.x + rectangle.width;
            int n4 = rectangle.y + rectangle.height;
            int n5 = 0;
            int n6 = rectangle.y;
            while (n6 < n4) {
                int n7 = rectangle.x;
                while (n7 < n3) {
                    object2 = raster.getDataElements(n7, n6, null);
                    this.colorModel.getComponents(object2, nArray, n5);
                    n5 += this.numComponents;
                    ++n7;
                }
                ++n6;
            }
            switch (n) {
                case 0: {
                    byte[] byArray = ((byte[][])object)[0];
                    int n8 = 0;
                    while (n8 < n2) {
                        byArray[n8] = (byte)nArray[n8];
                        ++n8;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    object2 = ((short[][])object)[0];
                    int n9 = 0;
                    while (n9 < n2) {
                        object2[n9] = (short)nArray[n9];
                        ++n9;
                    }
                    break;
                }
                case 3: {
                    object = this.repeatBand(nArray, this.numComponents);
                    break;
                }
                case 4: {
                    float[] fArray = ((float[][])object)[0];
                    int n10 = 0;
                    while (n10 < n2) {
                        fArray[n10] = nArray[n10];
                        ++n10;
                    }
                    break;
                }
                case 5: {
                    double[] dArray = ((double[][])object)[0];
                    int n11 = 0;
                    while (n11 < n2) {
                        dArray[n11] = nArray[n11];
                        ++n11;
                    }
                    break;
                }
            }
        }
        return new UnpackedPixelData(raster, rectangle, false, n, this.numComponents, object, this.numComponents, this.numComponents * rectangle.width, this.getInterleavedOffsets(this.numComponents));
    }

    public final byte[][] getIcmColorMap() {
        if (this.icmColorMap == null && this.type == 3) {
            IndexColorModel indexColorModel = (IndexColorModel)this.colorModel;
            int n = indexColorModel.getMapSize();
            this.icmColorMap = new byte[this.numComponents][];
            this.icmColorMap[0] = new byte[n];
            indexColorModel.getReds(this.icmColorMap[0]);
            if (this.numBands == 1) {
                int n2 = 1;
                while (n2 < this.numComponents) {
                    this.icmColorMap[n2] = this.icmColorMap[0];
                    ++n2;
                }
            } else {
                this.icmColorMap[1] = new byte[n];
                indexColorModel.getGreens(this.icmColorMap[1]);
                this.icmColorMap[2] = new byte[n];
                indexColorModel.getBlues(this.icmColorMap[2]);
                if (indexColorModel.hasAlpha()) {
                    this.icmColorMap[3] = new byte[n];
                    indexColorModel.getAlphas(this.icmColorMap[3]);
                }
            }
        }
        return this.icmColorMap;
    }

    private UnpackedPixelData getIcmData(Raster raster, Rectangle rectangle, int n, boolean bl) {
        Object object;
        if (!this.indexed) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor5"));
        }
        if (bl) {
            object = this.getBandedDestData(n, rectangle.width, rectangle.height, this.numComponents);
        } else if (this.isComponentSM) {
            UnpackedPixelData unpackedPixelData = this.getCsmData(raster, rectangle, this.bufferType, bl);
            Object[] objectArray = null;
            switch (this.bufferType) {
                case 0: {
                    objectArray = unpackedPixelData.getByteData(0);
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = unpackedPixelData.getShortData(0);
                    break;
                }
                case 3: {
                    objectArray = unpackedPixelData.getIntData(0);
                    break;
                }
            }
            object = this.getColorMapData(n, objectArray, this.bufferType, rectangle.width, rectangle.height, unpackedPixelData.pixelStride, unpackedPixelData.lineStride, unpackedPixelData.getOffset(0));
        } else if (this.isMultiPixelPackedSM) {
            Object object2 = raster.getDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
            object = this.getColorMapData(n, object2, this.transferType, rectangle.width, rectangle.height, 1, rectangle.width, 0);
        } else {
            int[] nArray = raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
            object = this.getColorMapData(n, nArray, 3, rectangle.width, rectangle.height, 1, rectangle.width, 0);
        }
        return new UnpackedPixelData(raster, rectangle, false, n, this.numComponents, object, 1, rectangle.width, this.getBandedOffsets(this.numComponents));
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public final UnpackedPixelData getIndexData(Raster var1_1, Rectangle var2_2, boolean var3_3) {
        block18: {
            block17: {
                if (!this.indexed) {
                    throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor2"));
                }
                var4_4 = this.sampleType == -1 ? 0 : this.sampleType;
                if ((var2_2 = var2_2.intersection(var1_1.getBounds())).isEmpty()) {
                    throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor0"));
                }
                if (this.isComponentSM) {
                    return this.getCsmData(var1_1, var2_2, var4_4, var3_3);
                }
                var5_5 = null;
                if (!var3_3) break block17;
                var5_5 = this.getBandedDestData(var4_4, var2_2.width, var2_2.height, 1);
                break block18;
            }
            if (!this.isMultiPixelPackedSM) ** GOTO lbl29
            var6_6 = var1_1.getDataElements(var2_2.x, var2_2.y, var2_2.width, var2_2.height, null);
            switch (this.transferType) {
                case 0: {
                    var7_8 /* !! */  = (int[])new byte[1][];
                    var7_8 /* !! */ [0] = (int)((byte[])var6_6);
                    var5_5 = var7_8 /* !! */ ;
                    break;
                }
                case 1: 
                case 2: {
                    var8_10 = new short[][]{(short[])var6_6};
                    var5_5 = var8_10;
                    break;
                }
                case 3: {
                    var9_12 = new int[][]{(int[])var6_6};
                    var5_5 = var9_12;
                    break;
                }
lbl29:
                // 1 sources

                var6_6 = var1_1.getPixels(var2_2.x, var2_2.y, var2_2.width, var2_2.height, (int[])null);
                var7_9 = ((Object)var6_6).length;
                block5 : switch (var4_4) {
                    case 0: {
                        var8_11 = new byte[1][var7_9];
                        var9_13 = var8_11[0];
                        var10_14 = 0;
                        while (true) {
                            if (var10_14 >= var7_9) {
                                var5_5 = var8_11;
                                break block5;
                            }
                            var9_13[var10_14] = (byte)var6_6[var10_14];
                            ++var10_14;
                        }
                    }
                    case 1: 
                    case 2: {
                        var10_15 = new short[1][var7_9];
                        var11_16 = var10_15[0];
                        var12_17 = 0;
                        while (true) {
                            if (var12_17 >= var7_9) {
                                var5_5 = var10_15;
                                break block5;
                            }
                            var11_16[var12_17] = (short)var6_6[var12_17];
                            ++var12_17;
                        }
                    }
                    case 3: {
                        var12_18 = new int[][]{(int[])var6_6};
                        var5_5 = var12_18;
                    }
                }
                break;
            }
        }
        var6_7 = var3_3 & var1_1 instanceof WritableRaster;
        var7_8 /* !! */  = new int[1];
        return new UnpackedPixelData(var1_1, var2_2, var6_7, var4_4, 1, var5_5, 1, var2_2.width, var7_8 /* !! */ );
    }

    private Object getInterleavedDestData(int n, int n2, int n3, int n4) {
        int n5 = n2 * n3 * n4;
        Object object = null;
        switch (n) {
            case 0: {
                byte[] byArray = new byte[n5];
                object = this.repeatBand(byArray, n4);
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = new short[n5];
                object = this.repeatBand(sArray, n4);
                break;
            }
            case 3: {
                int[] nArray = new int[n5];
                object = this.repeatBand(nArray, n4);
                break;
            }
            case 4: {
                float[] fArray = new float[n5];
                object = this.repeatBand(fArray, n4);
                break;
            }
            case 5: {
                double[] dArray = new double[n5];
                object = this.repeatBand(dArray, n4);
                break;
            }
        }
        return object;
    }

    private int[] getInterleavedOffsets(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        return nArray;
    }

    private UnpackedPixelData getNocmData(Raster raster, Rectangle rectangle, int n, boolean bl) {
        if (n < this.sampleType) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor4"));
        }
        Object object = null;
        if (bl) {
            object = this.getInterleavedDestData(n, rectangle.width, rectangle.height, this.numSamples);
        } else {
            switch (n) {
                case 0: {
                    byte[] byArray;
                    if (this.isMultiPixelPackedSM && this.transferType == 0) {
                        byArray = (byte[])raster.getDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
                    } else {
                        int[] nArray = raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
                        int n2 = nArray.length;
                        byArray = new byte[n2];
                        int n3 = 0;
                        while (n3 < n2) {
                            byArray[n3] = (byte)nArray[n3];
                            ++n3;
                        }
                    }
                    object = this.repeatBand(byArray, this.numSamples);
                    break;
                }
                case 1: 
                case 2: {
                    if (!this.isMultiPixelPackedSM || this.transferType != 1) {
                        int[] nArray = raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
                        int n4 = nArray.length;
                        short[] sArray = new short[n4];
                        int n5 = 0;
                        while (n5 < n4) {
                            sArray[n5] = (short)nArray[n5];
                            ++n5;
                        }
                        object = this.repeatBand(sArray, this.numSamples);
                        break;
                    }
                    short[] sArray = (short[])raster.getDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
                    object = this.repeatBand(sArray, this.numSamples);
                    break;
                }
                case 3: {
                    int[] nArray = raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
                    object = this.repeatBand(nArray, this.numSamples);
                    break;
                }
                case 4: {
                    float[] fArray = raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (float[])null);
                    object = this.repeatBand(fArray, this.numSamples);
                    break;
                }
                case 5: {
                    double[] dArray = raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (double[])null);
                    object = this.repeatBand(dArray, this.numSamples);
                    break;
                }
            }
        }
        boolean bl2 = bl & raster instanceof WritableRaster;
        return new UnpackedPixelData(raster, rectangle, bl2, n, this.numSamples, object, this.numSamples, this.numSamples * rectangle.width, this.getInterleavedOffsets(this.numSamples));
    }

    public static final int getNumBands(RenderedImage renderedImage) {
        return PixelAccessor.getNumBands(renderedImage.getSampleModel(), renderedImage.getColorModel());
    }

    public static final int getNumBands(SampleModel sampleModel, ColorModel colorModel) {
        int n;
        if (colorModel == null || colorModel instanceof ComponentColorModel && sampleModel instanceof ComponentSampleModel) {
            n = sampleModel.getNumBands();
        } else if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int n2 = indexColorModel.getMapSize();
            int[] nArray = new int[n2];
            indexColorModel.getRGBs(nArray);
            boolean bl = indexColorModel.hasAlpha();
            n = 1;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray[n3];
                int n5 = n4 >>> 24 & 0xFF;
                int n6 = n4 >>> 16 & 0xFF;
                int n7 = n4 >>> 8 & 0xFF;
                int n8 = n4 & 0xFF;
                if (n7 != n6 || n8 != n6 || bl && n5 != n6) {
                    n = indexColorModel.getNumComponents();
                    break;
                }
                ++n3;
            }
        } else {
            n = colorModel.getNumComponents();
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final PackedPixelData getPackedData(Raster raster, Rectangle rectangle, boolean bl) {
        int n;
        int n2;
        int n3;
        byte[] byArray;
        boolean bl2;
        if (!this.packed) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor1"));
        }
        if ((rectangle = rectangle.intersection(raster.getBounds())).isEmpty()) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor0"));
        }
        if (this.isMultiPixelPackedSM && this.sampleSize[0] == 1) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)this.sampleModel;
            bl2 = bl;
            DataBuffer dataBuffer = raster.getDataBuffer();
            int n4 = dataBuffer.getOffset();
            int n5 = rectangle.x - raster.getSampleModelTranslateX();
            int n6 = rectangle.y - raster.getSampleModelTranslateY();
            int n7 = multiPixelPackedSampleModel.getScanlineStride();
            int n8 = multiPixelPackedSampleModel.getOffset(n5, n6) + n4;
            int n9 = multiPixelPackedSampleModel.getOffset(n5 + rectangle.width - 1, n6) + n4;
            int n10 = n9 - n8 + 1;
            int n11 = multiPixelPackedSampleModel.getBitOffset(n5);
            switch (this.bufferType) {
                case 0: {
                    bl2 = false;
                    byArray = ((DataBufferByte)dataBuffer).getData();
                    n3 = n7;
                    n2 = n8;
                    n = n11;
                    return new PackedPixelData(raster, rectangle, bl2, byArray, n3, n2, n);
                }
                case 1: {
                    n3 = n10 * 2;
                    n2 = n11 / 8;
                    n = n11 % 8;
                    byArray = new byte[n3 * rectangle.height];
                    short[] sArray = ((DataBufferUShort)dataBuffer).getData();
                    int n12 = 0;
                    int n13 = 0;
                    while (n13 < rectangle.height) {
                        int n14 = n8;
                        while (n14 <= n9) {
                            short s = sArray[n14];
                            byArray[n12++] = (byte)(s >>> 8 & 0xFF);
                            byArray[n12++] = (byte)(s & 0xFF);
                            ++n14;
                        }
                        n8 += n7;
                        n9 += n7;
                        ++n13;
                    }
                    return new PackedPixelData(raster, rectangle, bl2, byArray, n3, n2, n);
                }
                case 3: {
                    n3 = n10 * 4;
                    n2 = n11 / 8;
                    n = n11 % 8;
                    byArray = new byte[n3 * rectangle.height];
                    int[] nArray = ((DataBufferInt)dataBuffer).getData();
                    int n15 = 0;
                    int n16 = 0;
                    while (n16 < rectangle.height) {
                        int n17 = n8;
                        while (n17 <= n9) {
                            int n18 = nArray[n17];
                            byArray[n15++] = (byte)(n18 >>> 24 & 0xFF);
                            byArray[n15++] = (byte)(n18 >>> 16 & 0xFF);
                            byArray[n15++] = (byte)(n18 >>> 8 & 0xFF);
                            byArray[n15++] = (byte)(n18 & 0xFF);
                            ++n17;
                        }
                        n8 += n7;
                        n9 += n7;
                        ++n16;
                    }
                    return new PackedPixelData(raster, rectangle, bl2, byArray, n3, n2, n);
                }
                default: {
                    return null;
                }
            }
        }
        bl2 = this.hasColorModel ? false : bl & raster instanceof WritableRaster;
        n3 = (rectangle.width + 7) / 8;
        n2 = 0;
        n = 0;
        byArray = new byte[n3 * rectangle.height];
        if (bl) return new PackedPixelData(raster, rectangle, bl2, byArray, n3, n2, n);
        int n19 = n3 * 8;
        int[] nArray = new int[n19];
        if (this.hasColorModel) {
            if (!this.isSinglePixelPackedSM && this.numSamples != 1) throw new UnsupportedOperationException("This case is not yet implemented. Contact author.");
            int n20 = rectangle.x + rectangle.width;
            int n21 = rectangle.y + rectangle.height;
            int n22 = 0;
            int n23 = rectangle.y;
            while (n23 < n21) {
                int n24 = 0;
                int n25 = rectangle.x;
                while (n25 < n20) {
                    Object object = raster.getDataElements(n25, n23, null);
                    this.colorModel.getComponents(object, nArray, n24);
                    ++n24;
                    ++n25;
                }
                int n26 = 0;
                while (n26 < n19) {
                    byArray[n22++] = (byte)(nArray[n26] << 7 | nArray[n26 + 1] << 6 | nArray[n26 + 2] << 5 | nArray[n26 + 3] << 4 | nArray[n26 + 4] << 3 | nArray[n26 + 5] << 2 | nArray[n26 + 6] << 1 | nArray[n26 + 7]);
                    n26 += 8;
                }
                ++n23;
            }
            return new PackedPixelData(raster, rectangle, bl2, byArray, n3, n2, n);
        } else {
            int n27 = 0;
            int n28 = 0;
            while (n28 < rectangle.height) {
                nArray = raster.getPixels(rectangle.x, rectangle.y + n28, rectangle.width, 1, nArray);
                int n29 = 0;
                while (n29 < n19) {
                    byArray[n27++] = (byte)(nArray[n29] << 7 | nArray[n29 + 1] << 6 | nArray[n29 + 2] << 5 | nArray[n29 + 3] << 4 | nArray[n29 + 4] << 3 | nArray[n29 + 5] << 2 | nArray[n29 + 6] << 1 | nArray[n29 + 7]);
                    n29 += 8;
                }
                ++n28;
            }
        }
        return new PackedPixelData(raster, rectangle, bl2, byArray, n3, n2, n);
    }

    public static final int getPixelType(RenderedImage renderedImage) {
        return PixelAccessor.getPixelType(renderedImage.getSampleModel(), renderedImage.getColorModel());
    }

    public static final int getPixelType(SampleModel sampleModel, ColorModel colorModel) {
        int n = colorModel == null ? (sampleModel instanceof ComponentSampleModel ? sampleModel.getDataType() : PixelAccessor.getType(sampleModel.getSampleSize())) : (colorModel instanceof ComponentColorModel && sampleModel instanceof ComponentSampleModel ? sampleModel.getDataType() : (colorModel instanceof IndexColorModel ? 0 : PixelAccessor.getType(colorModel.getComponentSize())));
        return n;
    }

    private static int getType(int[] nArray) {
        int n = nArray[0];
        int n2 = 1;
        while (n2 < nArray.length) {
            n = Math.max(n, nArray[n2]);
            ++n2;
        }
        int n3 = n < 1 ? 32 : (n == 1 ? -1 : (n <= 8 ? 0 : (n <= 16 ? 1 : (n <= 32 ? 3 : (n <= 64 ? 5 : 32)))));
        return n3;
    }

    public static final boolean indexedOperation(PixelAccessor pixelAccessor, PixelAccessor pixelAccessor2) {
        return pixelAccessor.indexed && pixelAccessor2.indexed && pixelAccessor.sampleType == pixelAccessor2.sampleType;
    }

    public static final boolean indexedOperation(PixelAccessor pixelAccessor, PixelAccessor pixelAccessor2, PixelAccessor pixelAccessor3) {
        return pixelAccessor.indexed && pixelAccessor2.indexed && pixelAccessor3.indexed && pixelAccessor.sampleType == pixelAccessor3.sampleType && pixelAccessor2.sampleType == pixelAccessor3.sampleType;
    }

    public static final boolean indexedOperation(PixelAccessor[] pixelAccessorArray, PixelAccessor pixelAccessor) {
        boolean bl = pixelAccessor.indexed;
        int n = pixelAccessor.sampleType;
        if (bl && pixelAccessorArray != null) {
            int n2 = 0;
            while (n2 < pixelAccessorArray.length) {
                PixelAccessor pixelAccessor2 = pixelAccessorArray[n2];
                boolean bl2 = bl = bl && pixelAccessor2.indexed && pixelAccessor2.sampleType == n;
                if (!bl) break;
                ++n2;
            }
        }
        return bl;
    }

    public static final boolean packedOperation(PixelAccessor pixelAccessor, PixelAccessor pixelAccessor2) {
        return pixelAccessor.packed && pixelAccessor2.packed;
    }

    public static final boolean packedOperation(PixelAccessor pixelAccessor, PixelAccessor pixelAccessor2, PixelAccessor pixelAccessor3) {
        return pixelAccessor.packed && pixelAccessor2.packed && pixelAccessor3.packed;
    }

    public static final boolean packedOperation(PixelAccessor[] pixelAccessorArray, PixelAccessor pixelAccessor) {
        boolean bl = pixelAccessor.packed;
        if (bl && pixelAccessorArray != null) {
            int n = 0;
            while (n < pixelAccessorArray.length) {
                boolean bl2 = bl = bl && pixelAccessorArray[n].packed;
                if (!bl) break;
                ++n;
            }
        }
        return bl;
    }

    private byte[][] repeatBand(byte[] byArray, int n) {
        byte[][] byArray2 = new byte[n][];
        int n2 = 0;
        while (n2 < n) {
            byArray2[n2] = byArray;
            ++n2;
        }
        return byArray2;
    }

    private double[][] repeatBand(double[] dArray, int n) {
        double[][] dArray2 = new double[n][];
        int n2 = 0;
        while (n2 < n) {
            dArray2[n2] = dArray;
            ++n2;
        }
        return dArray2;
    }

    private float[][] repeatBand(float[] fArray, int n) {
        float[][] fArray2 = new float[n][];
        int n2 = 0;
        while (n2 < n) {
            fArray2[n2] = fArray;
            ++n2;
        }
        return fArray2;
    }

    private int[][] repeatBand(int[] nArray, int n) {
        int[][] nArray2 = new int[n][];
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = nArray;
            ++n2;
        }
        return nArray2;
    }

    private short[][] repeatBand(short[] sArray, int n) {
        short[][] sArray2 = new short[n][];
        int n2 = 0;
        while (n2 < n) {
            sArray2[n2] = sArray;
            ++n2;
        }
        return sArray2;
    }

    private void setCsmData(UnpackedPixelData unpackedPixelData, boolean bl) {
        WritableRaster writableRaster = (WritableRaster)unpackedPixelData.raster;
        Rectangle rectangle = unpackedPixelData.rect;
        int n = unpackedPixelData.dataType;
        switch (n) {
            case 1: 
            case 2: {
                short[] sArray = unpackedPixelData.getShortData(0);
                if (bl) {
                    this.clampByte(sArray, n);
                }
                UnpackedPixelData unpackedPixelData2 = this.getCsmData(writableRaster, rectangle, this.bufferType, true);
                byte[][] byArray = unpackedPixelData2.getByteData();
                int n2 = 0;
                while (n2 < this.numSamples) {
                    byte[] byArray2 = byArray[n2];
                    int n3 = unpackedPixelData2.getOffset(n2);
                    int n4 = n2;
                    int n5 = 0;
                    while (n5 < rectangle.height) {
                        int n6 = n3;
                        n3 += unpackedPixelData2.lineStride;
                        int n7 = 0;
                        while (n7 < rectangle.width) {
                            byArray2[n6] = (byte)sArray[n4];
                            n6 += unpackedPixelData2.pixelStride;
                            n4 += this.numSamples;
                            ++n7;
                        }
                        ++n5;
                    }
                    ++n2;
                }
                break;
            }
            case 3: {
                this.setIntData(writableRaster, rectangle, unpackedPixelData.getIntData(0), bl);
                break;
            }
            case 4: {
                this.setFloatData(writableRaster, rectangle, unpackedPixelData.getFloatData(0), bl);
                break;
            }
            case 5: {
                this.setDoubleData(writableRaster, rectangle, unpackedPixelData.getDoubleData(0), bl);
                break;
            }
        }
    }

    public final void setData(UnpackedPixelData unpackedPixelData) {
        this.setData(unpackedPixelData, true);
    }

    public final void setData(UnpackedPixelData unpackedPixelData, boolean bl) {
        if (!unpackedPixelData.set) {
            return;
        }
        switch (this.type) {
            case 2: {
                this.setCsmData(unpackedPixelData, bl);
                break;
            }
            case 1: {
                this.setNocmData(unpackedPixelData, bl);
                break;
            }
        }
    }

    private void setDoubleData(WritableRaster writableRaster, Rectangle rectangle, double[] dArray, boolean bl) {
        if (bl) {
            switch (this.bufferType) {
                case 0: {
                    this.clampByte(dArray, 5);
                    break;
                }
                case 1: {
                    this.clampUShort(dArray, 5);
                    break;
                }
                case 2: {
                    this.clampShort(dArray, 5);
                    break;
                }
                case 3: {
                    this.clampInt(dArray, 5);
                    break;
                }
                case 4: {
                    this.clampFloat(dArray, 5);
                    break;
                }
            }
        }
        writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, dArray);
    }

    private void setFloatData(WritableRaster writableRaster, Rectangle rectangle, float[] fArray, boolean bl) {
        if (bl) {
            switch (this.bufferType) {
                case 0: {
                    this.clampByte(fArray, 4);
                    break;
                }
                case 1: {
                    this.clampUShort(fArray, 4);
                    break;
                }
                case 2: {
                    this.clampShort(fArray, 4);
                    break;
                }
                case 3: {
                    this.clampInt(fArray, 4);
                    break;
                }
            }
        }
        writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, fArray);
    }

    public final void setIndexData(UnpackedPixelData unpackedPixelData) {
        if (!unpackedPixelData.set) {
            return;
        }
        WritableRaster writableRaster = (WritableRaster)unpackedPixelData.raster;
        Rectangle rectangle = unpackedPixelData.rect;
        if (this.isMultiPixelPackedSM) {
            Object[] objectArray = null;
            switch (this.transferType) {
                case 0: {
                    objectArray = unpackedPixelData.getByteData(0);
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = unpackedPixelData.getShortData(0);
                    break;
                }
                case 3: {
                    objectArray = unpackedPixelData.getIntData(0);
                    break;
                }
            }
            if (objectArray != null) {
                writableRaster.setDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, objectArray);
            }
        } else {
            int n = rectangle.width * rectangle.height;
            int[] nArray = null;
            switch (unpackedPixelData.dataType) {
                case 0: {
                    nArray = new int[n];
                    byte[] byArray = unpackedPixelData.getByteData(0);
                    int n2 = 0;
                    while (n2 < n) {
                        nArray[n2] = byArray[n2] & 0xFF;
                        ++n2;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    nArray = new int[n];
                    short[] sArray = unpackedPixelData.getShortData(0);
                    int n3 = 0;
                    while (n3 < n) {
                        nArray[n3] = sArray[n3] & 0xFFFF;
                        ++n3;
                    }
                    break;
                }
                case 3: {
                    nArray = unpackedPixelData.getIntData(0);
                    break;
                }
            }
            if (nArray != null) {
                writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, nArray);
            }
        }
    }

    private void setIntData(WritableRaster writableRaster, Rectangle rectangle, int[] nArray, boolean bl) {
        if (bl) {
            switch (this.bufferType) {
                case 0: {
                    this.clampByte(nArray, 3);
                    break;
                }
                case 1: {
                    this.clampUShort(nArray, 3);
                    break;
                }
                case 2: {
                    this.clampShort(nArray, 3);
                    break;
                }
            }
        }
        writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, nArray);
    }

    private void setNocmData(UnpackedPixelData unpackedPixelData, boolean bl) {
        WritableRaster writableRaster = (WritableRaster)unpackedPixelData.raster;
        Rectangle rectangle = unpackedPixelData.rect;
        int n = unpackedPixelData.dataType;
        switch (n) {
            case 0: {
                byte[] byArray = unpackedPixelData.getByteData(0);
                if (this.isMultiPixelPackedSM && this.transferType == 0) {
                    writableRaster.setDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, byArray);
                    break;
                }
                int n2 = byArray.length;
                int[] nArray = new int[n2];
                int n3 = 0;
                while (n3 < n2) {
                    nArray[n3] = byArray[n3] & 0xFF;
                    ++n3;
                }
                writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, nArray);
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = unpackedPixelData.getShortData(0);
                if (this.isMultiPixelPackedSM && this.transferType == 1) {
                    writableRaster.setDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
                    break;
                }
                if (bl && this.bufferType == 0) {
                    this.clampByte(sArray, n);
                }
                int n4 = sArray.length;
                int[] nArray = new int[n4];
                int n5 = 0;
                while (n5 < n4) {
                    nArray[n5] = sArray[n5] & 0xFFFF;
                    ++n5;
                }
                writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, nArray);
                break;
            }
            case 3: {
                this.setIntData(writableRaster, rectangle, unpackedPixelData.getIntData(0), bl);
                break;
            }
            case 4: {
                this.setFloatData(writableRaster, rectangle, unpackedPixelData.getFloatData(0), bl);
                break;
            }
            case 5: {
                this.setDoubleData(writableRaster, rectangle, unpackedPixelData.getDoubleData(0), bl);
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setPackedData(PackedPixelData packedPixelData) {
        if (!packedPixelData.set) {
            return;
        }
        Raster raster = packedPixelData.raster;
        Rectangle rectangle = packedPixelData.rect;
        byte[] byArray = packedPixelData.getData();
        if (this.isMultiPixelPackedSM && this.sampleSize[0] == 1) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)this.sampleModel;
            DataBuffer dataBuffer = raster.getDataBuffer();
            int n = dataBuffer.getOffset();
            int n2 = rectangle.x - raster.getSampleModelTranslateX();
            int n3 = rectangle.y - raster.getSampleModelTranslateY();
            int n4 = multiPixelPackedSampleModel.getScanlineStride();
            int n5 = multiPixelPackedSampleModel.getOffset(n2, n3) + n;
            int n6 = multiPixelPackedSampleModel.getOffset(n2 + rectangle.width - 1, n3) + n;
            switch (this.bufferType) {
                case 1: {
                    short[] sArray = ((DataBufferUShort)dataBuffer).getData();
                    int n7 = 0;
                    int n8 = 0;
                    while (n8 < rectangle.height) {
                        int n9 = n5;
                        while (n9 <= n6) {
                            sArray[n9] = (short)(byArray[n7++] << 8 | byArray[n7++]);
                            ++n9;
                        }
                        n5 += n4;
                        n6 += n4;
                        ++n8;
                    }
                    return;
                }
                case 3: {
                    int[] nArray = ((DataBufferInt)dataBuffer).getData();
                    int n10 = 0;
                    int n11 = 0;
                    while (n11 < rectangle.height) {
                        int n12 = n5;
                        while (n12 <= n6) {
                            nArray[n12] = byArray[n10++] << 24 | byArray[n10++] << 16 | byArray[n10++] << 8 | byArray[n10++];
                            ++n12;
                        }
                        n5 += n4;
                        n6 += n4;
                        ++n11;
                    }
                    return;
                }
                default: {
                    return;
                }
            }
        }
        WritableRaster writableRaster = (WritableRaster)raster;
        int n = packedPixelData.lineStride * 8;
        int[] nArray = new int[n];
        int n13 = 0;
        int n14 = 0;
        while (n14 < rectangle.height) {
            int n15 = 0;
            while (n15 < n) {
                nArray[n15] = byArray[n13] >>> 7 & 1;
                nArray[n15 + 1] = byArray[n13] >>> 6 & 1;
                nArray[n15 + 2] = byArray[n13] >>> 5 & 1;
                nArray[n15 + 3] = byArray[n13] >>> 4 & 1;
                nArray[n15 + 4] = byArray[n13] >>> 3 & 1;
                nArray[n15 + 5] = byArray[n13] >>> 2 & 1;
                nArray[n15 + 6] = byArray[n13] >>> 1 & 1;
                nArray[n15 + 7] = byArray[n13] & 1;
                ++n13;
                n15 += 8;
            }
            writableRaster.setPixels(rectangle.x, rectangle.y + n14, rectangle.width, 1, nArray);
            ++n14;
        }
    }
}

