/*
 * Decompiled with CFR 0.152.
 */
package com.werken.saxpath;

import com.werken.saxpath.Token;

class XPathLexer {
    private String xpath;
    private int currentPosition;
    private int endPosition;
    private Token previousToken;

    XPathLexer() {
    }

    public XPathLexer(String string) {
        this.setXPath(string);
    }

    private final char LA(int n) {
        if (this.currentPosition + (n - 1) >= this.endPosition()) {
            return '\uffff';
        }
        return this.getXPath().charAt(this.currentPosition() + (n - 1));
    }

    private final Token and() {
        Token token = null;
        if (this.LA(1) == 'a' && this.LA(2) == 'n' && this.LA(3) == 'd' && !this.isIdentifierChar(this.LA(4))) {
            token = new Token(28, this.getXPath(), this.currentPosition(), this.currentPosition() + 3);
            this.consume();
            this.consume();
            this.consume();
        }
        return token;
    }

    private final Token at() {
        Token token = new Token(16, this.getXPath(), this.currentPosition(), this.currentPosition() + 1);
        this.consume();
        return token;
    }

    private final Token colon() {
        Token token = new Token(18, this.getXPath(), this.currentPosition(), this.currentPosition() + 1);
        this.consume();
        return token;
    }

    private final Token comma() {
        Token token = new Token(32, this.getXPath(), this.currentPosition(), this.currentPosition() + 1);
        this.consume();
        return token;
    }

    private final void consume() {
        ++this.currentPosition;
    }

    private final void consume(int n) {
        this.currentPosition += n;
    }

    private final int currentPosition() {
        return this.currentPosition;
    }

    private final Token div() {
        Token token = null;
        if (this.LA(1) == 'd' && this.LA(2) == 'i' && this.LA(3) == 'v' && !this.isIdentifierChar(this.LA(4))) {
            token = new Token(24, this.getXPath(), this.currentPosition(), this.currentPosition() + 3);
            this.consume();
            this.consume();
            this.consume();
        }
        return token;
    }

    private final Token dollar() {
        Token token = new Token(26, this.getXPath(), this.currentPosition(), this.currentPosition() + 1);
        this.consume();
        return token;
    }

    private final Token dots() {
        Token token = null;
        switch (this.LA(2)) {
            case '.': {
                token = new Token(14, this.getXPath(), this.currentPosition(), this.currentPosition() + 2);
                this.consume();
                this.consume();
                break;
            }
            default: {
                token = new Token(13, this.getXPath(), this.currentPosition(), this.currentPosition() + 1);
                this.consume();
            }
        }
        return token;
    }

    private final Token doubleColon() {
        Token token = new Token(19, this.getXPath(), this.currentPosition(), this.currentPosition() + 2);
        this.consume();
        this.consume();
        return token;
    }

    private final int endPosition() {
        return this.endPosition;
    }

    private final Token equals() {
        Token token = new Token(21, this.getXPath(), this.currentPosition(), this.currentPosition() + 1);
        this.consume();
        return token;
    }

    private final Token getPreviousToken() {
        return this.previousToken;
    }

    public final String getXPath() {
        return this.xpath;
    }

    private final boolean hasMoreChars() {
        return this.currentPosition() < this.endPosition();
    }

    private final Token identifier() {
        Token token = null;
        int n = this.currentPosition();
        while (this.hasMoreChars()) {
            if (!this.isIdentifierChar(this.LA(1))) break;
            this.consume();
        }
        token = new Token(15, this.getXPath(), n, this.currentPosition());
        return token;
    }

    private final Token identifierOrOperatorName() {
        Token token = null;
        Token token2 = this.getPreviousToken();
        if (token2 != null) {
            switch (token2.getTokenType()) {
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 32: {
                    token = this.identifier();
                    break;
                }
                default: {
                    token = this.operatorName();
                    break;
                }
            }
        } else {
            token = this.identifier();
        }
        return token;
    }

    private final boolean isIdentifierChar(char c2) {
        switch (c2) {
            case '-': 
            case '.': {
                return true;
            }
        }
        return Character.isUnicodeIdentifierPart(c2);
    }

    private final boolean isIdentifierStartChar(char c2) {
        return c2 == '_' || Character.isUnicodeIdentifierStart(c2);
    }

    private final Token leftBracket() {
        Token token = new Token(3, this.getXPath(), this.currentPosition(), this.currentPosition() + 1);
        this.consume();
        return token;
    }

    private final Token leftParen() {
        Token token = new Token(1, this.getXPath(), this.currentPosition(), this.currentPosition() + 1);
        this.consume();
        return token;
    }

    private final Token literal() {
        Token token = null;
        char c2 = this.LA(1);
        this.consume();
        int n = this.currentPosition();
        while (token == null && this.hasMoreChars()) {
            if (this.LA(1) == c2) {
                token = new Token(27, this.getXPath(), n, this.currentPosition());
            }
            this.consume();
        }
        return token;
    }

    private final Token minus() {
        Token token = new Token(6, this.getXPath(), this.currentPosition(), this.currentPosition() + 1);
        this.consume();
        return token;
    }

    private final Token mod() {
        Token token = null;
        if (this.LA(1) == 'm' && this.LA(2) == 'o' && this.LA(3) == 'd' && !this.isIdentifierChar(this.LA(4))) {
            token = new Token(25, this.getXPath(), this.currentPosition(), this.currentPosition() + 3);
            this.consume();
            this.consume();
            this.consume();
        }
        return token;
    }

    public final Token nextToken() {
        Token token = null;
        do {
            token = null;
            block0 : switch (this.LA(1)) {
                case '$': {
                    token = this.dollar();
                    break;
                }
                case '\"': 
                case '\'': {
                    token = this.literal();
                    break;
                }
                case '/': {
                    token = this.slashes();
                    break;
                }
                case ',': {
                    token = this.comma();
                    break;
                }
                case '(': {
                    token = this.leftParen();
                    break;
                }
                case ')': {
                    token = this.rightParen();
                    break;
                }
                case '[': {
                    token = this.leftBracket();
                    break;
                }
                case ']': {
                    token = this.rightBracket();
                    break;
                }
                case '+': {
                    token = this.plus();
                    break;
                }
                case '-': {
                    token = this.minus();
                    break;
                }
                case '<': 
                case '>': {
                    token = this.relationalOperator();
                    break;
                }
                case '=': {
                    token = this.equals();
                    break;
                }
                case '!': {
                    if (this.LA(2) == '=') {
                        token = this.notEquals();
                        break;
                    }
                    token = this.not();
                    break;
                }
                case '|': {
                    token = this.pipe();
                    break;
                }
                case '@': {
                    token = this.at();
                    break;
                }
                case ':': {
                    if (this.LA(2) == ':') {
                        token = this.doubleColon();
                        break;
                    }
                    token = this.colon();
                    break;
                }
                case '*': {
                    token = this.star();
                    break;
                }
                case '.': {
                    switch (this.LA(2)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            token = this.number();
                            break block0;
                        }
                    }
                    token = this.dots();
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    token = this.number();
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    token = this.whitespace();
                    break;
                }
                default: {
                    if (!this.isIdentifierStartChar(this.LA(1))) break;
                    token = this.identifierOrOperatorName();
                }
            }
            if (token != null) continue;
            token = new Token(-1, this.getXPath(), this.currentPosition(), this.endPosition());
        } while (token.getTokenType() == -2);
        this.setPreviousToken(token);
        return token;
    }

    private final Token not() {
        Token token = new Token(23, this.getXPath(), this.currentPosition(), this.currentPosition() + 1);
        this.consume();
        return token;
    }

    private final Token notEquals() {
        Token token = new Token(22, this.getXPath(), this.currentPosition(), this.currentPosition() + 2);
        this.consume();
        this.consume();
        return token;
    }

    private final Token number() {
        int n = this.currentPosition();
        boolean bl = true;
        block4: while (true) {
            switch (this.LA(1)) {
                case '.': {
                    if (!bl) break block4;
                    bl = false;
                    this.consume();
                    continue block4;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.consume();
                    continue block4;
                }
            }
            break;
        }
        Token token = null;
        token = bl ? new Token(30, this.getXPath(), n, this.currentPosition()) : new Token(31, this.getXPath(), n, this.currentPosition());
        return token;
    }

    private final Token operatorName() {
        Token token = null;
        switch (this.LA(1)) {
            case 'a': {
                token = this.and();
                break;
            }
            case 'o': {
                token = this.or();
                break;
            }
            case 'm': {
                token = this.mod();
                break;
            }
            case 'd': {
                token = this.div();
                break;
            }
        }
        return token;
    }

    private final Token or() {
        Token token = null;
        if (this.LA(1) == 'o' && this.LA(2) == 'r' && !this.isIdentifierChar(this.LA(3))) {
            token = new Token(29, this.getXPath(), this.currentPosition(), this.currentPosition() + 2);
            this.consume();
            this.consume();
        }
        return token;
    }

    private final Token pipe() {
        Token token = new Token(17, this.getXPath(), this.currentPosition(), this.currentPosition() + 1);
        this.consume();
        return token;
    }

    private final Token plus() {
        Token token = new Token(5, this.getXPath(), this.currentPosition(), this.currentPosition() + 1);
        this.consume();
        return token;
    }

    private final Token relationalOperator() {
        Token token = null;
        switch (this.LA(1)) {
            case '<': {
                if (this.LA(2) == '=') {
                    token = new Token(8, this.getXPath(), this.currentPosition(), this.currentPosition() + 2);
                    this.consume();
                } else {
                    token = new Token(7, this.getXPath(), this.currentPosition(), this.currentPosition() + 1);
                }
                this.consume();
                break;
            }
            case '>': {
                if (this.LA(2) == '=') {
                    token = new Token(10, this.getXPath(), this.currentPosition(), this.currentPosition() + 2);
                    this.consume();
                } else {
                    token = new Token(9, this.getXPath(), this.currentPosition(), this.currentPosition() + 1);
                }
                this.consume();
                break;
            }
        }
        return token;
    }

    private final Token rightBracket() {
        Token token = new Token(4, this.getXPath(), this.currentPosition(), this.currentPosition() + 1);
        this.consume();
        return token;
    }

    private final Token rightParen() {
        Token token = new Token(2, this.getXPath(), this.currentPosition(), this.currentPosition() + 1);
        this.consume();
        return token;
    }

    private final void setPreviousToken(Token token) {
        this.previousToken = token;
    }

    private final void setXPath(String string) {
        this.xpath = string;
        this.currentPosition = 0;
        this.endPosition = string.length();
    }

    private final Token slashes() {
        Token token = null;
        switch (this.LA(2)) {
            case '/': {
                token = new Token(12, this.getXPath(), this.currentPosition(), this.currentPosition() + 2);
                this.consume();
                this.consume();
                break;
            }
            default: {
                token = new Token(11, this.getXPath(), this.currentPosition(), this.currentPosition() + 1);
                this.consume();
            }
        }
        return token;
    }

    private final Token star() {
        Token token = new Token(20, this.getXPath(), this.currentPosition(), this.currentPosition() + 1);
        this.consume();
        return token;
    }

    private final Token whitespace() {
        this.consume();
        block3: while (this.hasMoreChars()) {
            switch (this.LA(1)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.consume();
                    continue block3;
                }
            }
        }
        return new Token(-2, this.getXPath(), 0, 0);
    }
}

