/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.cytoscape;

import edu.mit.broad.cytoscape.CytoscapeLocationSingleton;
import edu.mit.broad.cytoscape.EnrichmentMapParameters;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;

public class CytoscapeLaunch {
    private static final Logger klog = XLogger.getLogger(CytoscapeLaunch.class);
    private String emgsea_jar = "EnrichmentMap_gsea.jar";
    private String em_jar = "EnrichmentMap.jar";
    private String commandtool_jar = "commandTool.jar";
    private String workingDirectory = "";
    private String emgsea_jar_toinstall_cyto2 = "EnrichmentMap_gsea-v1.3.0.jar";
    private String emgsea_jar_toinstall_cyto3 = "enrichmentmap-v2.0.0.jar";
    private String install_site = "http://download.baderlab.org/EM_GSEA/";
    String file_separator;
    private String java;
    private String os;
    private String pluginpath;
    private EnrichmentMapParameters params;

    public CytoscapeLaunch(EnrichmentMapParameters enrichmentMapParameters) {
        this.params = enrichmentMapParameters;
        this.os = System.getProperty("os.name").toLowerCase();
        this.file_separator = System.getProperty("file.separator");
        this.java = "java";
        this.workingDirectory = XPreferencesFactory.kDefaultReportsOutputDir.getDir(true).toString();
        this.pluginpath = CytoscapeLaunch.class.getProtectionDomain().getCodeSource().getLocation().getPath();
    }

    public final void launch() {
        String string = "";
        if (CytoscapeLocationSingleton.getInstance().getCytoscapeRootLocation() != null && this.java != null) {
            try {
                Object object;
                double d2;
                String string2 = this.createTempCommandFile();
                String string3 = this.os.startsWith("win") ? CytoscapeLocationSingleton.getInstance().getCytoscapeRootLocation() + this.file_separator + "cytoscape.bat" : CytoscapeLocationSingleton.getInstance().getCytoscapeRootLocation() + this.file_separator + "cytoscape.sh";
                String string4 = CytoscapeLocationSingleton.getInstance().getCytoscapeRootLocation() + this.file_separator + "plugins";
                if (CytoscapeLocationSingleton.getInstance().getMain_version() == 2) {
                    String string5 = string = this.os.startsWith("win") ? " \"" + string3 + "\" -p \"" + string4 + "\"" : string3 + " -p " + string4;
                }
                if (CytoscapeLocationSingleton.getInstance().getMain_version() > 2) {
                    String string6 = string = this.os.startsWith("win") ? " \"" + string3 + "\" " : string3;
                }
                if ((d2 = this.alreadyInstalled(this.em_jar)) <= 1.3 && d2 > 0.0 && !CytoscapeLocationSingleton.getInstance().isErrorMsgViewed()) {
                    Application.getWindowManager().showConfirm("An older incompatible version of Enrichment map is already installed on your system.\n  Please update to a version higher than v1.2 or uninstall your Enrichment Map plugin.  Cytoscape Launch will still work but you may experience unexpected errors.");
                    CytoscapeLocationSingleton.getInstance().setErrorMsgViewed(true);
                }
                if (CytoscapeLocationSingleton.getInstance().getMain_version() == 2) {
                    object = new File(this.workingDirectory + File.separator + this.emgsea_jar_toinstall_cyto2).exists() ? this.workingDirectory + File.separator + this.emgsea_jar_toinstall_cyto2 : this.installPlugin(this.emgsea_jar_toinstall_cyto2);
                    string = this.os.startsWith("win") ? string + " -p \"" + (String)object + "\"" : string + " -p " + (String)object;
                } else if (CytoscapeLocationSingleton.getInstance().getMain_version() == 3 && d2 < 0.0) {
                    object = new File(this.workingDirectory + File.separator + this.emgsea_jar_toinstall_cyto3).exists() ? this.workingDirectory + File.separator + this.emgsea_jar_toinstall_cyto3 : this.installPlugin(this.emgsea_jar_toinstall_cyto3);
                    String string7 = string = this.os.startsWith("win") ? string + " -p \"" + (String)object + "\"" : string + " -p " + (String)object;
                }
                if (this.alreadyInstalled(this.commandtool_jar) < 0.0 && CytoscapeLocationSingleton.getInstance().getMain_version() == 2) {
                    object = new File(this.workingDirectory + File.separator + this.commandtool_jar).exists() ? this.workingDirectory + File.separator + this.commandtool_jar : this.installPlugin(this.commandtool_jar);
                    string = this.os.startsWith("win") ? string + " -p \"" + (String)object + "\"" : string + " -p " + (String)object;
                }
                string = this.os.startsWith("win") ? string + " -S \"" + string2 + "\"" : string + " -S " + string2;
                klog.info("command issued:" + string);
                object = this.os.startsWith("win") ? Runtime.getRuntime().exec(string, null, new File(CytoscapeLocationSingleton.getInstance().getCytoscapeRootLocation())) : Runtime.getRuntime().exec(string);
            }
            catch (IOException iOException) {
                klog.info("command issued:" + string + "crashed." + iOException.getMessage());
            }
            System.gc();
        } else {
            klog.info("cytoscape root or java is null:" + this.java + "," + CytoscapeLocationSingleton.getInstance().getCytoscapeRootLocation());
        }
    }

    private String createTempCommandFile() {
        try {
            File file = File.createTempFile("gsea_em_commands", ".txt", new File(this.workingDirectory));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            String string = CytoscapeLocationSingleton.getInstance().getMain_version() == 2 ? "EnrichmentMap_gsea build edbdir=\"" + this.params.getEdbdir() + "\" pvalue=" + this.params.getPvalue() + " qvalue=" + this.params.getQvalue() + " overlap=" + this.params.getSimilarityCutOff() : "EnrichmentMap gseabuild edbdir=\"" + this.params.getEdbdir() + "\" pvalue=" + this.params.getPvalue() + " qvalue=" + this.params.getQvalue() + " overlap=" + this.params.getSimilarityCutOff();
            string = string + " similaritymetric=\"" + this.params.getSimilarityMetric() + "\" combinedconstant=" + this.params.getCombinedConstant();
            if (!this.params.getExpressionFilePath().equals("")) {
                string = string + " expressionfile=\"" + this.params.getExpressionFilePath() + "\"";
            }
            if (this.params.getEdbdir2() != null && !this.params.getEdbdir2().equalsIgnoreCase("")) {
                string = string + " edbdir2=\"" + this.params.getEdbdir2() + "\"";
                if (!this.params.getExpression2FilePath().equals("")) {
                    string = string + " expressionfile2=\"" + this.params.getExpression2FilePath() + "\"";
                }
            }
            if (this.os.startsWith("win")) {
                string = string.replace("\\", "\\\\");
            }
            bufferedWriter.write(string);
            bufferedWriter.close();
            return file.getAbsolutePath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private String installPlugin(String string) {
        if (CytoscapeLocationSingleton.getInstance().getCytoscapeConfigLocatin() != null) {
            try {
                URL uRL = new URL(this.install_site + string);
                URLConnection uRLConnection = uRL.openConnection();
                DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
                byte[] byArray = new byte[uRLConnection.getContentLength()];
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    byArray[i2] = dataInputStream.readByte();
                }
                dataInputStream.close();
                String string2 = this.workingDirectory + File.separator + string;
                FileOutputStream fileOutputStream = this.os.startsWith("win") ? new FileOutputStream(new File(string2)) : new FileOutputStream(new File(string2));
                fileOutputStream.write(byArray);
                fileOutputStream.close();
                return string2;
            }
            catch (Exception exception) {
                System.out.println(exception);
                return null;
            }
        }
        System.out.println("Cytoscape Configuration not set.  No where to install the app to");
        return null;
    }

    private double alreadyInstalled(String string) {
        Integer n;
        Integer n2;
        Object object;
        String[] stringArray;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string2;
        double d2 = -1.0;
        String string3 = string2 = string.split("\\.").length > 1 ? string.split("\\.")[0] : string;
        if (CytoscapeLocationSingleton.getInstance().getMain_version() == 2) {
            Object object6;
            object5 = new File(CytoscapeLocationSingleton.getInstance().getCytoscapeRootLocation() + this.file_separator + "plugins");
            CytoscapeLocationSingleton.getInstance().setCytoscapeConfigLocatin(((File)object5).getPath());
            object4 = ((File)object5).list();
            for (int i2 = 0; i2 < ((String[])object4).length; ++i2) {
                Integer n3;
                if (!object4[i2].equalsIgnoreCase(string) && !object4[i2].startsWith(string2)) continue;
                if (object4[i2].equalsIgnoreCase(string)) {
                    d2 = 1.0;
                    continue;
                }
                if (!object4[i2].startsWith(string2)) continue;
                object3 = object4[i2].split("-");
                Object object7 = object6 = ((String[])object3).length > 1 ? object3[1].split("\\.") : null;
                if (object6 != null && ((String[])object6).length == 3) {
                    object2 = Integer.parseInt((String)object6[0]);
                    n3 = Integer.parseInt((String)object6[1]);
                    stringArray = Integer.valueOf(Integer.parseInt((String)object6[2]));
                    d2 = (double)((Integer)object2).intValue() + (double)n3.intValue() * 0.1;
                }
                if (object6 == null || ((String[])object6).length != 2) continue;
                object2 = Integer.parseInt((String)object6[0]);
                n3 = Integer.parseInt((String)object6[1]);
                d2 = (double)((Integer)object2).intValue() + (double)n3.intValue() * 0.1;
            }
            object = System.getProperty("user.home");
            object3 = (String)object + this.file_separator + ".cytoscape" + this.file_separator + CytoscapeLocationSingleton.getInstance().getMain_version() + "." + CytoscapeLocationSingleton.getInstance().getSub_version() + this.file_separator + "plugins";
            object6 = new File((String)object3);
            if (((File)object6).isDirectory()) {
                object2 = ((File)object6).list();
                for (int i3 = 0; i3 < ((String[])object2).length; ++i3) {
                    Integer n4;
                    if (!object2[i3].startsWith(string2)) continue;
                    stringArray = ((String)object2[i3]).split("-");
                    Object object8 = n2 = stringArray.length > 1 ? stringArray[1].split("\\.") : null;
                    if (n2 != null && ((Integer)n2).length == 3) {
                        n = Integer.parseInt((String)((Object)n2[0]));
                        n4 = Integer.parseInt((String)((Object)n2[1]));
                        Integer n5 = Integer.parseInt((String)((Object)n2[2]));
                        d2 = (double)n.intValue() + (double)n4.intValue() * 0.1;
                    }
                    if (n2 == null || ((Integer)n2).length != 2) continue;
                    n = Integer.parseInt((String)((Object)n2[0]));
                    n4 = Integer.parseInt((String)((Object)n2[1]));
                    d2 = (double)n.intValue() + (double)n4.intValue() * 0.1;
                }
            }
        }
        if (CytoscapeLocationSingleton.getInstance().getMain_version() == 3 && ((File)(object = new File((String)(object4 = (String)(object5 = System.getProperty("user.home")) + this.file_separator + "CytoscapeConfiguration" + this.file_separator + CytoscapeLocationSingleton.getInstance().getMain_version() + this.file_separator + "apps" + this.file_separator + "installed")))).isDirectory()) {
            CytoscapeLocationSingleton.getInstance().setCytoscapeConfigLocatin((String)object4);
            object3 = ((File)object).list();
            for (int i4 = 0; i4 < ((String[])object3).length; ++i4) {
                String[] stringArray2;
                if (!object3[i4].startsWith(string2)) continue;
                object2 = object3[i4].split("-v");
                String[] stringArray3 = stringArray2 = ((String[])object2).length > 1 ? object2[1].split("\\.") : null;
                if (stringArray2 != null && stringArray2.length == 3) {
                    stringArray = Integer.parseInt(stringArray2[0]);
                    n2 = Integer.parseInt(stringArray2[1]);
                    n = Integer.parseInt(stringArray2[2]);
                    d2 = (double)stringArray.intValue() + (double)n2.intValue() * 0.1;
                }
                if (stringArray2 == null || stringArray2.length != 2) continue;
                stringArray = Integer.parseInt(stringArray2[0]);
                n2 = Integer.parseInt(stringArray2[1]);
                d2 = (double)stringArray.intValue() + (double)n2.intValue() * 0.1;
            }
        }
        return d2;
    }
}

