/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.cytoscape;

import edu.mit.broad.cytoscape.CytoscapeLocationSingleton$OnlyCyto;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.awt.Desktop;
import java.io.File;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class CytoscapeLocationSingleton {
    private static CytoscapeLocationSingleton locationInfo = null;
    private String cytoscapeRootLocation = null;
    private String cytoscapeConfigLocatin = null;
    private static final Logger klog = XLogger.getLogger(CytoscapeLocationSingleton.class);
    private Integer main_version = 0;
    private Integer sub_version = 0;
    private String cytoscape_download_url = "http://www.cytoscape.org/download.html";
    private boolean errorMsgviewed = false;

    public static final CytoscapeLocationSingleton getInstance() {
        if (locationInfo == null || CytoscapeLocationSingleton.locationInfo.cytoscapeRootLocation == null || CytoscapeLocationSingleton.locationInfo.cytoscapeRootLocation == "") {
            locationInfo = new CytoscapeLocationSingleton();
        }
        return locationInfo;
    }

    private CytoscapeLocationSingleton() {
        System.out.println(XPreferencesFactory.kCytoscapeDirectory.getValue().toString());
        if (XPreferencesFactory.kCytoscapeDirectory.getValue().toString().equalsIgnoreCase("Cytoscape not set yet") || XPreferencesFactory.kCytoscapeDirectory.getValue().toString().equalsIgnoreCase("null") || XPreferencesFactory.kCytoscapeDirectory.getValue().toString().equalsIgnoreCase("")) {
            this.cytoscapeRootLocation = this.getCytoscapeLocation();
        } else {
            this.cytoscapeRootLocation = XPreferencesFactory.kCytoscapeDirectory.getDir(false).toString();
            this.setCytoscapeRootLocation(this.cytoscapeRootLocation);
            if (!new File(this.cytoscapeRootLocation).exists() || this.main_version < 3) {
                this.cytoscapeRootLocation = this.getCytoscapeLocation();
            }
        }
    }

    private String getCytoscapeLocation() {
        File file;
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = "";
        if (string.startsWith("mac")) {
            file = new File("/Applications");
            String[] stringArray = file.list(new CytoscapeLocationSingleton$OnlyCyto(this, "Cytoscape"));
            string2 = "/Applications/" + this.getLatestCytoscapeVersion(stringArray);
            if (string2.equalsIgnoreCase("/Applications/")) {
                string2 = "";
            }
            if (string2 == null || string2.equals("")) {
                klog.info("No compatible version of cytoscape is installed");
                string2 = this.RedirectCytoscapeDownload();
            }
        } else if (string.startsWith("win")) {
            file = new File("C:\\Program Files");
            String[] stringArray = file.list(new CytoscapeLocationSingleton$OnlyCyto(this, "Cytoscape"));
            string2 = "C:\\Program Files\\" + this.getLatestCytoscapeVersion(stringArray);
            if (string2.equalsIgnoreCase("C:\\Program Files\\")) {
                string2 = "";
            }
            if (string2 == null || string2.equals("")) {
                klog.info("No compatible version of cytoscape is installed");
                string2 = this.RedirectCytoscapeDownload();
            }
        } else if (!string.startsWith("unix")) {
            klog.debug("Your OS:" + string + " is not supported");
        }
        try {
            if (string2 != null || string2 != "") {
                XPreferencesFactory.kCytoscapeDirectory.setValue(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private String getLatestCytoscapeVersion(String[] stringArray) {
        String string = "";
        Integer n = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2].split("Cytoscape_v")[1];
            String[] stringArray2 = string2.split("\\.");
            if (stringArray2.length != 3) continue;
            try {
                Integer n2 = Integer.parseInt(stringArray2[0]);
                Integer n3 = Integer.parseInt(stringArray2[1]);
                Integer n4 = Integer.parseInt(stringArray2[2]);
                if (!string.equals("") && this.main_version >= n2 && this.sub_version >= n3 && n >= n4 || n2 >= 3) continue;
                string = stringArray[i2];
                this.main_version = n2;
                this.sub_version = n3;
                n = n4;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        klog.info("Latest version of cytoscape is:" + string);
        return string;
    }

    private String RedirectCytoscapeDownload() {
        String string = "";
        try {
            Object[] objectArray = new String[]{"Download", "Locate"};
            int n = JOptionPane.showOptionDialog(null, "Unable to find Cytoscape 2.8 on your System.\n Would you like to install it?\n Or navigate to the directory where it is installed?\n PLEASE make sure to install CYTOSCAPE 2.8", "Cytoscape Not found", 0, 2, null, objectArray, objectArray[0]);
            if (n == 0) {
                Desktop.getDesktop().browse(new URL(this.cytoscape_download_url).toURI());
            } else if (n == 1) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(1);
                int n2 = jFileChooser.showOpenDialog(null);
                if (n2 == 0) {
                    File file = jFileChooser.getSelectedFile();
                    string = file.getAbsolutePath();
                    String string2 = file.getCanonicalPath().split("Cytoscape_v")[1];
                    String[] stringArray = string2.split("\\.");
                    if (stringArray.length > 1) {
                        this.main_version = Integer.parseInt(stringArray[0]);
                        this.sub_version = Integer.parseInt(stringArray[1]);
                    } else {
                        System.out.println("Can't calculate cytoscape version from specified location");
                    }
                } else {
                    System.out.println("Open command cancelled by user.\n");
                }
            }
        }
        catch (Throwable throwable) {
            Application.getWindowManager().showError(throwable);
        }
        return string;
    }

    public final String getCytoscapeRootLocation() {
        return this.cytoscapeRootLocation;
    }

    public final void setCytoscapeRootLocation(String string) {
        this.cytoscapeRootLocation = string;
        String string2 = this.cytoscapeRootLocation.split("Cytoscape_v")[1];
        String[] stringArray = string2.split("\\.");
        if (stringArray.length == 3) {
            this.main_version = Integer.parseInt(stringArray[0]);
            this.sub_version = Integer.parseInt(stringArray[1]);
            Integer n = Integer.parseInt(stringArray[2]);
        }
    }

    public final Integer getMain_version() {
        return this.main_version;
    }

    public final void setMain_version(Integer n) {
        this.main_version = n;
    }

    public final Integer getSub_version() {
        return this.sub_version;
    }

    public final void setSub_version(Integer n) {
        this.sub_version = n;
    }

    public final boolean isErrorMsgViewed() {
        return this.errorMsgviewed;
    }

    public final void setErrorMsgViewed(boolean bl) {
        this.errorMsgviewed = bl;
    }

    public final String getCytoscapeConfigLocatin() {
        return this.cytoscapeConfigLocatin;
    }

    public final void setCytoscapeConfigLocatin(String string) {
        this.cytoscapeConfigLocatin = string;
    }
}

